/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.metrics.CommonProcessingMetrics;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.distributor.core.PriorityTaskQueue;
import fr.gouv.vitam.processing.distributor.core.WorkerInformation;
import fr.gouv.vitam.worker.client.exception.WorkerExecutorException;
import io.prometheus.client.Gauge;
import java.util.concurrent.atomic.AtomicBoolean;

public class WorkerExecutor
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerExecutor.class);
    private final AtomicBoolean mustStop;
    private final PriorityTaskQueue<Runnable> queue;
    private final WorkerBean workerBean;

    public WorkerExecutor(PriorityTaskQueue<Runnable> queue, WorkerBean workerBean) {
        this.workerBean = workerBean;
        this.mustStop = new AtomicBoolean(false);
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            WorkerInformation.getWorkerThreadLocal().get().setWorkerBean(this.workerBean);
            while (!this.mustStop.get()) {
                Runnable task = this.queue.take();
                if (this.mustStop.get()) {
                    this.queue.addHighPriorityEntry(task);
                    break;
                }
                ((Gauge.Child)CommonProcessingMetrics.WORKER_TASKS_IN_QUEUE.labels(new String[]{this.workerBean.getFamily()})).dec();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Start task run on worker: " + this.workerBean.getName());
                }
                try {
                    task.run();
                }
                finally {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("End task run on worker: " + this.workerBean.getName());
                }
            }
        }
        catch (Exception e) {
            throw new WorkerExecutorException(this.workerBean.getWorkerId(), (Throwable)e);
        }
    }

    public void stop() {
        this.mustStop.set(true);
    }

    public WorkerBean getWorkerBean() {
        return this.workerBean;
    }
}

