/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.Distribution;
import fr.gouv.vitam.common.model.processing.DistributionKind;
import fr.gouv.vitam.common.model.processing.DistributionType;
import fr.gouv.vitam.common.model.processing.PauseOrCancelAction;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.AsyncResourceCallback;
import fr.gouv.vitam.processing.common.async.WorkflowInterruptionChecker;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.WorkerFamilyNotFoundException;
import fr.gouv.vitam.processing.common.metrics.CommonProcessingMetrics;
import fr.gouv.vitam.processing.common.model.DistributorIndex;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import fr.gouv.vitam.processing.common.parameter.DefaultWorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.processing.data.core.management.WorkspaceProcessDataManagement;
import fr.gouv.vitam.processing.distributor.api.IWorkerManager;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.distributor.core.AsyncResourceCleaner;
import fr.gouv.vitam.processing.distributor.core.AsyncResourcesMonitor;
import fr.gouv.vitam.processing.distributor.core.WorkerFamilyManager;
import fr.gouv.vitam.processing.distributor.core.WorkerTask;
import fr.gouv.vitam.processing.distributor.core.WorkerTaskResult;
import fr.gouv.vitam.worker.client.WorkerClientFactory;
import fr.gouv.vitam.worker.client.exception.PauseCancelException;
import fr.gouv.vitam.worker.client.exception.WorkerUnreachableException;
import fr.gouv.vitam.worker.common.DescriptionStep;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.workspace.client.WorkspaceBufferingInputStream;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.prometheus.client.Gauge;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class ProcessDistributorImpl
implements ProcessDistributor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessDistributorImpl.class);
    private static final String AN_EXCEPTION_HAS_BEEN_THROWN_WHEN_TRYING_TO_GET_DISTIBUTOR_INDEX_FROM_WORKSPACE = "An exception has been thrown when trying to get distributor index from workspace";
    private static final String AN_EXCEPTION_HAS_BEEN_THROWN_WHEN_TRYING_TO_PERSIST_DISTRIBUTOR_INDEX = "An Exception has been thrown when trying to persist DistributorIndex";
    private static final TypeReference<List<URI>> LIST_URI_TYPE_REFERENCE = new TypeReference<List<URI>>(){};
    private final ProcessDataManagement processDataManagement;
    private final AsyncResourcesMonitor asyncResourcesMonitor;
    private final AsyncResourceCleaner asyncResourceCleaner;
    private final IWorkerManager workerManager;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final WorkerClientFactory workerClientFactory;
    private final ServerConfiguration serverConfiguration;

    public ProcessDistributorImpl(IWorkerManager workerManager, AsyncResourcesMonitor asyncResourcesMonitor, AsyncResourceCleaner asyncResourceCleaner, ServerConfiguration serverConfiguration) {
        this(workerManager, asyncResourcesMonitor, asyncResourceCleaner, serverConfiguration, WorkspaceProcessDataManagement.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), MetaDataClientFactory.getInstance(), null);
    }

    @VisibleForTesting
    public ProcessDistributorImpl(IWorkerManager workerManager, AsyncResourcesMonitor asyncResourcesMonitor, AsyncResourceCleaner asyncResourceCleaner, ServerConfiguration serverConfiguration, ProcessDataManagement processDataManagement, WorkspaceClientFactory workspaceClientFactory, MetaDataClientFactory metaDataClientFactory, WorkerClientFactory workerClientFactory) {
        this.workerManager = workerManager;
        this.asyncResourcesMonitor = asyncResourcesMonitor;
        this.asyncResourceCleaner = asyncResourceCleaner;
        this.serverConfiguration = serverConfiguration;
        this.workspaceClientFactory = workspaceClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.workerClientFactory = workerClientFactory;
        this.processDataManagement = processDataManagement;
        ParametersChecker.checkParameter((String)"Parameters are required.", (Object[])new Object[]{workerManager, asyncResourcesMonitor, asyncResourceCleaner, serverConfiguration, processDataManagement, metaDataClientFactory, workspaceClientFactory});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStatus distribute(WorkerParameters workParams, Step step, String operationId) {
        block57: {
            ParametersChecker.checkParameter((String)"WorkParams is a mandatory parameter", (Object[])new Object[]{workParams});
            ParametersChecker.checkParameter((String)"Step is a mandatory parameter", (Object[])new Object[]{step});
            ParametersChecker.checkParameter((String)"workflowId is a mandatory parameter", (String[])new String[]{operationId});
            boolean useDistributorIndex = PauseOrCancelAction.ACTION_RECOVER.equals((Object)step.getPauseOrCancelAction());
            int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            step.setStepResponses(new ItemStatus(step.getStepName()));
            try (MetaDataClient metadataClient = this.metaDataClientFactory.getClient();){
                try {
                    metadataClient.refreshUnits();
                    metadataClient.refreshObjectGroups();
                }
                catch (MetaDataClientServerException e) {
                    LOGGER.error("Error while refresh metadata indexes", (Throwable)e);
                    ItemStatus itemStatus = step.getStepResponses().increment(StatusCode.FATAL);
                    if (metadataClient != null) {
                        metadataClient.close();
                    }
                    return itemStatus;
                }
            }
            try {
                ArrayList<String> objectsList;
                block59: {
                    block58: {
                        objectsList = new ArrayList<String>();
                        if (!step.getDistribution().getKind().equals((Object)DistributionKind.LIST_ORDERING_IN_FILE)) break block58;
                        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                            JsonNode levelFileJson;
                            if (DistributionType.Units != step.getDistribution().getType()) break block57;
                            Response response = null;
                            InputStream levelFile = null;
                            try {
                                response = workspaceClient.getObject(workParams.getContainerName(), step.getDistribution().getElement());
                                levelFile = (InputStream)response.getEntity();
                                levelFileJson = JsonHandler.getFromInputStream((InputStream)levelFile);
                            }
                            catch (Throwable throwable) {
                                StreamUtils.closeSilently(levelFile);
                                workspaceClient.consumeAnyEntityAndClose(response);
                                throw throwable;
                            }
                            StreamUtils.closeSilently((InputStream)levelFile);
                            workspaceClient.consumeAnyEntityAndClose(response);
                            Iterator iteratorLevelFile = levelFileJson.fields();
                            boolean distributeOnListIsCalledAtLeastOneTime = false;
                            while (iteratorLevelFile.hasNext()) {
                                Map.Entry guidFieldList = (Map.Entry)iteratorLevelFile.next();
                                String level = (String)guidFieldList.getKey();
                                JsonNode guid = (JsonNode)guidFieldList.getValue();
                                if (guid == null || guid.size() <= 0) continue;
                                for (JsonNode _idGuid : guid) {
                                    objectsList.add(_idGuid.asText() + ".json");
                                }
                                distributeOnListIsCalledAtLeastOneTime = true;
                                boolean distributorIndexUsed = this.distributeOnList(workParams, step, level, objectsList, useDistributorIndex, tenantId);
                                if (useDistributorIndex && distributorIndexUsed) {
                                    useDistributorIndex = false;
                                }
                                objectsList.clear();
                                if (!step.getStepResponses().getGlobalStatus().isGreaterOrEqualToFatal()) continue;
                                break;
                            }
                            if (!distributeOnListIsCalledAtLeastOneTime) {
                                step.getStepResponses().increment(StatusCode.OK);
                            }
                            break block57;
                        }
                    }
                    if (step.getDistribution().getKind().equals((Object)DistributionKind.LIST_IN_DIRECTORY)) {
                        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                            List objectsListUri = (List)JsonHandler.getFromStringAsTypeReference((String)workspaceClient.getListUriDigitalObjectFromFolder(workParams.getContainerName(), step.getDistribution().getElement()).toJsonNode().get("$results").get(0).toString(), LIST_URI_TYPE_REFERENCE);
                            for (URI uri : objectsListUri) {
                                objectsList.add(uri.getPath());
                            }
                            workParams.setObjectMetadataList(Collections.emptyList());
                            this.distributeOnList(workParams, step, "_no_level", objectsList, useDistributorIndex, tenantId);
                            break block57;
                        }
                    }
                    if (!step.getDistribution().getKind().equals((Object)DistributionKind.LIST_IN_FILE)) break block59;
                    try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                        JsonNode ogIdList;
                        Response response = null;
                        try {
                            response = workspaceClient.getObject(workParams.getContainerName(), step.getDistribution().getElement());
                            ogIdList = JsonHandler.getFromInputStream((InputStream)((InputStream)response.getEntity()));
                        }
                        catch (Throwable throwable) {
                            workspaceClient.consumeAnyEntityAndClose(response);
                            throw throwable;
                        }
                        workspaceClient.consumeAnyEntityAndClose(response);
                        if (ogIdList.isArray()) {
                            for (JsonNode node : ogIdList) {
                                objectsList.add(node.textValue());
                            }
                        }
                        this.distributeOnList(workParams, step, "_no_level", objectsList, useDistributorIndex, tenantId);
                        break block57;
                    }
                }
                if (step.getDistribution().getKind().equals((Object)DistributionKind.LIST_IN_JSONL_FILE)) {
                    File tmpDirectory = new File(VitamConfiguration.getVitamTmpFolder());
                    try (WorkspaceBufferingInputStream inputStream = new WorkspaceBufferingInputStream(this.workspaceClientFactory, workParams.getContainerName(), step.getDistribution().getElement(), this.serverConfiguration.getMaxDistributionOnDiskBufferSize().intValue(), this.serverConfiguration.getMaxDistributionInMemoryBufferSize().intValue(), tmpDirectory);
                         BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                        this.distributeOnStream(workParams, step, br, useDistributorIndex, tenantId);
                        break block57;
                    }
                }
                if (step.getDistribution().getElement() == null || step.getDistribution().getElement().trim().isEmpty()) {
                    objectsList.add(workParams.getContainerName());
                } else {
                    objectsList.add(step.getDistribution().getElement());
                }
                this.distributeOnList(workParams, step, "_no_level", objectsList, useDistributorIndex, tenantId);
            }
            catch (PauseCancelException e) {
                LOGGER.debug("Operation Cancel", (Throwable)e);
                return step.getStepResponses();
            }
            catch (Exception e) {
                step.getStepResponses().increment(StatusCode.FATAL);
                LOGGER.error("Exception thrown by the process distributor during running...", (Throwable)e);
            }
        }
        if (step.getStepResponses().getGlobalStatus().isGreaterOrEqualToFatal()) {
            return step.getStepResponses();
        }
        return step.setPauseOrCancelAction(PauseOrCancelAction.ACTION_COMPLETE).getStepResponses();
    }

    private boolean distributeOnList(WorkerParameters workerParameters, Step step, String level, List<String> objectsList, boolean initFromDistributorIndex, Integer tenantId) throws ProcessingException {
        String operationId = workerParameters.getContainerName();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        String contractId = VitamThreadUtils.getVitamSession().getContractId();
        String contextId = VitamThreadUtils.getVitamSession().getContextId();
        String applicationId = VitamThreadUtils.getVitamSession().getApplicationSessionId();
        String uniqueStepId = step.getId();
        if (objectsList == null || objectsList.isEmpty()) {
            step.getStepResponses().setItemsStatus("OBJECTS_LIST_EMPTY", new ItemStatus("OBJECTS_LIST_EMPTY").increment(step.getDistribution().getStatusOnEmptyDistribution()));
            return false;
        }
        int offset = 0;
        int sizeList = objectsList.size();
        boolean updateElementToProcess = true;
        ArrayList remainingElementsFromRecover = new ArrayList();
        if (initFromDistributorIndex) {
            try {
                Optional distributorIndexOptional = this.processDataManagement.getDistributorIndex(operationId);
                if (distributorIndexOptional.isPresent() && ((DistributorIndex)distributorIndexOptional.get()).getStepId().equals(step.getId())) {
                    DistributorIndex distributorIndex = (DistributorIndex)distributorIndexOptional.get();
                    if (!distributorIndex.getLevel().equals(level)) {
                        return false;
                    }
                    if (distributorIndex.isLevelFinished()) {
                        step.setStepResponses(distributorIndex.getItemStatus());
                        step.getStepResponses().clearStatusMeterFatal();
                        return true;
                    }
                    offset = distributorIndex.getOffset();
                    step.setStepResponses(distributorIndex.getItemStatus());
                    updateElementToProcess = false;
                    if (null != distributorIndex.getRemainingElements()) {
                        remainingElementsFromRecover.addAll(distributorIndex.getRemainingElements());
                    }
                }
            }
            catch (Exception e) {
                throw new ProcessingException("Can't get distributor index from workspace", (Throwable)e);
            }
        }
        step.getStepResponses().clearStatusMeterFatal();
        if (updateElementToProcess) {
            ProcessStep processStep = (ProcessStep)step;
            processStep.getElementToProcess().addAndGet(sizeList);
        }
        while (offset < sizeList) {
            int bulkSize = this.findBulkSize(step.getDistribution());
            int batchSize = VitamConfiguration.getDistributeurBatchSize() * bulkSize;
            int nextOffset = Math.min(sizeList, offset + batchSize);
            List<String> subList = objectsList.subList(offset, nextOffset);
            boolean emptyRemainingElements = remainingElementsFromRecover.isEmpty();
            if (!emptyRemainingElements) {
                subList = new ArrayList<String>(subList);
                subList.retainAll(remainingElementsFromRecover);
                remainingElementsFromRecover.clear();
            }
            List<WorkerTask> workerTaskList = this.createWorkerTasks(workerParameters, step, tenantId, requestId, contractId, contextId, applicationId, bulkSize, subList);
            List<WorkerTaskResult> workerTaskResults = this.executeWorkerTasks(step, workerParameters, workerTaskList);
            ItemStatus itemStatus = step.getStepResponses();
            this.updateStepWithTaskResults(workerTaskResults, step);
            List<String> remainingElements = this.getRemainingElements(workerTaskResults, itemStatus);
            offset = this.getNextOffset(offset, nextOffset, remainingElements, itemStatus);
            DistributorIndex distributorIndex = new DistributorIndex(level, offset, itemStatus, requestId, uniqueStepId, remainingElements);
            if (offset >= sizeList && !itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) {
                distributorIndex.setLevelFinished(true);
            }
            this.updatePersistedDistributorIndexIfNotFatal(operationId, offset, distributorIndex, itemStatus, "Error while persist DistributorIndex");
            this.checkCancelledOrPaused(step);
            if (!itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) continue;
            return true;
        }
        return true;
    }

    private void updatePersistedDistributorIndexIfNotFatal(String operationId, int offset, DistributorIndex distributorIndex, ItemStatus itemStatus, String message) throws ProcessingException {
        try {
            this.processDataManagement.persistDistributorIndex(operationId, distributorIndex);
            LOGGER.debug("Store for the container " + operationId + " the DistributorIndex offset" + offset + " GlobalStatus " + itemStatus.getGlobalStatus());
        }
        catch (Exception e) {
            throw new ProcessingException(message, (Throwable)e);
        }
    }

    @VisibleForTesting
    Integer findBulkSize(Distribution distribution) {
        return (Integer)MoreObjects.firstNonNull((Object)distribution.getBulkSize(), (Object)VitamConfiguration.getWorkerBulkSize());
    }

    private void distributeOnStream(WorkerParameters workerParameters, Step step, BufferedReader bufferedReader, boolean initFromDistributorIndex, Integer tenantId) throws ProcessingException {
        boolean isEmptyDistribution;
        String operationId = workerParameters.getContainerName();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        String contractId = VitamThreadUtils.getVitamSession().getContractId();
        String contextId = VitamThreadUtils.getVitamSession().getContextId();
        String applicationId = VitamThreadUtils.getVitamSession().getApplicationSessionId();
        int offset = 0;
        boolean updateElementToProcess = true;
        ArrayList remainingElementsFromRecover = new ArrayList();
        if (initFromDistributorIndex) {
            try {
                Optional distributorIndexOptional = this.processDataManagement.getDistributorIndex(operationId);
                if (distributorIndexOptional.isPresent() && ((DistributorIndex)distributorIndexOptional.get()).getStepId().equals(step.getId())) {
                    DistributorIndex distributorIndex = (DistributorIndex)distributorIndexOptional.get();
                    if (distributorIndex.isLevelFinished()) {
                        step.setStepResponses(distributorIndex.getItemStatus());
                        step.getStepResponses().clearStatusMeterFatal();
                        return;
                    }
                    offset = distributorIndex.getOffset();
                    this.skipOffsetLines(bufferedReader, offset);
                    step.setStepResponses(distributorIndex.getItemStatus());
                    updateElementToProcess = false;
                    if (distributorIndex.getRemainingElements() != null && !distributorIndex.getRemainingElements().isEmpty()) {
                        remainingElementsFromRecover.addAll(distributorIndex.getRemainingElements());
                    }
                }
            }
            catch (VitamException e) {
                throw new ProcessingException(AN_EXCEPTION_HAS_BEEN_THROWN_WHEN_TRYING_TO_GET_DISTIBUTOR_INDEX_FROM_WORKSPACE, (Throwable)e);
            }
        }
        step.getStepResponses().clearStatusMeterFatal();
        int bulkSize = this.findBulkSize(step.getDistribution());
        int globalBatchSize = VitamConfiguration.getDistributeurBatchSize() * bulkSize;
        PeekingIterator linesPeekIterator = new PeekingIterator(bufferedReader.lines().iterator());
        boolean bl = isEmptyDistribution = !initFromDistributorIndex && !linesPeekIterator.hasNext();
        if (isEmptyDistribution) {
            step.getStepResponses().setItemsStatus("OBJECTS_LIST_EMPTY", new ItemStatus("OBJECTS_LIST_EMPTY").increment(step.getDistribution().getStatusOnEmptyDistribution()));
            return;
        }
        while (linesPeekIterator.hasNext()) {
            int maxOffset = offset + globalBatchSize;
            ArrayList<JsonLineModel> distributionList = new ArrayList<JsonLineModel>();
            int lastElementOffset = offset;
            while (lastElementOffset < maxOffset && linesPeekIterator.hasNext()) {
                boolean isLevelCompatible;
                JsonLineModel currentJsonLineModel = this.readJsonLineModelFromBufferFromString((String)linesPeekIterator.next());
                distributionList.add(currentJsonLineModel);
                ++lastElementOffset;
                JsonLineModel nextJsonLineModel = null;
                if (linesPeekIterator.hasNext()) {
                    nextJsonLineModel = this.readJsonLineModelFromBufferFromString((String)linesPeekIterator.peek());
                }
                if (!(isLevelCompatible = nextJsonLineModel != null && currentJsonLineModel.getDistribGroup() != null && nextJsonLineModel.getDistribGroup() != null && !currentJsonLineModel.getDistribGroup().equals(nextJsonLineModel.getDistribGroup()))) continue;
                break;
            }
            if (updateElementToProcess) {
                ProcessStep processStep = (ProcessStep)step;
                processStep.getElementToProcess().addAndGet(distributionList.size());
            }
            if (!remainingElementsFromRecover.isEmpty()) {
                ArrayList<JsonLineModel> retainedList = new ArrayList<JsonLineModel>();
                for (JsonLineModel model : distributionList) {
                    if (!remainingElementsFromRecover.contains(model.getId())) continue;
                    retainedList.add(model);
                }
                distributionList = retainedList;
                remainingElementsFromRecover.clear();
            }
            List<WorkerTask> workerTaskList = this.createWorkerTasksOnStream(workerParameters, step, tenantId, requestId, contractId, contextId, applicationId, bulkSize, distributionList);
            List<WorkerTaskResult> workerTaskResults = this.executeWorkerTasks(step, workerParameters, workerTaskList);
            ItemStatus itemStatus = step.getStepResponses();
            this.updateStepWithTaskResults(workerTaskResults, step);
            List<String> remainingElements = this.getRemainingElements(workerTaskResults, itemStatus);
            offset = this.getNextOffset(offset, lastElementOffset, remainingElements, itemStatus);
            DistributorIndex distributorIndex = new DistributorIndex("_no_level", offset, itemStatus, requestId, step.getId(), remainingElements);
            if (!linesPeekIterator.hasNext() && !itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) {
                distributorIndex.setLevelFinished(true);
            }
            this.updatePersistedDistributorIndexIfNotFatal(operationId, offset, distributorIndex, itemStatus, AN_EXCEPTION_HAS_BEEN_THROWN_WHEN_TRYING_TO_PERSIST_DISTRIBUTOR_INDEX);
            this.checkCancelledOrPaused(step);
            if (!itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) continue;
            return;
        }
    }

    private void skipOffsetLines(BufferedReader bufferedReader, int offset) throws ProcessingException {
        try {
            for (int i = 0; i < offset; ++i) {
                bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private JsonLineModel readJsonLineModelFromBufferFromString(String value) throws ProcessingException {
        try {
            return (JsonLineModel)JsonHandler.getFromString((String)value, JsonLineModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException("Invalid Model", (Throwable)e);
        }
    }

    private List<WorkerTask> createWorkerTasks(WorkerParameters workerParameters, Step step, Integer tenantId, String requestId, String contractId, String contextId, String applicationId, int bulkSize, List<String> subList) {
        UnmodifiableIterator distributionSubListBulkIterator = Iterators.partition(subList.iterator(), (int)bulkSize);
        ArrayList<WorkerTask> workerTaskList = new ArrayList<WorkerTask>();
        distributionSubListBulkIterator.forEachRemaining(objectNames -> {
            DefaultWorkerParameters taskWorkerParams = ((DefaultWorkerParameters)workerParameters).newInstance();
            taskWorkerParams.setObjectNameList(objectNames);
            workerTaskList.add(new WorkerTask(new DescriptionStep(step, (WorkerParameters)taskWorkerParams), tenantId, requestId, contractId, contextId, applicationId, this.workerClientFactory));
        });
        return workerTaskList;
    }

    private List<WorkerTask> createWorkerTasksOnStream(WorkerParameters workerParameters, Step step, Integer tenantId, String requestId, String contractId, String contextId, String applicationId, int bulkSize, List<JsonLineModel> distributionList) {
        UnmodifiableIterator batchIterator = Iterators.partition(distributionList.iterator(), (int)bulkSize);
        ArrayList<WorkerTask> workerTaskList = new ArrayList<WorkerTask>();
        batchIterator.forEachRemaining(entryList -> {
            DefaultWorkerParameters taskWorkerParams = ((DefaultWorkerParameters)workerParameters).newInstance();
            taskWorkerParams.setObjectNameList(entryList.stream().map(JsonLineModel::getId).collect(Collectors.toList()));
            taskWorkerParams.setObjectMetadataList(entryList.stream().map(JsonLineModel::getParams).collect(Collectors.toList()));
            workerTaskList.add(new WorkerTask(new DescriptionStep(step, (WorkerParameters)taskWorkerParams), tenantId, requestId, contractId, contextId, applicationId, this.workerClientFactory));
        });
        return workerTaskList;
    }

    private List<WorkerTaskResult> executeWorkerTasks(Step step, WorkerParameters workerParameters, List<WorkerTask> workerTaskList) throws ProcessingException {
        int queueSize = workerTaskList.size();
        ArrayBlockingQueue<WorkerTaskResult> resultQueue = new ArrayBlockingQueue<WorkerTaskResult>(queueSize);
        this.scheduleWorkerTasks(step, workerParameters, workerTaskList, resultQueue);
        return ProcessDistributorImpl.awaitCompletion(resultQueue, queueSize);
    }

    private void scheduleWorkerTasks(Step step, WorkerParameters workerParameters, List<WorkerTask> workerTaskList, Queue<WorkerTaskResult> resultQueue) {
        for (WorkerTask workerTask : workerTaskList) {
            if (this.isCanceledOrPaused(step)) {
                resultQueue.add(WorkerTaskResult.ofPausedOrCanceledTask(workerTask));
                continue;
            }
            this.scheduleTaskInExecutionBlockingQueue(workerTask, workerParameters.getLogbookTypeProcess(), resultQueue);
        }
    }

    private static List<WorkerTaskResult> awaitCompletion(BlockingQueue<WorkerTaskResult> resultQueue, int nbMessages) throws ProcessingException {
        try {
            ArrayList<WorkerTaskResult> workerTaskResults = new ArrayList<WorkerTaskResult>();
            for (int i = 0; i < nbMessages; ++i) {
                workerTaskResults.add(resultQueue.take());
            }
            return workerTaskResults;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ProcessingException((Throwable)e);
        }
    }

    private void updateStepWithTaskResults(List<WorkerTaskResult> workerTaskResults, Step step) {
        workerTaskResults.stream().filter(result -> !result.isPausedOrCanceled()).forEach(result -> step.getStepResponses().setItemsStatus(result.getItemStatus()));
        int processedElements = workerTaskResults.stream().filter(result -> !result.isPausedOrCanceled() && !StatusCode.FATAL.equals((Object)result.getItemStatus().getGlobalStatus())).mapToInt(result -> result.getWorkerTask().getObjectNameList().size()).sum();
        ((ProcessStep)step).getElementProcessed().addAndGet(processedElements);
    }

    private List<String> getRemainingElements(List<WorkerTaskResult> workerTaskResults, ItemStatus itemStatus) {
        if (itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) {
            return Collections.emptyList();
        }
        return workerTaskResults.stream().filter(workerTaskResult -> !workerTaskResult.isProcessed()).flatMap(workerTaskResult -> workerTaskResult.getWorkerTask().getObjectNameList().stream()).collect(Collectors.toList());
    }

    private int getNextOffset(int currentOffset, int nextOffset, List<String> remainingElements, ItemStatus itemStatus) {
        if (itemStatus.getGlobalStatus().isGreaterOrEqualToFatal() || !remainingElements.isEmpty()) {
            return currentOffset;
        }
        return nextOffset;
    }

    private boolean isCanceledOrPaused(Step step) {
        return step.getPauseOrCancelAction() == PauseOrCancelAction.ACTION_CANCEL || step.getPauseOrCancelAction() == PauseOrCancelAction.ACTION_PAUSE;
    }

    private void checkCancelledOrPaused(Step step) {
        if (this.isCanceledOrPaused(step)) {
            throw new PauseCancelException(step.getPauseOrCancelAction());
        }
    }

    void scheduleTaskInExecutionBlockingQueue(WorkerTask task, LogbookTypeProcess logbookTypeProcess, Queue<WorkerTaskResult> resultQueue) {
        Step step = task.getStep();
        WorkerFamilyManager wmf = this.workerManager.findWorkerBy(step.getWorkerGroupId());
        if (null == wmf) {
            LOGGER.error("No WorkerFamilyManager found for : " + step.getWorkerGroupId());
            resultQueue.add(WorkerTaskResult.ofFatalTask(task, new ItemStatus(step.getStepName()).increment(StatusCode.FATAL)));
            return;
        }
        this.scheduleTask(task, logbookTypeProcess, wmf, resultQueue, false, null);
    }

    private void scheduleTask(WorkerTask task, LogbookTypeProcess logbookTypeProcess, WorkerFamilyManager wmf, Queue<WorkerTaskResult> resultQueue, boolean isHighPriorityTask, Map<String, AccessRequestContext> currentAsyncResources) {
        Step step = task.getStep();
        ((Gauge.Child)CommonProcessingMetrics.CURRENTLY_INSTANTIATED_TASKS.labels(new String[]{wmf.getFamily(), logbookTypeProcess.name(), step.getStepName()})).inc();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(task, wmf.getExecutor(isHighPriorityTask)).exceptionally(completionException -> {
            LOGGER.error("Exception occurred when executing task", completionException);
            Throwable cause = completionException.getCause();
            ObjectNode evDetDetail = JsonHandler.createObjectNode();
            if (cause instanceof WorkerUnreachableException) {
                WorkerUnreachableException wue = (WorkerUnreachableException)cause;
                evDetDetail.put("Error", "Distributor lost connection with worker (" + wue.getWorkerId() + "). The worker will be unregistered.");
                try {
                    LOGGER.warn("The worker (" + step.getWorkerGroupId() + ") will be unregistered as it is Unreachable", (Object)wue.getWorkerId());
                    this.workerManager.unregisterWorker(step.getWorkerGroupId(), wue.getWorkerId());
                }
                catch (WorkerFamilyNotFoundException | IOException e1) {
                    LOGGER.error("Exception while unregister worker " + wue.getWorkerId(), cause);
                }
            } else {
                evDetDetail.put("Error", "Error occurred while handling step by the distributor");
            }
            ItemStatus itemStatus = new ItemStatus(step.getStepName()).setItemsStatus(step.getStepName(), new ItemStatus(step.getStepName()).setEvDetailData(JsonHandler.unprettyPrint((Object)evDetDetail)).increment(StatusCode.FATAL));
            return WorkerTaskResult.ofFatalTask(task, itemStatus);
        })).thenApply(is -> {
            ((Gauge.Child)CommonProcessingMetrics.CURRENTLY_INSTANTIATED_TASKS.labels(new String[]{wmf.getFamily(), logbookTypeProcess.name(), step.getStepName()})).dec();
            return is;
        })).whenComplete((result, ex) -> {
            if (currentAsyncResources != null) {
                this.asyncResourceCleaner.markAsyncResourcesForRemoval(currentAsyncResources);
            }
            if (result.getAsyncResources() != null) {
                WorkflowInterruptionChecker workflowInterruptionChecker = () -> !this.isCanceledOrPaused(step);
                AsyncResourceCallback callback = () -> {
                    if (this.isCanceledOrPaused(step)) {
                        resultQueue.add(WorkerTaskResult.ofPausedOrCanceledTask(task));
                        this.asyncResourceCleaner.markAsyncResourcesForRemoval(result.getAsyncResources());
                        return;
                    }
                    this.scheduleTask(task, logbookTypeProcess, wmf, resultQueue, true, result.getAsyncResources());
                };
                this.asyncResourcesMonitor.watchAsyncResourcesForBulk(result.getAsyncResources(), task.getRequestId(), task.getTaskId(), workflowInterruptionChecker, callback);
                return;
            }
            resultQueue.offer((WorkerTaskResult)result);
        });
    }

    @Override
    public ProcessDataManagement getProcessDataManagement() {
        return this.processDataManagement;
    }
}

