/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import fr.gouv.vitam.common.ParametersChecker;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PriorityTaskQueue<T> {
    private final Lock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFullRegularQueue = this.lock.newCondition();
    private final Queue<T> regularQueue = new LinkedList<T>();
    private final Queue<T> priorityQueue = new LinkedList<T>();
    private final int maxRegularQueueSize;

    public PriorityTaskQueue(int maxRegularQueueSize) {
        ParametersChecker.checkValue((String)"Max queue size must be > 0", (long)maxRegularQueueSize, (long)1L);
        this.maxRegularQueueSize = maxRegularQueueSize;
    }

    public void addRegularEntry(T entry) throws InterruptedException {
        ParametersChecker.checkParameter((String)"Missing queue entry", (Object[])new Object[]{entry});
        this.lock.lock();
        try {
            while (this.regularQueue.size() == this.maxRegularQueueSize) {
                this.notFullRegularQueue.await();
            }
            this.regularQueue.add(entry);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addHighPriorityEntry(T entry) {
        ParametersChecker.checkParameter((String)"Missing queue entry", (Object[])new Object[]{entry});
        this.lock.lock();
        try {
            this.priorityQueue.add(entry);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.priorityQueue.isEmpty() && this.regularQueue.isEmpty()) {
                this.notEmpty.await();
            }
            if (!this.priorityQueue.isEmpty()) {
                T t = this.priorityQueue.remove();
                return t;
            }
            T result = this.regularQueue.remove();
            this.notFullRegularQueue.signal();
            T t = result;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.priorityQueue.size() + this.regularQueue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

