/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.AccessRequestResult;
import fr.gouv.vitam.processing.common.async.AccessRequestValue;
import fr.gouv.vitam.processing.common.async.AsyncResourceBulkId;
import fr.gouv.vitam.processing.common.async.AsyncResourceCallback;
import fr.gouv.vitam.processing.common.async.WorkflowInterruptionChecker;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageIllegalOperationClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class AsyncResourcesMonitor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AsyncResourcesMonitor.class);
    private final StorageClientFactory storageClientFactory;
    private final MultiValuedMap<AccessRequestContext, AccessRequestValue> asyncResources;

    public AsyncResourcesMonitor(ServerConfiguration serverConfiguration) {
        this(serverConfiguration, StorageClientFactory.getInstance(), Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()));
    }

    @VisibleForTesting
    public AsyncResourcesMonitor(ServerConfiguration serverConfiguration, StorageClientFactory storageClientFactory, ScheduledExecutorService scheduledExecutorService) {
        this.storageClientFactory = storageClientFactory;
        this.asyncResources = new ArrayListValuedHashMap();
        scheduledExecutorService.scheduleWithFixedDelay(this::checkAsyncResourcesStatuses, serverConfiguration.getDelayAsyncResourceMonitor().intValue(), serverConfiguration.getDelayAsyncResourceMonitor().intValue(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAsyncResourcesStatuses() {
        LOGGER.debug("Starting checkAsyncResourcesStatuses");
        VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()).getId());
        String originalThreadName = Thread.currentThread().getName();
        try {
            ArrayListValuedHashMap currentAsyncResources;
            Thread.currentThread().setName("AsyncResourcesMonitor-" + originalThreadName);
            MultiValuedMap<AccessRequestContext, AccessRequestValue> multiValuedMap = this.asyncResources;
            synchronized (multiValuedMap) {
                block13: {
                    if (!this.asyncResources.isEmpty()) break block13;
                    LOGGER.debug("Not async resources");
                    return;
                }
                currentAsyncResources = new ArrayListValuedHashMap(this.asyncResources);
            }
            Set<AsyncResourceBulkId> interruptedBulkIds = this.abortAsyncResourcesOfInterruptedWorkflows((MultiValuedMap<AccessRequestContext, AccessRequestValue>)currentAsyncResources);
            ArrayListValuedHashMap asyncResourcesOfActiveWorkflows = new ArrayListValuedHashMap();
            currentAsyncResources.entries().stream().filter(entry -> !interruptedBulkIds.contains(((AccessRequestValue)entry.getValue()).getBulkId())).forEach(arg_0 -> AsyncResourcesMonitor.lambda$checkAsyncResourcesStatuses$1((MultiValuedMap)asyncResourcesOfActiveWorkflows, arg_0));
            MultiValuedMap<AccessRequestContext, AccessRequestValue> accessRequestsToRemove = this.handleAsyncResourcesToCheck((MultiValuedMap<AccessRequestContext, AccessRequestValue>)asyncResourcesOfActiveWorkflows);
            MultiValuedMap<AccessRequestContext, AccessRequestValue> multiValuedMap2 = this.asyncResources;
            synchronized (multiValuedMap2) {
                currentAsyncResources.entries().stream().filter(entry -> interruptedBulkIds.contains(((AccessRequestValue)entry.getValue()).getBulkId())).forEach(entry -> this.asyncResources.removeMapping(entry.getKey(), entry.getValue()));
                accessRequestsToRemove.entries().forEach(entry -> this.asyncResources.removeMapping(entry.getKey(), entry.getValue()));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during async resource monitoring", (Throwable)e);
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    private Set<AsyncResourceBulkId> abortAsyncResourcesOfInterruptedWorkflows(MultiValuedMap<AccessRequestContext, AccessRequestValue> currentAsyncResources) {
        Map<AsyncResourceBulkId, WorkflowInterruptionChecker> workflowInterruptionCheckerByBulkId = currentAsyncResources.values().stream().collect(Collectors.toMap(AccessRequestValue::getBulkId, AccessRequestValue::getWorkflowInterruptionChecker, (workflowInterruptionChecker1, workflowInterruptionChecker2) -> workflowInterruptionChecker1));
        Set<AsyncResourceBulkId> interruptedBulkIds = workflowInterruptionCheckerByBulkId.entrySet().stream().filter(entry -> {
            if (((WorkflowInterruptionChecker)entry.getValue()).isAlive()) {
                LOGGER.debug("Workflow {} is still alive", (Object)((AsyncResourceBulkId)entry.getKey()).getRequestId());
                return false;
            }
            LOGGER.info("Workflow {} has been interrupted (paused or canceled). Access requests will be removed.", (Object)((AsyncResourceBulkId)entry.getKey()).getRequestId());
            return true;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<AsyncResourceBulkId, AsyncResourceCallback> asyncCallbackOfInterruptedWorkflows = currentAsyncResources.values().stream().filter(entry -> interruptedBulkIds.contains(entry.getBulkId())).collect(Collectors.toMap(AccessRequestValue::getBulkId, AccessRequestValue::getCallback, (callback1, callback2) -> callback1));
        for (Map.Entry<AsyncResourceBulkId, AsyncResourceCallback> entry2 : asyncCallbackOfInterruptedWorkflows.entrySet()) {
            this.tryNotifyWorkflowCallback(entry2.getValue());
        }
        return interruptedBulkIds;
    }

    private MultiValuedMap<AccessRequestContext, AccessRequestValue> handleAsyncResourcesToCheck(MultiValuedMap<AccessRequestContext, AccessRequestValue> activeAsyncResources) {
        List<AccessRequestResult> accessRequestResults = this.retrieveAccessRequestStatusesInStorage(activeAsyncResources);
        Map<AsyncResourceBulkId, List<AccessRequestResult>> accessRequestsByWorkerBulk = accessRequestResults.stream().collect(Collectors.groupingBy(value -> value.getValue().getBulkId()));
        ArrayListValuedHashMap accessRequestsToRemove = new ArrayListValuedHashMap();
        for (AsyncResourceBulkId bulkId : accessRequestsByWorkerBulk.keySet()) {
            accessRequestsToRemove.putAll(this.handleBulkResults(accessRequestsByWorkerBulk.get(bulkId), bulkId));
        }
        return accessRequestsToRemove;
    }

    private MultiValuedMap<AccessRequestContext, AccessRequestValue> handleBulkResults(List<AccessRequestResult> accessRequestResultsForBulk, AsyncResourceBulkId bulkId) throws IllegalStateException {
        LOGGER.info("Handle results for bulk {} of request id {}", (Object)bulkId.getTaskId(), (Object)bulkId.getRequestId());
        ArrayListValuedHashMap accessRequestsToRemove = new ArrayListValuedHashMap();
        Set bulkResults = accessRequestResultsForBulk.stream().map(AccessRequestResult::getStatus).collect(Collectors.toSet());
        if (bulkResults.contains(null)) {
            throw new IllegalStateException(String.format("At least one result is null for bulk %s of request id %s", bulkId.getRequestId(), bulkId.getRequestId()));
        }
        if (bulkResults.contains(AccessRequestStatus.EXPIRED) || bulkResults.contains(AccessRequestStatus.NOT_FOUND)) {
            LOGGER.warn("At least one access request EXPIRED or NOT_FOUND: {}", accessRequestResultsForBulk.stream().collect(Collectors.toMap(accessRequestResult -> accessRequestResult.getValue().getAccessRequestId(), AccessRequestResult::getStatus)));
            accessRequestResultsForBulk.forEach(arg_0 -> AsyncResourcesMonitor.lambda$handleBulkResults$11((MultiValuedMap)accessRequestsToRemove, arg_0));
            this.tryNotifyWorkflowCallback(((AccessRequestResult)accessRequestResultsForBulk.stream().findFirst().orElseThrow()).getCallback());
        } else if (bulkResults.contains(AccessRequestStatus.NOT_READY)) {
            LOGGER.info("NOT_READY");
        } else if (bulkResults.contains(AccessRequestStatus.READY)) {
            LOGGER.info("READY");
            accessRequestResultsForBulk.forEach(arg_0 -> AsyncResourcesMonitor.lambda$handleBulkResults$12((MultiValuedMap)accessRequestsToRemove, arg_0));
            this.tryNotifyWorkflowCallback(((AccessRequestResult)accessRequestResultsForBulk.stream().findFirst().orElseThrow()).getCallback());
        } else if (bulkResults.size() > 0) {
            throw new IllegalStateException(String.format("At least one result contains an invalid status value for bulk %s of request id %s", bulkId.getTaskId(), bulkId.getRequestId()));
        }
        return accessRequestsToRemove;
    }

    private void tryNotifyWorkflowCallback(AsyncResourceCallback callback) {
        try {
            callback.notifyWorkflow();
        }
        catch (Exception e) {
            LOGGER.error("Async resource callback failed", (Throwable)e);
        }
    }

    private List<AccessRequestResult> retrieveAccessRequestStatusesInStorage(MultiValuedMap<AccessRequestContext, AccessRequestValue> currentAsyncResources) {
        ArrayList<AccessRequestResult> accessRequestResults = new ArrayList();
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            for (AccessRequestContext accessRequestGroupKey : currentAsyncResources.keySet()) {
                Collection accessRequestGroupValues = currentAsyncResources.get((Object)accessRequestGroupKey);
                UnmodifiableIterator accessRequestGroupValuesIterator = Iterators.partition(accessRequestGroupValues.iterator(), (int)VitamConfiguration.getBatchSize());
                while (accessRequestGroupValuesIterator.hasNext()) {
                    List accessRequestValuesBulk = (List)accessRequestGroupValuesIterator.next();
                    List accessRequestIdBulk = accessRequestValuesBulk.stream().map(AccessRequestValue::getAccessRequestId).collect(Collectors.toList());
                    Map results = storageClient.checkAccessRequestStatuses(accessRequestGroupKey.getStrategyId(), accessRequestGroupKey.getOfferId(), accessRequestIdBulk, true);
                    accessRequestResults.addAll(accessRequestValuesBulk.stream().map(accessRequestValue -> new AccessRequestResult(accessRequestValue, accessRequestGroupKey, (AccessRequestStatus)results.get(accessRequestValue.getAccessRequestId()))).collect(Collectors.toList()));
                }
            }
        }
        catch (StorageIllegalOperationClientException | StorageServerClientException e) {
            LOGGER.error("Exception while retrieving accessRequest statuses", e);
            accessRequestResults = Collections.emptyList();
        }
        return accessRequestResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchAsyncResourcesForBulk(Map<String, AccessRequestContext> asyncResources, String requestId, String taskId, WorkflowInterruptionChecker workflowInterruptionChecker, AsyncResourceCallback callback) {
        ArrayListValuedHashMap asyncResourcesForBulk = new ArrayListValuedHashMap();
        for (Map.Entry<String, AccessRequestContext> asyncResource : asyncResources.entrySet()) {
            asyncResourcesForBulk.put((Object)asyncResource.getValue(), (Object)new AccessRequestValue(asyncResource.getKey(), requestId, taskId, workflowInterruptionChecker, callback));
        }
        Iterator<Map.Entry<String, AccessRequestContext>> iterator = this.asyncResources;
        synchronized (iterator) {
            this.asyncResources.putAll((MultiValuedMap)asyncResourcesForBulk);
        }
    }

    private static /* synthetic */ void lambda$handleBulkResults$12(MultiValuedMap accessRequestsToRemove, AccessRequestResult accessRequestResult) {
        accessRequestsToRemove.put((Object)accessRequestResult.getContext(), (Object)accessRequestResult.getValue());
    }

    private static /* synthetic */ void lambda$handleBulkResults$11(MultiValuedMap accessRequestsToRemove, AccessRequestResult accessRequestResult) {
        accessRequestsToRemove.put((Object)accessRequestResult.getContext(), (Object)accessRequestResult.getValue());
    }

    private static /* synthetic */ void lambda$checkAsyncResourcesStatuses$1(MultiValuedMap asyncResourcesOfActiveWorkflows, Map.Entry entry) {
        asyncResourcesOfActiveWorkflows.put((Object)((AccessRequestContext)entry.getKey()), (Object)((AccessRequestValue)entry.getValue()));
    }
}

