/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.config.ServerConfiguration;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageIllegalOperationClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AsyncResourceCleaner {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AsyncResourceCleaner.class);
    private final StorageClientFactory storageClientFactory;
    private final Map<String, AccessRequestContext> asyncResourcesToRemove;

    public AsyncResourceCleaner(ServerConfiguration serverConfiguration) {
        this(serverConfiguration, StorageClientFactory.getInstance(), Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()));
    }

    @VisibleForTesting
    public AsyncResourceCleaner(ServerConfiguration serverConfiguration, StorageClientFactory storageClientFactory, ScheduledExecutorService scheduledExecutorService) {
        this.storageClientFactory = storageClientFactory;
        this.asyncResourcesToRemove = new HashMap<String, AccessRequestContext>();
        scheduledExecutorService.scheduleWithFixedDelay(this::cleanupAsyncResources, serverConfiguration.getDelayAsyncResourceCleaner().intValue(), serverConfiguration.getDelayAsyncResourceCleaner().intValue(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAsyncResources() {
        LOGGER.debug("Starting cleanupAsyncResources");
        String originalThreadName = Thread.currentThread().getName();
        try {
            HashMap<String, AccessRequestContext> currentAsyncResourcesToRemove;
            Thread.currentThread().setName("CleanupAsyncResources-" + originalThreadName);
            VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()).getId());
            Map<String, AccessRequestContext> map = this.asyncResourcesToRemove;
            synchronized (map) {
                currentAsyncResourcesToRemove = new HashMap<String, AccessRequestContext>(this.asyncResourcesToRemove);
            }
            if (currentAsyncResourcesToRemove.isEmpty()) {
                LOGGER.debug("Nothing to process");
                return;
            }
            HashSet<String> removedAccessRequestIds = new HashSet<String>();
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                for (String accessRequestId : currentAsyncResourcesToRemove.keySet()) {
                    AccessRequestContext accessRequestContext = (AccessRequestContext)currentAsyncResourcesToRemove.get(accessRequestId);
                    LOGGER.info("Removing access request {} for strategyId: {} / offerId: {}", new Object[]{accessRequestId, accessRequestContext.getStrategyId(), accessRequestContext.getOfferId()});
                    try {
                        storageClient.removeAccessRequest(accessRequestContext.getStrategyId(), accessRequestContext.getOfferId(), accessRequestId, true);
                        LOGGER.info("Access request {} removed successfully for strategyId: {} / offerId: {}", new Object[]{accessRequestId, accessRequestContext.getStrategyId(), accessRequestContext.getOfferId()});
                        removedAccessRequestIds.add(accessRequestId);
                    }
                    catch (StorageIllegalOperationClientException | StorageServerClientException e) {
                        LOGGER.error("Could not remove access request {} for strategyId: {} / offerId: {}", new Object[]{accessRequestId, accessRequestContext.getStrategyId(), accessRequestContext.getOfferId(), e});
                    }
                }
            }
            Map<String, AccessRequestContext> map2 = this.asyncResourcesToRemove;
            synchronized (map2) {
                for (String removedAccessRequestId : removedAccessRequestIds) {
                    this.asyncResourcesToRemove.remove(removedAccessRequestId);
                }
            }
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsyncResourcesForRemoval(Map<String, AccessRequestContext> asyncResources) {
        Map<String, AccessRequestContext> map = this.asyncResourcesToRemove;
        synchronized (map) {
            Optional<String> existingAccessRequestId = asyncResources.keySet().stream().filter(this.asyncResourcesToRemove::containsKey).findFirst();
            if (existingAccessRequestId.isPresent()) {
                throw new IllegalArgumentException("Duplicate access request id: '" + existingAccessRequestId.get() + "'");
            }
            this.asyncResourcesToRemove.putAll(asyncResources);
        }
    }
}

