/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.api;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingBadRequestException;
import fr.gouv.vitam.processing.common.exception.WorkerFamilyNotFoundException;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.common.model.WorkerRemoteConfiguration;
import fr.gouv.vitam.processing.distributor.core.WorkerFamilyManager;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface IWorkerManager {
    public static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IWorkerManager.class);
    public static final String WORKER_DB_PATH = "worker.db";

    default public void initialize() throws IOException {
        if (this.getWorkerDbFile().exists()) {
            this.loadWorkerList(this.getWorkerDbFile());
        } else {
            LOGGER.warn("No worker list serialization file : " + this.getWorkerDbFile().getName());
        }
    }

    default public void loadWorkerList(File registerWorkerFile) throws IOException {
        try {
            List workerBeans = (List)JsonHandler.getFromFileAsTypeReference((File)registerWorkerFile, (TypeReference)new TypeReference<List<WorkerBean>>(){});
            for (WorkerBean workerBean : workerBeans) {
                String workerId = workerBean.getWorkerId();
                String familyId = workerBean.getFamily();
                if (familyId == null || workerId == null) {
                    LOGGER.error("Mandatory arguments missing: family = " + familyId + ", worker= " + workerId + ". Continue with next workers");
                    continue;
                }
                WorkerRemoteConfiguration config = workerBean.getConfiguration();
                if (!this.checkStatusWorker(config.getServerHost(), config.getServerPort())) continue;
                try {
                    this.registerWorker(workerBean);
                }
                catch (IOException e) {
                    LOGGER.warn("Error while save worker to file", (Throwable)e);
                }
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot load worker list from database.", (Throwable)e);
            return;
        }
        this.marshallToDB();
    }

    public boolean checkStatusWorker(String var1, int var2);

    public void registerWorker(String var1, String var2, WorkerBean var3) throws ProcessingBadRequestException, IOException;

    public void registerWorker(WorkerBean var1) throws IOException;

    public void unregisterWorker(String var1, String var2) throws WorkerFamilyNotFoundException, IOException;

    public void marshallToDB() throws IOException;

    public WorkerFamilyManager findWorkerBy(String var1);

    public File getWorkerDbFile();
}

