/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookRepositoryService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/logbook/v1")
@Tag(name="Logbook")
public class LogbookRawResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookRawResource.class);
    private final LogbookRepositoryService logbookRepositoryService;

    public LogbookRawResource(VitamRepositoryProvider vitamRepositoryProvider, ElasticsearchLogbookIndexManager indexManager) {
        this.logbookRepositoryService = new LogbookRepositoryService(vitamRepositoryProvider, indexManager);
    }

    @POST
    @Path(value="raw/unitlifecycles/bulk")
    @Consumes(value={"application/json"})
    public Response createLifeCycleUnitBulkRaw(List<JsonNode> logbookLifecycles) {
        return this.createLifecycleBulk(LogbookCollections.LIFECYCLE_UNIT, logbookLifecycles);
    }

    @POST
    @Path(value="raw/objectgrouplifecycles/bulk")
    @Consumes(value={"application/json"})
    public Response createLifeCycleObjectGroupBulkRaw(List<JsonNode> logbookLifecycles) {
        return this.createLifecycleBulk(LogbookCollections.LIFECYCLE_OBJECTGROUP, logbookLifecycles);
    }

    private Response createLifecycleBulk(LogbookCollections collection, List<JsonNode> logbookLifecycles) {
        ParametersChecker.checkParameter((String)"Logbook parameters", (Object[])new Object[]{logbookLifecycles});
        try {
            this.logbookRepositoryService.saveBulk(collection, logbookLifecycles);
        }
        catch (DatabaseException e) {
            LOGGER.error("Lifecycles could not be inserted in database", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

