/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.administration.core.api.LogbookCheckConsistencyService;
import fr.gouv.vitam.logbook.administration.core.impl.LogbookCheckConsistencyServiceImpl;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckResult;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/logbook/v1")
@Tag(name="Logbook")
public class LogbookAdminResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookAdminResource.class);
    private final String CHECK_LOGBOOK_COHERENCE_URI = "/checklogbook";
    private LogbookCheckConsistencyService checkLogbookService;

    public LogbookAdminResource(VitamRepositoryProvider vitamRepositoryProvider, LogbookConfiguration configuration) {
        this.checkLogbookService = new LogbookCheckConsistencyServiceImpl(configuration, vitamRepositoryProvider);
    }

    @Path(value="/checklogbook")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response checkLogbookCoherence() {
        LOGGER.debug("Starting Check logbook coherence service :");
        try {
            LogbookCheckResult response = this.checkLogbookService.logbookCoherenceCheckByTenant(VitamThreadUtils.getVitamSession().getTenantId());
            return Response.ok().entity((Object)response).build();
        }
        catch (VitamException exc) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            VitamError error = VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, (String)exc.getMessage());
            return Response.status((Response.Status)status).entity((Object)error).build();
        }
    }
}

