/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import com.google.common.base.Throwables;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementOntologyLoader;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfigurationValidator;
import fr.gouv.vitam.logbook.rest.LogbookAdminResource;
import fr.gouv.vitam.security.internal.filter.AdminRequestIdFilter;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class AdminLogbookApplication
extends Application {
    private final AdminApplication adminApplication;
    private Set<Object> singletons;

    public AdminLogbookApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            LogbookConfiguration logbookConfiguration = (LogbookConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, LogbookConfiguration.class);
            LogbookConfigurationValidator.validateConfiguration((LogbookConfiguration)logbookConfiguration);
            ElasticsearchLogbookIndexManager indexManager = new ElasticsearchLogbookIndexManager(logbookConfiguration, VitamConfiguration.getTenants());
            this.adminApplication = new AdminApplication();
            CachedOntologyLoader ontologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new AdminManagementOntologyLoader(AdminManagementClientFactory.getInstance(), Optional.empty()));
            VitamRepositoryFactory vitamRepositoryProvider = VitamRepositoryFactory.get();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.adminApplication.getSingletons());
            this.singletons.add(new LogbookAdminResource((VitamRepositoryProvider)vitamRepositoryProvider, logbookConfiguration));
            this.singletons.add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)logbookConfiguration));
            this.singletons.add(new AdminRequestIdFilter());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

