/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.reconstruction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.api.impl.VitamElasticsearchRepository;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionRequestItem;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionResponseItem;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookTransformData;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookBackupModel;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookReconstructionMetricsCache;
import fr.gouv.vitam.logbook.common.server.reconstruction.RestoreBackupService;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;

public class ReconstructionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionService.class);
    private static final AlertService alertService = new AlertServiceImpl();
    private static final String RECONSTRUCTION_ITEM_MONDATORY_MSG = "the item defining reconstruction is mandatory.";
    private static final String RECONSTRUCTION_TENANT_MONDATORY_MSG = "the tenant to reconstruct is mandatory.";
    private static final String RECONSTRUCTION_LIMIT_POSITIVE_MSG = "the limit to reconstruct is should at least 0.";
    public static final String LOGBOOK = "logbook";
    private final RestoreBackupService restoreBackupService;
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private final OffsetRepository offsetRepository;
    private final ElasticsearchLogbookIndexManager indexManager;
    private final LogbookReconstructionMetricsCache reconstructionMetricsCache;

    public ReconstructionService(VitamRepositoryProvider vitamRepositoryProvider, OffsetRepository offsetRepository, ElasticsearchLogbookIndexManager indexManager, LogbookReconstructionMetricsCache reconstructionMetricsCache) {
        this(vitamRepositoryProvider, new RestoreBackupService(), offsetRepository, indexManager, reconstructionMetricsCache);
    }

    @VisibleForTesting
    public ReconstructionService(VitamRepositoryProvider vitamRepositoryProvider, RestoreBackupService recoverBackupService, OffsetRepository offsetRepository, ElasticsearchLogbookIndexManager indexManager, LogbookReconstructionMetricsCache reconstructionMetricsCache) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.restoreBackupService = recoverBackupService;
        this.offsetRepository = offsetRepository;
        this.indexManager = indexManager;
        this.reconstructionMetricsCache = reconstructionMetricsCache;
    }

    public ReconstructionResponseItem reconstruct(ReconstructionRequestItem reconstructionItem) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_ITEM_MONDATORY_MSG, (Object[])new Object[]{reconstructionItem});
        ParametersChecker.checkParameter((String)RECONSTRUCTION_TENANT_MONDATORY_MSG, (Object[])new Object[]{reconstructionItem.getTenant()});
        if (reconstructionItem.getLimit() < 0) {
            throw new IllegalArgumentException(RECONSTRUCTION_LIMIT_POSITIVE_MSG);
        }
        LOGGER.info(String.format("[Reconstruction]: Reconstruction of {%s} Collection on {%s} Vitam tenant", DataCategory.BACKUP_OPERATION.name(), reconstructionItem.getTenant()));
        return this.reconstructCollection(reconstructionItem.getTenant(), reconstructionItem.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReconstructionResponseItem reconstructCollection(int tenant, int limit) {
        long lastReconstructedOffset = this.offsetRepository.findOffsetBy(tenant, VitamConfiguration.getDefaultStrategy(), LOGBOOK);
        long startOffset = lastReconstructedOffset + 1L;
        LOGGER.info(String.format("[Reconstruction]: Start reconstruction of the {%s} collection on the Vitam tenant {%s} for %s elements starting from {%s}.", DataCategory.BACKUP_OPERATION.name(), tenant, limit, startOffset));
        ReconstructionResponseItem response = new ReconstructionResponseItem().setTenant(Integer.valueOf(tenant));
        Integer originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
        VitamMongoRepository mongoRepository = this.vitamRepositoryProvider.getVitamMongoRepository(LogbookCollections.OPERATION.getVitamCollection());
        VitamElasticsearchRepository esRepository = this.vitamRepositoryProvider.getVitamESRepository(LogbookCollections.OPERATION.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(LogbookCollections.OPERATION));
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
            LocalDateTime reconstructionStartDateTime = LocalDateUtil.now();
            LocalDateTime lastReconstructedDocumentDate = null;
            int nbEntriesReconstructed = 0;
            Iterator<List<OfferLog>> listing = this.restoreBackupService.getListing(VitamConfiguration.getDefaultStrategy(), startOffset, limit);
            while (listing.hasNext()) {
                List<OfferLog> listingBulk = listing.next();
                ArrayList<LogbookBackupModel> bulkData = new ArrayList<LogbookBackupModel>();
                for (OfferLog offerLog : listingBulk) {
                    try {
                        LogbookBackupModel model = this.restoreBackupService.loadData(VitamConfiguration.getDefaultStrategy(), offerLog.getFileName(), offerLog.getSequence());
                        if (model.getLogbookOperation() == null || model.getLogbookId() == null) {
                            throw new StorageException(String.format("[Reconstruction]: Invalid LogbookOperation in file {%s} on the tenant {%s}", offerLog.getFileName(), tenant));
                        }
                        bulkData.add(model);
                    }
                    catch (StorageNotFoundException ex) {
                        alertService.createAlert(VitamLogLevel.ERROR, String.format("[Reconstruction]: LogbookOperation is not present in file {%s} on the tenant {%s}", offerLog.getFileName(), tenant));
                        throw new StorageException(String.format("[Reconstruction]: LogbookOperation is not present in file {%s} on the tenant {%s}", offerLog.getFileName(), tenant), (Throwable)ex);
                    }
                }
                this.reconstructCollectionLogbookOperation(mongoRepository, esRepository, bulkData);
                long lastOffset = ((LogbookBackupModel)Iterables.getLast(bulkData)).getOffset();
                this.offsetRepository.createOrUpdateOffset(tenant, VitamConfiguration.getDefaultStrategy(), LOGBOOK, lastOffset);
                nbEntriesReconstructed += listingBulk.size();
                lastReconstructedDocumentDate = listingBulk.get(listingBulk.size() - 1).getTime();
                LOGGER.info(String.format("[Reconstruction]: the collection {%s} has been reconstructed on the tenant {%s} to {offset:%s} at %s", DataCategory.BACKUP_OPERATION.name(), tenant, lastOffset, LocalDateUtil.now()));
            }
            if (nbEntriesReconstructed != limit) {
                lastReconstructedDocumentDate = LocalDateUtil.max((LocalDateTime)reconstructionStartDateTime, lastReconstructedDocumentDate);
            }
            this.reconstructionMetricsCache.registerLastReconstructedDocumentDate(tenant, lastReconstructedDocumentDate);
            response.setStatus(StatusCode.OK);
        }
        catch (DatabaseException em) {
            LOGGER.error(String.format("[Reconstruction]: Exception has been thrown when reconstructing Vitam collection {%s} on the tenant {%s} from {offset:%s}", DataCategory.BACKUP_OPERATION.name(), tenant, startOffset), (Throwable)em);
            response.setStatus(StatusCode.KO);
        }
        catch (StorageNotFoundClientException | StorageServerClientException | StorageException se) {
            LOGGER.error(se.getMessage());
            response.setStatus(StatusCode.KO);
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        }
        return response;
    }

    private void reconstructCollectionLogbookOperation(VitamMongoRepository mongoRepository, VitamElasticsearchRepository esRepository, List<LogbookBackupModel> bulk) throws DatabaseException {
        LOGGER.info("[Reconstruction]: Back up of logbookOperation bulk");
        List<Document> logbooks = bulk.stream().map(LogbookBackupModel::getLogbookOperation).collect(Collectors.toList());
        mongoRepository.saveOrUpdate(logbooks);
        logbooks.forEach(LogbookTransformData::transformDataForElastic);
        esRepository.save(logbooks);
    }
}

