/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.BasicDBObject;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class LogbookOperation
extends VitamDocument<LogbookOperation> {
    private static final long serialVersionUID = -8343195329673741173L;
    public static final String EVENTS = "events";

    public LogbookOperation(LogbookOperationParameters parameters) {
        ParametersChecker.checkParameter((String)"parameters", (Object[])new Object[]{parameters});
        Map map = parameters.getMapParameters();
        for (LogbookMongoDbName name : LogbookMongoDbName.values()) {
            this.append(name.getDbname(), map.get(name.getLogbookParameterName()));
        }
        this.append(EVENTS, List.of());
        this.checkId();
    }

    public LogbookOperation(Document content) {
        super(content);
    }

    public LogbookOperation(String content) {
        super(content);
    }

    public LogbookOperation(JsonNode content) {
        super(content);
    }

    public LogbookOperation() {
    }

    public VitamDocument<LogbookOperation> newInstance(JsonNode content) {
        return new LogbookOperation(content);
    }

    static LogbookMongoDbName getIdName() {
        return LogbookMongoDbName.eventIdentifierProcess;
    }

    public static LogbookParameterName getIdParameterName() {
        return LogbookParameterName.eventIdentifierProcess;
    }

    public String getId() {
        return this.getString(LogbookOperation.getIdName().getDbname());
    }

    private LogbookOperationParameters getOperation(Bson object) {
        LogbookOperationParameters parameters;
        block3: {
            Map map;
            block2: {
                parameters = LogbookParameterHelper.newLogbookOperationParameters();
                map = parameters.getMapParameters();
                if (!(object instanceof BasicDBObject)) break block2;
                for (LogbookMongoDbName name : LogbookMongoDbName.values()) {
                    map.put(name.getLogbookParameterName(), ((BasicDBObject)object).getString(name.getDbname()));
                }
                break block3;
            }
            if (!(object instanceof Document)) break block3;
            for (LogbookMongoDbName name : LogbookMongoDbName.values()) {
                map.put(name.getLogbookParameterName(), ((Document)object).getString((Object)name.getDbname()));
            }
        }
        return parameters;
    }

    public List<LogbookOperationParameters> getOperations(boolean all) {
        ArrayList events = (ArrayList)this.get(EVENTS);
        if (events == null) {
            events = new ArrayList();
        }
        int nb = all ? events.size() : (events.isEmpty() ? 1 : 2);
        ArrayList<LogbookOperationParameters> list = new ArrayList<LogbookOperationParameters>(nb);
        list.add(this.getOperation((Bson)this));
        if (all) {
            for (Document eventob : events) {
                list.add(this.getOperation((Bson)eventob));
            }
        } else {
            Document eventob = (Document)events.get(events.size() - 1);
            list.add(this.getOperation((Bson)eventob));
        }
        return list;
    }
}

