/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.google.common.collect.ImmutableSet;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookExecutionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class LogbookElasticsearchAccess
extends ElasticsearchAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookElasticsearchAccess.class);
    public static final String MAPPING_LOGBOOK_OPERATION_FILE = "/logbook-es-mapping.json";
    private final ElasticsearchLogbookIndexManager indexManager;

    public LogbookElasticsearchAccess(String clusterName, List<ElasticsearchNode> nodes, ElasticsearchLogbookIndexManager indexManager) throws VitamException {
        super(clusterName, nodes);
        this.indexManager = indexManager;
    }

    public void createIndexesAndAliases() {
        try {
            this.createIndexesAndAliasesForDedicatedTenants();
            this.createIndexesAndAliasesForTenantGroups();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException("Could not create indexes and aliases", e);
        }
    }

    private void createIndexesAndAliasesForDedicatedTenants() throws LogbookExecutionException {
        List<Integer> dedicatedTenants = this.indexManager.getDedicatedTenants();
        Iterator iterator = dedicatedTenants.iterator();
        while (iterator.hasNext()) {
            int tenantId = (Integer)iterator.next();
            this.createIndexAndAliasIfAliasNotExists(LogbookCollections.OPERATION, tenantId);
        }
    }

    private void createIndexesAndAliasesForTenantGroups() throws LogbookExecutionException {
        Collection<String> tenantGroups = this.indexManager.getTenantGroups();
        for (String tenantGroup : tenantGroups) {
            List<Integer> tenantGroupTenants = this.indexManager.getTenantGroupTenants(tenantGroup);
            if (tenantGroupTenants.isEmpty()) continue;
            int tenantId = (Integer)tenantGroupTenants.iterator().next();
            this.createIndexAndAliasIfAliasNotExists(LogbookCollections.OPERATION, tenantId);
        }
    }

    private void createIndexAndAliasIfAliasNotExists(LogbookCollections collection, Integer tenantId) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            ElasticsearchIndexSettings indexSettings = this.indexManager.getElasticsearchIndexSettings(collection, tenantId);
            super.createIndexAndAliasIfAliasNotExists(indexAlias, indexSettings);
        }
        catch (Exception e) {
            throw new LogbookExecutionException("Error while set Mapping", e);
        }
    }

    final <T> void updateFullDocument(LogbookCollections collection, Integer tenantId, String id, VitamDocument<T> logbookDocument) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.updateEntry(indexAlias, id, logbookDocument);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public final SearchResponse search(LogbookCollections collection, Integer tenantId, QueryBuilder query, QueryBuilder filter, List<SortBuilder<?>> sorts, int offset, int limit) throws LogbookException {
        try {
            int size = Math.min(10000, limit);
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            BoolQueryBuilder finalQuery = new BoolQueryBuilder().must(query).must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (Object)tenantId));
            return super.search(indexAlias, (QueryBuilder)finalQuery, filter, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
        }
        catch (BadRequestException | DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public final SearchResponse searchCrossIndices(LogbookCollections collection, Integer tenantId, QueryBuilder query, QueryBuilder filter, List<SortBuilder<?>> sorts, int offset, int limit) throws LogbookException {
        try {
            int size = Math.min(10000, limit);
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            BoolQueryBuilder finalQuery = new BoolQueryBuilder().must(query);
            TermQueryBuilder currentTenantQuery = QueryBuilders.termQuery((String)"_tenant", (Object)tenantId);
            if (ParameterHelper.getTenantParameter().equals(VitamConfiguration.getAdminTenant())) {
                finalQuery.must((QueryBuilder)currentTenantQuery);
                return super.search(indexAlias, (QueryBuilder)finalQuery, filter, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
            }
            ElasticsearchIndexAlias adminTenantIndex = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(VitamConfiguration.getAdminTenant());
            finalQuery.must((QueryBuilder)new BoolQueryBuilder().should((QueryBuilder)currentTenantQuery).should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)"evType", (String[])LogbookCollections.MULTI_TENANT_EV_TYPES)).must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (Object)VitamConfiguration.getAdminTenant()))));
            return super.searchCrossIndices((Set)ImmutableSet.of((Object)indexAlias, (Object)adminTenantIndex), (QueryBuilder)finalQuery, filter, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
        }
        catch (BadRequestException | DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void deleteIndexByAliasForTesting(LogbookCollections collection, int tenantId) throws LogbookExecutionException {
        try {
            super.deleteIndexByAliasForTesting(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public <T> void indexEntry(LogbookCollections collection, Integer tenantId, String id, VitamDocument<T> vitamDocument) throws LogbookExecutionException {
        try {
            super.indexEntry(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId), id, vitamDocument);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void refreshIndex(LogbookCollections collection, int tenantId) throws LogbookExecutionException {
        try {
            super.refreshIndex(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void purgeIndexForTesting(LogbookCollections collection, Integer tenantId) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.purgeIndexForTesting(indexAlias, tenantId);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }
}

