/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.config;

import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.logbook.common.server.config.DedicatedTenantConfiguration;
import fr.gouv.vitam.logbook.common.server.config.GroupedTenantConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ElasticsearchLogbookIndexManager {
    public static final String MAPPING_LOGBOOK_OPERATION_FILE = "/logbook-es-mapping.json";
    private final List<Integer> tenantIds;
    private final Map<Integer, String> tenantToTenantGroupMap = new HashMap<Integer, String>();
    private final ListValuedMap<String, Integer> tenantGroupToTenantMap = new ArrayListValuedHashMap();
    private final Map<Integer, ElasticsearchIndexSettings> logbookOperationIndexSettingsMap = new HashMap<Integer, ElasticsearchIndexSettings>();

    public ElasticsearchLogbookIndexManager(LogbookConfiguration configuration, List<Integer> tenantIds) {
        CollectionConfiguration finalTenantCollectionConfiguration;
        List tenantRanges;
        this.tenantIds = tenantIds;
        HashMap<Integer, CollectionConfiguration> customTenantLogbookOperationConfiguration = new HashMap<Integer, CollectionConfiguration>();
        HashMap<String, CollectionConfiguration> groupedTenantLogbookOperationConfiguration = new HashMap<String, CollectionConfiguration>();
        CollectionConfiguration defaultLogbookOperation = configuration.getLogbookTenantIndexation().getDefaultCollectionConfiguration().getLogbookoperation();
        if (configuration.getLogbookTenantIndexation().getDedicatedTenantConfiguration() != null) {
            for (DedicatedTenantConfiguration dedicatedTenantConfiguration : configuration.getLogbookTenantIndexation().getDedicatedTenantConfiguration()) {
                tenantRanges = TenantRangeParser.parseTenantRanges((String)dedicatedTenantConfiguration.getTenants());
                finalTenantCollectionConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)dedicatedTenantConfiguration.getLogbookoperation(), (CollectionConfiguration)defaultLogbookOperation);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId2 : tenantIds) {
                        if (!tenantRange.isInRange(tenantId2)) continue;
                        customTenantLogbookOperationConfiguration.put(tenantId2, finalTenantCollectionConfiguration);
                    }
                }
            }
        }
        if (configuration.getLogbookTenantIndexation().getGroupedTenantConfiguration() != null) {
            for (GroupedTenantConfiguration groupedTenantConfiguration : configuration.getLogbookTenantIndexation().getGroupedTenantConfiguration()) {
                tenantRanges = TenantRangeParser.parseTenantRanges((String)groupedTenantConfiguration.getTenants());
                finalTenantCollectionConfiguration = CollectionConfigurationUtils.merge((CollectionConfiguration)groupedTenantConfiguration.getLogbookoperation(), (CollectionConfiguration)defaultLogbookOperation);
                groupedTenantLogbookOperationConfiguration.put(groupedTenantConfiguration.getName(), finalTenantCollectionConfiguration);
                for (TenantRange tenantRange : tenantRanges) {
                    for (int tenantId2 : tenantIds) {
                        if (!tenantRange.isInRange(tenantId2)) continue;
                        this.tenantToTenantGroupMap.put(tenantId2, groupedTenantConfiguration.getName());
                        this.tenantGroupToTenantMap.get((Object)groupedTenantConfiguration.getName()).add(tenantId2);
                    }
                }
            }
        }
        Supplier<String> esMappingLoader = () -> {
            try {
                return ElasticsearchUtil.transferJsonToMapping((InputStream)LogbookOperation.class.getResourceAsStream(MAPPING_LOGBOOK_OPERATION_FILE));
            }
            catch (IOException e) {
                throw new VitamFatalRuntimeException("Could not load es mapping file", (Throwable)e);
            }
        };
        tenantIds.stream().filter(Predicate.not(this.tenantToTenantGroupMap::containsKey)).forEach(tenantId -> {
            CollectionConfiguration collectionConfiguration = customTenantLogbookOperationConfiguration.getOrDefault(tenantId, defaultLogbookOperation);
            ElasticsearchIndexSettings elasticsearchIndexSettings = new ElasticsearchIndexSettings(collectionConfiguration.getNumberOfShards().intValue(), collectionConfiguration.getNumberOfReplicas().intValue(), esMappingLoader);
            this.logbookOperationIndexSettingsMap.put((Integer)tenantId, elasticsearchIndexSettings);
        });
        this.tenantGroupToTenantMap.keySet().forEach(tenantGroupName -> {
            CollectionConfiguration collectionConfiguration = (CollectionConfiguration)groupedTenantLogbookOperationConfiguration.get(tenantGroupName);
            ElasticsearchIndexSettings elasticsearchIndexSettings = new ElasticsearchIndexSettings(collectionConfiguration.getNumberOfShards().intValue(), collectionConfiguration.getNumberOfReplicas().intValue(), esMappingLoader);
            for (Integer tenantId : this.tenantGroupToTenantMap.get(tenantGroupName)) {
                this.logbookOperationIndexSettingsMap.put(tenantId, elasticsearchIndexSettings);
            }
        });
    }

    public ElasticsearchIndexAliasResolver getElasticsearchIndexAliasResolver(LogbookCollections collection) {
        this.validateCollection(collection);
        return tenantId -> {
            if (this.tenantToTenantGroupMap.containsKey(tenantId)) {
                return ElasticsearchIndexAlias.ofMultiTenantCollection((String)collection.getName(), (String)this.tenantToTenantGroupMap.get(tenantId));
            }
            return ElasticsearchIndexAlias.ofMultiTenantCollection((String)collection.getName(), (int)tenantId);
        };
    }

    public ElasticsearchIndexSettings getElasticsearchIndexSettings(LogbookCollections collection, int tenantId) {
        this.validateCollection(collection);
        return this.logbookOperationIndexSettingsMap.get(tenantId);
    }

    public List<Integer> getDedicatedTenants() {
        return this.tenantIds.stream().filter(Predicate.not(this.tenantToTenantGroupMap::containsKey)).collect(Collectors.toList());
    }

    public Collection<String> getTenantGroups() {
        return this.tenantGroupToTenantMap.keySet();
    }

    public List<Integer> getTenantGroupTenants(String tenantGroupName) {
        if (!this.tenantGroupToTenantMap.containsKey((Object)tenantGroupName)) {
            throw new IllegalStateException("No such tenant group " + tenantGroupName);
        }
        return this.tenantGroupToTenantMap.get((Object)tenantGroupName);
    }

    public boolean isGroupedTenant(int tenantId) {
        return this.tenantToTenantGroupMap.containsKey(tenantId);
    }

    public String getTenantGroup(int tenantId) {
        if (!this.tenantToTenantGroupMap.containsKey(tenantId)) {
            throw new IllegalStateException("Tenant " + tenantId + " does not belong to a tenant group");
        }
        return this.tenantToTenantGroupMap.get(tenantId);
    }

    private void validateCollection(LogbookCollections collection) {
        switch (collection) {
            case OPERATION: {
                break;
            }
            case LIFECYCLE_UNIT: 
            case LIFECYCLE_OBJECTGROUP: 
            case LIFECYCLE_UNIT_IN_PROCESS: 
            case LIFECYCLE_OBJECTGROUP_IN_PROCESS: {
                throw new IllegalStateException("Collection not supported " + collection);
            }
            default: {
                throw new IllegalStateException("Unknown collection " + collection);
            }
        }
    }
}

