/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.common.util;

import com.google.common.collect.Lists;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ingest.external.common.exception.JavaExecuteScriptException;
import fr.gouv.vitam.ingest.external.common.util.ExecutionOutput;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;

public class JavaExecuteScript {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(JavaExecuteScript.class);

    public ExecutionOutput executeCommand(String cmd, String arg, long timeoutScanDelay) throws JavaExecuteScriptException {
        String scriptPath;
        try {
            scriptPath = PropertiesUtils.findFile((String)cmd).getPath();
        }
        catch (FileNotFoundException e) {
            LOGGER.error(cmd + " does not exit");
            throw new JavaExecuteScriptException(e);
        }
        return this.exec(scriptPath, arg, timeoutScanDelay);
    }

    private ExecutionOutput exec(String scriptPath, String arg, long timeoutScanDelay) {
        ProcessBuilder processBuilder = new ProcessBuilder(Lists.newArrayList((Object[])new String[]{scriptPath, arg}));
        Process process = null;
        try {
            process = processBuilder.start();
            process.waitFor(timeoutScanDelay, TimeUnit.MILLISECONDS);
            return new ExecutionOutput(process, processBuilder);
        }
        catch (Exception e) {
            return new ExecutionOutput(e, process, processBuilder);
        }
    }
}

