/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.common.util;

import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class ExecutionOutput {
    private final List<String> command;
    private final Exception exception;
    private final String stdout;
    private final String stderr;
    private final int exitCode;

    public ExecutionOutput(Exception exception, Process process, ProcessBuilder processBuilder) {
        this.exception = exception;
        this.command = processBuilder.command();
        this.exitCode = -1;
        if (null != process) {
            this.stdout = ExecutionOutput.stdToString(process.getInputStream());
            this.stderr = ExecutionOutput.stdToString(process.getErrorStream()) + "|" + exception.getMessage();
        } else {
            this.stdout = "";
            this.stderr = "";
        }
    }

    public ExecutionOutput(Process process, ProcessBuilder processBuilder) {
        this.command = processBuilder.command();
        this.exception = null;
        this.exitCode = process.exitValue();
        this.stdout = ExecutionOutput.stdToString(process.getInputStream());
        this.stderr = ExecutionOutput.stdToString(process.getErrorStream());
    }

    public ExecutionOutput(int exitCode) {
        this.command = null;
        this.exception = null;
        this.exitCode = exitCode;
        this.stdout = null;
        this.stderr = null;
    }

    private static String stdToString(InputStream std) {
        CircularFifoQueue lastLines = new CircularFifoQueue(250);
        ArrayList<String> firstLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(std, StandardCharsets.UTF_8));){
            String c;
            while ((c = reader.readLine()) != null) {
                if (firstLines.size() < 250) {
                    firstLines.add(c);
                    continue;
                }
                lastLines.add((Object)c);
            }
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            return Stream.concat(firstLines.stream(), lastLines.stream()).collect(Collectors.joining(" | ")) + "|" + e.getMessage();
        }
        return Stream.concat(firstLines.stream(), lastLines.stream()).collect(Collectors.joining(" | "));
    }

    public Exception getException() {
        return this.exception;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public List<String> getCommand() {
        return this.command;
    }
}

