/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.metrics;

import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import io.prometheus.client.Collector;
import io.prometheus.client.Gauge;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProcessWorkflowMetricsCollector
extends Collector {
    private static final ProcessWorkflowMetricsCollector instance = new ProcessWorkflowMetricsCollector();
    private Map<Integer, Map<String, ProcessWorkflow>> workflowMap = new ConcurrentHashMap<Integer, Map<String, ProcessWorkflow>>();

    private ProcessWorkflowMetricsCollector() {
        this.register();
    }

    public static ProcessWorkflowMetricsCollector getInstance() {
        return instance;
    }

    public List<Collector.MetricFamilySamples> collect() {
        Gauge processWorkflowMetricPerTypeStateAndStatus = ((Gauge.Builder)Gauge.build((String)"vitam_processing_workflow_operation_total", (String)"Vitam operation count per state and status").labelNames(new String[]{"workflow", "state", "status"})).create();
        for (Map<String, ProcessWorkflow> all : this.workflowMap.values()) {
            for (ProcessWorkflow wf : all.values()) {
                ((Gauge.Child)processWorkflowMetricPerTypeStateAndStatus.labels(new String[]{wf.getLogbookTypeProcess().name(), wf.getState().name(), wf.getStatus().name()})).inc();
            }
        }
        return processWorkflowMetricPerTypeStateAndStatus.collect();
    }

    public void initialize(Map<Integer, Map<String, ProcessWorkflow>> workflowMap) {
        if (!(workflowMap instanceof ConcurrentHashMap)) {
            throw new IllegalArgumentException("Only ConcurrentHashMap is accepted");
        }
        this.workflowMap = workflowMap;
    }
}

