/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Set;

public final class AccessContractRestrictionHelper {
    private AccessContractRestrictionHelper() {
    }

    public static JsonNode applyAccessContractRestrictionForUnitForSelect(JsonNode queryDsl, AccessContractModel contract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, contract, true, true);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractRestrictionForObjectGroupForSelect(JsonNode queryDsl, AccessContractModel contract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, contract, false, true);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractExceptRuleRestrictionsForObjectGroupForSelect(JsonNode queryDsl, AccessContractModel contract) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, contract, false, false);
        return parser.getRequest().getFinalSelect();
    }

    public static JsonNode applyAccessContractRestrictionForUnitForUpdate(JsonNode queryDsl, AccessContractModel contract) throws InvalidParseOperationException, InvalidCreateOperationException {
        UpdateParserMultiple parser = new UpdateParserMultiple();
        parser.parse(queryDsl);
        AccessContractRestrictionHelper.applyAccessContractRestriction(parser, contract, true, true);
        return parser.getRequest().getFinalUpdate();
    }

    private static void applyAccessContractRestriction(RequestParserMultiple parser, AccessContractModel contract, boolean isUnit, boolean applyRuleRestrictions) throws InvalidCreateOperationException {
        String fieldToQuery;
        Set rootUnits = contract.getRootUnits();
        Set excludedRootUnits = contract.getExcludedRootUnits();
        ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
        BooleanQuery restrictionQueries = QueryHelper.and();
        String string = fieldToQuery = isUnit ? BuilderToken.PROJECTIONARGS.ID.exactToken() : BuilderToken.PROJECTIONARGS.UNITUPS.exactToken();
        if (!rootUnits.isEmpty()) {
            String[] rootUnitsArray = rootUnits.toArray(new String[0]);
            BooleanQuery rootUnitsRestriction = QueryHelper.or().add(new Query[]{QueryHelper.in((String)fieldToQuery, (String[])rootUnitsArray), QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ALLUNITUPS.exactToken(), (String[])rootUnitsArray)});
            restrictionQueries.add(new Query[]{rootUnitsRestriction});
        }
        if (!excludedRootUnits.isEmpty()) {
            String[] excludedRootUnitsArray = excludedRootUnits.toArray(new String[0]);
            BooleanQuery excludeRootUnitsRestriction = QueryHelper.and().add(new Query[]{QueryHelper.nin((String)fieldToQuery, (String[])excludedRootUnitsArray), QueryHelper.nin((String)BuilderToken.PROJECTIONARGS.ALLUNITUPS.exactToken(), (String[])excludedRootUnitsArray)});
            restrictionQueries.add(new Query[]{excludeRootUnitsRestriction});
        }
        if (applyRuleRestrictions && !contract.getRuleCategoryToFilter().isEmpty()) {
            Query rulesRestrictionQuery = AccessContractRestrictionHelper.getRulesRestrictionQuery(contract);
            restrictionQueries.add(new Query[]{rulesRestrictionQuery});
        }
        if (!contract.getEveryOriginatingAgency().booleanValue()) {
            Set prodServices = contract.getOriginatingAgencies();
            InQuery originatingAgencyRestriction = QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken(), (String[])prodServices.toArray(new String[0]));
            InQuery restriction = isUnit ? QueryHelper.or().add(new Query[]{originatingAgencyRestriction, QueryHelper.eq((String)BuilderToken.PROJECTIONARGS.UNITTYPE.exactToken(), (String)UnitType.HOLDING_UNIT.name())}) : originatingAgencyRestriction;
            restrictionQueries.add(new Query[]{restriction});
        }
        if (!restrictionQueries.getQueries().isEmpty()) {
            if (queryList.isEmpty()) {
                parser.getRequest().getQueries().add(restrictionQueries.setDepthLimit(0));
            } else {
                for (int i = 0; i < queryList.size(); ++i) {
                    Query query = (Query)queryList.get(i);
                    int depth = query.getParserRelativeDepth();
                    BooleanQuery restrictedQuery = QueryHelper.and().add(new Query[]{restrictionQueries, query});
                    restrictedQuery.setDepthLimit(depth);
                    parser.getRequest().getQueries().set(i, restrictedQuery);
                }
            }
        }
    }

    private static Query getRulesRestrictionQuery(AccessContractModel contract) throws InvalidCreateOperationException {
        BooleanQuery rulesRestrictionQuery = QueryHelper.and();
        for (RuleType ruleType : contract.getRuleCategoryToFilter()) {
            String ruleFieldName = BuilderToken.PROJECTIONARGS.COMPUTED_INHERITED_RULES.exactToken() + "." + ruleType.name() + ".MaxEndDate";
            CompareQuery maxEndDateExistsAndReached = QueryHelper.lt((String)ruleFieldName, (String)LocalDate.now().toString());
            rulesRestrictionQuery.add(new Query[]{maxEndDateExistsAndReached});
        }
        return rulesRestrictionQuery;
    }

    @Deprecated
    public static JsonNode applyAccessContractRestrictionOnOriginatingAgencies(JsonNode queryDsl) throws InvalidParseOperationException, InvalidCreateOperationException {
        AccessContractModel contract = VitamThreadUtils.getVitamSession().getContract();
        if (contract.getEveryOriginatingAgency().booleanValue()) {
            return queryDsl;
        }
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl);
        ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
        Set prodServices = contract.getOriginatingAgencies();
        InQuery originatingAgencyRestriction = QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken(), (String[])prodServices.toArray(new String[0]));
        if (queryList.isEmpty()) {
            parser.getRequest().getQueries().add(originatingAgencyRestriction.setDepthLimit(0));
        } else {
            for (int i = 0; i < queryList.size(); ++i) {
                Query query = (Query)queryList.get(i);
                int depth = query.getParserRelativeDepth();
                BooleanQuery restrictedQuery = QueryHelper.and().add(new Query[]{originatingAgencyRestriction, query});
                restrictedQuery.setDepthLimit(depth);
                parser.getRequest().getQueries().set(i, restrictedQuery);
            }
        }
        return parser.getRequest().getFinalSelect();
    }
}

