/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class QueryToElasticsearch {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(QueryToElasticsearch.class);

    private QueryToElasticsearch() {
    }

    public static QueryBuilder getRoots(String field, Collection<String> roots) {
        String[] values = new String[roots.size()];
        values = roots.toArray(values);
        return QueryBuilders.termsQuery((String)field, (String[])values);
    }

    public static void addRoots(BoolQueryBuilder query, String field, Collection<String> roots, int depth) {
        String[] values = new String[roots.size()];
        values = roots.toArray(values);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (int i = 1; i <= depth; ++i) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)(field + "." + i), (String[])values));
        }
        query.filter((QueryBuilder)boolQueryBuilder);
    }

    public static QueryBuilder getFullCommand(QueryBuilder command, QueryBuilder roots) {
        return QueryBuilders.boolQuery().must(command).must(roots);
    }

    public static List<SortBuilder<?>> getSorts(AbstractParser<?> requestParser, boolean score, DynamicParserTokens parserTokens) {
        int size;
        JsonNode orderby = requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
        int n = size = score && requestParser.hasFullTextQuery() ? 1 : 0;
        if (orderby != null && orderby.size() > 0) {
            size += orderby.size();
        }
        ArrayList sorts = new ArrayList(size);
        if (orderby == null || orderby.size() == 0) {
            if (score && requestParser.hasFullTextQuery()) {
                sorts.add(SortBuilders.scoreSort().order(SortOrder.DESC));
                return sorts;
            }
            return null;
        }
        Iterator iterator = orderby.fields();
        if (!iterator.hasNext()) {
            if (score && requestParser.hasFullTextQuery()) {
                sorts.add(SortBuilders.scoreSort().order(SortOrder.DESC));
                return sorts;
            }
            return null;
        }
        boolean scoreNotAdded = true;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            if (scoreNotAdded && score && requestParser.hasFullTextQuery() && !parserTokens.isNotAnalyzed((String)entry.getKey())) {
                scoreNotAdded = false;
                if ("_score".equals(entry.getKey()) || "#score".equals(entry.getKey())) {
                    if (((JsonNode)entry.getValue()).asInt() < 0) {
                        sorts.add(SortBuilders.scoreSort().order(SortOrder.DESC));
                        continue;
                    }
                    sorts.add(SortBuilders.scoreSort().order(SortOrder.ASC));
                    continue;
                }
                sorts.add(SortBuilders.scoreSort().order(SortOrder.DESC));
            }
            FieldSortBuilder fieldSort = SortBuilders.fieldSort((String)key);
            if (((JsonNode)entry.getValue()).asInt() < 0) {
                fieldSort.order(SortOrder.DESC);
                sorts.add((SortBuilder<?>)fieldSort);
                continue;
            }
            fieldSort.order(SortOrder.ASC);
            sorts.add((SortBuilder<?>)fieldSort);
        }
        if (scoreNotAdded && score && requestParser.hasFullTextQuery()) {
            sorts.add(SortBuilders.scoreSort().order(SortOrder.DESC));
        }
        return sorts;
    }

    public static QueryBuilder getCommand(Query query, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        BuilderToken.QUERY req = query.getQUERY();
        JsonNode content = query.getNode(req.exactToken());
        switch (req) {
            case AND: 
            case NOT: 
            case OR: {
                return QueryToElasticsearch.andOrNotCommand(req, query, adapter, parserTokens);
            }
            case EXISTS: 
            case MISSING: {
                return QueryToElasticsearch.existsMissingCommand(req, content);
            }
            case MATCH: 
            case MATCH_ALL: 
            case MATCH_PHRASE: 
            case MATCH_PHRASE_PREFIX: {
                return QueryToElasticsearch.matchCommand(req, content, parserTokens);
            }
            case SEARCH: {
                return QueryToElasticsearch.searchCommand(req, content, parserTokens);
            }
            case SUBOBJECT: {
                return QueryToElasticsearch.nestedSearchCommand(req, content, adapter, parserTokens);
            }
            case NIN: 
            case IN: {
                return QueryToElasticsearch.inCommand(req, content, parserTokens);
            }
            case RANGE: {
                return QueryToElasticsearch.rangeCommand(req, content, parserTokens);
            }
            case REGEX: {
                return QueryToElasticsearch.regexCommand(req, content, parserTokens);
            }
            case TERM: {
                return QueryToElasticsearch.termCommand(req, content, parserTokens);
            }
            case WILDCARD: {
                return QueryToElasticsearch.wildcardCommand(req, content, parserTokens);
            }
            case EQ: 
            case NE: {
                return QueryToElasticsearch.eqCommand(req, content, parserTokens);
            }
            case GT: 
            case GTE: 
            case LT: 
            case LTE: {
                return QueryToElasticsearch.compareCommand(req, content, parserTokens);
            }
            case ISNULL: {
                return QueryToElasticsearch.isNullCommand(req, content);
            }
            case SIZE: {
                return QueryToElasticsearch.sizeCommand(req, content);
            }
            case NOP: {
                return QueryBuilders.matchAllQuery();
            }
        }
        throw new InvalidParseOperationException("Invalid command: " + req.exactToken());
    }

    private static QueryBuilder sizeCommand(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        Script script = new Script("doc['" + (String)element.getKey() + "'].values.length == " + element.getValue());
        if (((String)element.getKey()).equals("_id")) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        return QueryBuilders.scriptQuery((Script)script);
    }

    private static QueryBuilder compareCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        JsonNode node = (JsonNode)element.getValue();
        Object value = GlobalDatasParser.getValue(node);
        switch (query) {
            case GT: {
                return QueryBuilders.rangeQuery((String)key).gt(value);
            }
            case GTE: {
                return QueryBuilders.rangeQuery((String)key).gte(value);
            }
            case LT: {
                return QueryBuilders.rangeQuery((String)key).lt(value);
            }
        }
        return QueryBuilders.rangeQuery((String)key).lte(value);
    }

    private static QueryBuilder searchCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        return QueryBuilders.simpleQueryStringQuery((String)((JsonNode)element.getValue()).asText()).field(attribute);
    }

    private static QueryBuilder nestedSearchCommand(BuilderToken.QUERY query, JsonNode content, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Query subQuery;
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        if (content == null || !content.fields().hasNext() || !((JsonNode)((Map.Entry)content.fields().next()).getValue()).fields().hasNext()) {
            throw new InvalidParseOperationException("$subobject query is not valid");
        }
        String path = (String)((Map.Entry)content.fields().next()).getKey();
        JsonNode subQueryJson = (JsonNode)((Map.Entry)content.fields().next()).getValue();
        try {
            subQuery = QueryParserHelper.query((String)((Map.Entry)subQueryJson.fields().next()).getKey(), (JsonNode)((Map.Entry)subQueryJson.fields().next()).getValue(), adapter);
        }
        catch (InvalidCreateOperationException e) {
            throw new InvalidParseOperationException("$subobject query is not valid");
        }
        return QueryBuilders.nestedQuery((String)path, (QueryBuilder)QueryToElasticsearch.getCommand(subQuery, adapter, parserTokens), (ScoreMode)ScoreMode.Avg);
    }

    private static QueryBuilder matchCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        JsonNode max = ((ObjectNode)content).remove(BuilderToken.QUERYARGS.MAX_EXPANSIONS.exactToken());
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String attribute = (String)element.getKey();
        if (parserTokens.isNotAnalyzed(attribute)) {
            return QueryToElasticsearch.matchCommandOverNonAnalyzedField(query, content, element, attribute);
        }
        if (max != null && !max.isMissingNode()) {
            return QueryToElasticsearch.matchCommandWithMaxExpansions(query, content, max, element);
        }
        QueryToElasticsearch.logCommand(query, content);
        switch (query) {
            case MATCH: {
                return QueryBuilders.matchQuery((String)((String)element.getKey()), (Object)((JsonNode)element.getValue()).asText()).operator(Operator.OR);
            }
            case MATCH_ALL: {
                return QueryBuilders.matchQuery((String)((String)element.getKey()), (Object)((JsonNode)element.getValue()).asText()).operator(Operator.AND);
            }
            case MATCH_PHRASE: {
                return QueryBuilders.matchPhraseQuery((String)((String)element.getKey()), (Object)((JsonNode)element.getValue()).asText());
            }
            case MATCH_PHRASE_PREFIX: {
                return QueryBuilders.matchPhrasePrefixQuery((String)((String)element.getKey()), (Object)((JsonNode)element.getValue()).asText());
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + query);
    }

    private static QueryBuilder matchCommandWithMaxExpansions(BuilderToken.QUERY query, JsonNode content, JsonNode max, Map.Entry<String, JsonNode> element) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported max_expansions operator");
        switch (query) {
            case MATCH: {
                return QueryBuilders.matchQuery((String)element.getKey(), (Object)element.getValue().asText()).maxExpansions(max.asInt()).operator(Operator.OR);
            }
            case MATCH_ALL: {
                return QueryBuilders.matchQuery((String)element.getKey(), (Object)element.getValue().asText()).maxExpansions(max.asInt()).operator(Operator.AND);
            }
            case MATCH_PHRASE: {
                return QueryBuilders.matchPhraseQuery((String)element.getKey(), (Object)element.getValue().asText());
            }
            case MATCH_PHRASE_PREFIX: {
                return QueryBuilders.matchPhrasePrefixQuery((String)element.getKey(), (Object)element.getValue().asText()).maxExpansions(max.asInt());
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + query);
    }

    private static QueryBuilder matchCommandOverNonAnalyzedField(BuilderToken.QUERY query, JsonNode content, Map.Entry<String, JsonNode> element, String attribute) {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Not_analyzed field: '" + attribute + "'");
        switch (query) {
            case MATCH: {
                return QueryBuilders.termsQuery((String)element.getKey(), (String[])element.getValue().toString().split(" "));
            }
        }
        return QueryBuilders.termQuery((String)element.getKey(), (String)element.getValue().toString());
    }

    private static QueryBuilder inCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.inCommandOverAnalyzedField(query, content);
        }
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        JsonNode node = (JsonNode)element.getValue();
        if (node instanceof ArrayNode) {
            QueryToElasticsearch.logCommand(query, content);
            for (Object jsonNode : node) {
                nodes.add((JsonNode)jsonNode);
            }
        } else {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Expecting value list");
            nodes.add(node);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (JsonNode value : nodes) {
            set.add(QueryToElasticsearch.getAsObject(value));
        }
        TermsQueryBuilder query2 = QueryBuilders.termsQuery((String)key, set);
        if (query == BuilderToken.QUERY.NIN) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)query2);
        }
        return query2;
    }

    private static QueryBuilder inCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        ArrayList<Object> nodes = new ArrayList<Object>();
        JsonNode node = (JsonNode)element.getValue();
        if (node instanceof ArrayNode) {
            for (Object jsonNode : node) {
                nodes.add(jsonNode);
            }
        } else {
            nodes.add(node);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (JsonNode jsonNode : nodes) {
            set.add(QueryToElasticsearch.getAsObject(jsonNode));
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().minimumShouldMatch(1);
        for (Object e : set) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)key, e).operator(Operator.OR));
        }
        BoolQueryBuilder query2 = boolQueryBuilder;
        if (query == BuilderToken.QUERY.NIN) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)query2);
        }
        return query2;
    }

    private static QueryBuilder rangeCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)element.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        if ("_id".equals(key)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        RangeQueryBuilder range = QueryBuilders.rangeQuery((String)key);
        Iterator iterator = ((JsonNode)element.getValue()).fields();
        block7: while (iterator.hasNext()) {
            BuilderToken.RANGEARGS arg;
            Map.Entry requestItem = (Map.Entry)iterator.next();
            try {
                String skey = (String)requestItem.getKey();
                if (!skey.startsWith("$")) {
                    throw new InvalidParseOperationException("Invalid Range query command: " + requestItem);
                }
                arg = BuilderToken.RANGEARGS.valueOf((String)skey.substring(1).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParseOperationException("Invalid Range query command: " + requestItem, (Throwable)e);
            }
            JsonNode node = (JsonNode)requestItem.getValue();
            switch (arg) {
                case GT: {
                    range.gt(QueryToElasticsearch.getAsObject(node));
                    continue block7;
                }
                case GTE: {
                    range.gte(QueryToElasticsearch.getAsObject(node));
                    continue block7;
                }
                case LT: {
                    range.lt(QueryToElasticsearch.getAsObject(node));
                    continue block7;
                }
            }
            range.lte(QueryToElasticsearch.getAsObject(node));
        }
        return range;
    }

    private static QueryBuilder regexCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.regexCommandOverAnalyzedField(query, content);
        }
        if (key.equals("_id")) {
            return QueryToElasticsearch.regexCommandOverIdField(query, content);
        }
        String value = ((JsonNode)entry.getValue()).asText();
        QueryToElasticsearch.logCommand(query, content);
        return QueryBuilders.regexpQuery((String)key, (String)value);
    }

    private static QueryBuilder regexCommandOverIdField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported ID field");
        String value = ((JsonNode)entry.getValue()).asText().replaceAll("[\\.\\?\\+\\*\\|\\{\\}\\[\\]\\(\\)\\\"\\\\\\#\\@\\&\\<\\>\\~]", " ");
        value = QueryToElasticsearch.removeAllDoubleSpace(value);
        return QueryBuilders.termsQuery((String)key, (String[])value.split(" "));
    }

    private static QueryBuilder regexCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        String value = "/" + ((JsonNode)entry.getValue()).asText() + "/";
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        return QueryBuilders.regexpQuery((String)key, (String)value);
    }

    private static QueryBuilder termCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        boolean multiple = false;
        BoolQueryBuilder query2 = null;
        if (content.size() > 1) {
            multiple = true;
            query2 = QueryBuilders.boolQuery();
        }
        Iterator iterator = content.fields();
        while (iterator.hasNext()) {
            JsonNode node;
            Map.Entry requestItem = (Map.Entry)iterator.next();
            String key = (String)requestItem.getKey();
            if ("_id".equals(key)) {
                QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
            }
            if ((node = (JsonNode)requestItem.getValue()).isNumber()) {
                if (!multiple) {
                    return QueryBuilders.termQuery((String)key, (Object)QueryToElasticsearch.getAsObject(node));
                }
                query2.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)QueryToElasticsearch.getAsObject(node)));
                continue;
            }
            String val = node.asText();
            Object query3 = parserTokens.isNotAnalyzed(key) ? QueryBuilders.termQuery((String)key, (String)val) : QueryBuilders.matchQuery((String)key, (Object)val).operator(Operator.AND);
            if (!multiple) {
                return query3;
            }
            query2.must((QueryBuilder)query3);
        }
        return query2;
    }

    private static QueryBuilder wildcardCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        String val = node.asText();
        if (!parserTokens.isNotAnalyzed(key)) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        } else if (key.equals("_id")) {
            QueryToElasticsearch.logUnsupportedCommand(query, content, "Unsupported ID field");
        } else {
            QueryToElasticsearch.logCommand(query, content);
        }
        return QueryBuilders.wildcardQuery((String)key, (String)val);
    }

    @Deprecated
    private static String removeAllDoubleSpace(String value) {
        String oldValue = value;
        String newValue = oldValue.replace("  ", " ");
        while (newValue.length() != oldValue.length()) {
            oldValue = newValue;
            newValue = oldValue.replace("  ", " ");
        }
        return newValue;
    }

    private static QueryBuilder eqCommand(BuilderToken.QUERY query, JsonNode content, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        if (!parserTokens.isNotAnalyzed(key)) {
            return QueryToElasticsearch.eqCommandOverAnalyzedField(query, content);
        }
        QueryToElasticsearch.logCommand(query, content);
        TermQueryBuilder query2 = QueryBuilders.termQuery((String)key, (Object)QueryToElasticsearch.getAsObject(node));
        if (query == BuilderToken.QUERY.NE) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)query2);
        }
        return query2;
    }

    private static QueryBuilder eqCommandOverAnalyzedField(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        Map.Entry entry = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)content);
        String key = (String)entry.getKey();
        JsonNode node = (JsonNode)entry.getValue();
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Analyzed field: '" + key + "'");
        MatchQueryBuilder query2 = QueryBuilders.matchQuery((String)key, (Object)QueryToElasticsearch.getAsObject(node)).operator(Operator.AND);
        if (query == BuilderToken.QUERY.NE) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)query2);
        }
        return query2;
    }

    private static QueryBuilder existsMissingCommand(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        String fieldname = content.asText();
        if ("_id".equals(fieldname)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        ExistsQueryBuilder queryBuilder = QueryBuilders.existsQuery((String)fieldname);
        switch (query) {
            case MISSING: {
                QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)queryBuilder);
            }
            case EXISTS: {
                QueryToElasticsearch.logCommand(query, content);
                return queryBuilder;
            }
        }
        throw new InvalidParseOperationException("Not correctly parsed: " + query);
    }

    private static QueryBuilder isNullCommand(BuilderToken.QUERY query, JsonNode content) throws InvalidParseOperationException {
        QueryToElasticsearch.logUnsupportedCommand(query, content, "Deprecated. Should not be invoked anymore.");
        String fieldname = content.asText();
        if ("_id".equals(fieldname)) {
            QueryToElasticsearch.logWarnUnsupportedIdForCommand(query, content);
        }
        return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)fieldname));
    }

    private static QueryBuilder andOrNotCommand(BuilderToken.QUERY query, Query req, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        QueryToElasticsearch.logCommand(query, req.getCurrentObject());
        BooleanQuery nthrequest = (BooleanQuery)req;
        List sub = nthrequest.getQueries();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        block4: for (Query value : sub) {
            switch (query) {
                case AND: {
                    boolQueryBuilder.must(QueryToElasticsearch.getCommand(value, adapter, parserTokens));
                    continue block4;
                }
                case NOT: {
                    boolQueryBuilder.mustNot(QueryToElasticsearch.getCommand(value, adapter, parserTokens));
                    continue block4;
                }
            }
            boolQueryBuilder.minimumShouldMatch(1).should(QueryToElasticsearch.getCommand(value, adapter, parserTokens));
        }
        return boolQueryBuilder;
    }

    public static List<AggregationBuilder> getFacets(AbstractParser<?> requestParser, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        ArrayList<AggregationBuilder> builders = new ArrayList<AggregationBuilder>();
        if (requestParser.getRequest() instanceof SelectMultiQuery) {
            List facets = ((SelectMultiQuery)requestParser.getRequest()).getFacets();
            for (Facet facet : facets) {
                switch (facet.getCurrentTokenFACET()) {
                    case TERMS: {
                        QueryToElasticsearch.termsFacet(builders, facet);
                        break;
                    }
                    case DATE_RANGE: {
                        QueryToElasticsearch.dateRangeFacet(builders, facet);
                        break;
                    }
                    case FILTERS: {
                        QueryToElasticsearch.filtersFacet(builders, facet, requestParser.getAdapter(), parserTokens);
                        break;
                    }
                }
            }
        }
        return builders;
    }

    private static void dateRangeFacet(List<AggregationBuilder> builders, Facet facet) {
        JsonNode dateRange = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        DateRangeAggregationBuilder dateRangeBuilder = AggregationBuilders.dateRange((String)facet.getName());
        dateRangeBuilder.field(dateRange.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText());
        dateRangeBuilder.format(dateRange.get(BuilderToken.FACETARGS.FORMAT.exactToken()).asText());
        JsonNode ranges = dateRange.get(BuilderToken.FACETARGS.RANGES.exactToken());
        ranges.forEach(item -> {
            JsonNode from = item.get(BuilderToken.FACETARGS.FROM.exactToken());
            JsonNode to = item.get(BuilderToken.FACETARGS.TO.exactToken());
            if (from != null && !(from instanceof NullNode) && to != null && !(to instanceof NullNode)) {
                dateRangeBuilder.addRange(from.asText(), to.asText());
            } else if (from != null && !(from instanceof NullNode)) {
                dateRangeBuilder.addUnboundedFrom(from.asText());
            } else if (to != null && !(to instanceof NullNode)) {
                dateRangeBuilder.addUnboundedTo(to.asText());
            }
        });
        if (dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null) {
            builders.add((AggregationBuilder)AggregationBuilders.nested((String)facet.getName(), (String)dateRange.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText()).subAggregation((AggregationBuilder)dateRangeBuilder));
            return;
        }
        builders.add((AggregationBuilder)dateRangeBuilder);
    }

    private static void termsFacet(List<AggregationBuilder> builders, Facet facet) {
        JsonNode terms = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        String fieldName = terms.get(BuilderToken.FACETARGS.FIELD.exactToken()).asText();
        TermsAggregationBuilder termsBuilder = AggregationBuilders.terms((String)facet.getName());
        termsBuilder.field(fieldName);
        if (terms.has(BuilderToken.FACETARGS.SIZE.exactToken())) {
            int size = terms.get(BuilderToken.FACETARGS.SIZE.exactToken()).asInt();
            termsBuilder.size(size);
            termsBuilder.shardSize((int)Math.min(Integer.MAX_VALUE, (long)size * 3L + 10L));
        }
        if (terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()) != null) {
            builders.add((AggregationBuilder)AggregationBuilders.nested((String)facet.getName(), (String)terms.get(BuilderToken.FACETARGS.SUBOBJECT.exactToken()).asText()).subAggregation((AggregationBuilder)termsBuilder));
            return;
        }
        builders.add((AggregationBuilder)termsBuilder);
    }

    private static void filtersFacet(List<AggregationBuilder> builders, Facet facet, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws InvalidParseOperationException {
        JsonNode filtersFacetNode = facet.getCurrentFacet().get(facet.getCurrentTokenFACET().exactToken());
        HashMap<String, Query> filtersMap = new HashMap<String, Query>();
        ArrayNode filtersNode = (ArrayNode)filtersFacetNode.get(BuilderToken.FACETARGS.QUERY_FILTERS.exactToken());
        for (Object node : filtersNode) {
            String string = node.get(BuilderToken.FACETARGS.NAME.exactToken()).asText();
            JsonNode queryNode = node.get(BuilderToken.FACETARGS.QUERY.exactToken());
            Map.Entry queryItem = JsonHandler.checkUnicity((String)"RootRequest", (JsonNode)queryNode);
            try {
                Query query = QueryParserHelper.query((String)queryItem.getKey(), (JsonNode)queryItem.getValue(), adapter);
                filtersMap.put(string, query);
            }
            catch (InvalidCreateOperationException e) {
                throw new InvalidParseOperationException((Throwable)e);
            }
        }
        ArrayList<FiltersAggregator.KeyedFilter> keyFilters = new ArrayList<FiltersAggregator.KeyedFilter>();
        for (Map.Entry entry : filtersMap.entrySet()) {
            keyFilters.add(new FiltersAggregator.KeyedFilter((String)entry.getKey(), QueryToElasticsearch.getCommand((Query)entry.getValue(), adapter, parserTokens)));
        }
        FiltersAggregator.KeyedFilter[] keyFiltersArray = (FiltersAggregator.KeyedFilter[])keyFilters.toArray(FiltersAggregator.KeyedFilter[]::new);
        FiltersAggregationBuilder filtersAggregationBuilder = AggregationBuilders.filters((String)facet.getName(), (FiltersAggregator.KeyedFilter[])keyFiltersArray);
        builders.add((AggregationBuilder)filtersAggregationBuilder);
    }

    private static Object getAsObject(JsonNode value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isInt() || value.isLong()) {
            return value.asLong();
        }
        if (value.isFloat() || value.isDouble()) {
            return value.asDouble();
        }
        return value.asText();
    }

    private static void logCommand(BuilderToken.QUERY query, JsonNode content) {
        LOGGER.debug(String.format("Command #QUERY: %s . Content: %s", query, content));
    }

    private static void logWarnUnsupportedIdForCommand(BuilderToken.QUERY query, JsonNode content) {
        LOGGER.warn(String.format("Command #QUERY: %s using id is not recommended. Content: %s", query, content));
    }

    private static void logUnsupportedCommand(BuilderToken.QUERY query, JsonNode content, String message) {
        LOGGER.warn(String.format("UNSUPPORTED command #QUERY: %s. Message: %s. Content: %s", query, message, content));
    }
}

