/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Iterator;

public class SelectParserSingle
extends RequestParserSingle {
    public SelectParserSingle() {
    }

    public SelectParserSingle(VarNameAdapter adapter) {
        super(adapter);
    }

    @Override
    protected RequestSingle getNewRequest() {
        return new Select();
    }

    @Override
    public void parse(JsonNode request) throws InvalidParseOperationException {
        this.parseJson(request);
        this.internalParseSelect();
    }

    private void internalParseSelect() throws InvalidParseOperationException {
        this.projectionParse(this.rootNode.get(BuilderToken.GLOBAL.PROJECTION.exactToken()));
    }

    @Override
    public void parseQueryOnly(String query) throws InvalidParseOperationException {
        super.parseQueryOnly(query);
        this.projectionParse((JsonNode)JsonHandler.createObjectNode());
    }

    public void projectionParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)1000);
        try {
            ((Select)this.request).resetUsedProjection();
            ObjectNode node = JsonHandler.createObjectNode();
            if (rootNode.has(BuilderToken.PROJECTION.FIELDS.exactToken())) {
                this.adapter.setVarsValue(node, rootNode.path(BuilderToken.PROJECTION.FIELDS.exactToken()));
                ((ObjectNode)rootNode).set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)node);
            }
            ((Select)this.request).setProjection(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Projection: " + rootNode, (Throwable)e);
        }
    }

    public void addProjection(ObjectNode slice, ObjectNode allFields) throws InvalidParseOperationException {
        if (slice == null || allFields == null) {
            throw new InvalidParseOperationException("addProjection does not accept null parameters");
        }
        GlobalDatas.sanityParametersCheck((String)slice.toString(), (int)1000);
        try {
            ObjectNode node = (ObjectNode)((Select)this.request).getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
            if (node == null) {
                node = ((Select)this.request).getProjection().putObject(BuilderToken.PROJECTION.FIELDS.exactToken());
                node.setAll(allFields);
            } else {
                Iterator names = slice.fieldNames();
                if (names.hasNext() && node.has((String)names.next())) {
                    return;
                }
            }
            node.setAll(slice);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Projection: " + slice, (Throwable)e);
        }
    }

    @Override
    public Select getRequest() {
        return (Select)this.request;
    }
}

