/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Insert;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.query.PathQuery;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapterExternal;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.InsertParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserHelperSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Map;

public abstract class RequestParserSingle
extends AbstractParser<RequestSingle> {
    public RequestParserSingle() {
        this.request = this.getNewRequest();
        this.adapter = new SingleVarNameAdapterExternal();
    }

    public RequestParserSingle(VarNameAdapter adapter) {
        this.request = this.getNewRequest();
        this.adapter = adapter;
    }

    private void internalParse() throws InvalidParseOperationException {
        GlobalDatasParser.sanityRequestCheck(this.sourceRequest);
        if (this.request != null) {
            ((RequestSingle)this.request).reset();
        } else {
            this.request = this.getNewRequest();
        }
        this.hasFullTextQuery = false;
        if (this.rootNode == null || this.rootNode.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): RequestRoot");
        }
        this.queryParse(this.rootNode.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        this.filterParse(this.rootNode.get(BuilderToken.GLOBAL.FILTER.exactToken()));
    }

    @Override
    protected void parseJson(JsonNode jsonRequest) throws InvalidParseOperationException {
        super.parseJson(jsonRequest);
        this.internalParse();
    }

    protected void parseQueryOnly(String query) throws InvalidParseOperationException {
        GlobalDatasParser.sanityRequestCheck(query);
        this.sourceRequest = query;
        if (this.request != null) {
            ((RequestSingle)this.request).reset();
        } else {
            this.request = this.getNewRequest();
        }
        this.hasFullTextQuery = false;
        this.rootNode = JsonHandler.getFromString((String)query);
        if (this.rootNode.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): RequestRoot");
        }
        this.queryParse(this.rootNode);
        this.filterParse((JsonNode)JsonHandler.createObjectNode());
    }

    protected void filterParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)10);
        try {
            this.parseOrderByFilter(rootNode);
            ((RequestSingle)this.request).setFilter(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Filter: " + rootNode, (Throwable)e);
        }
    }

    protected void queryParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        try {
            this.analyzeRootQuery(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Query: " + rootNode, (Throwable)e);
        }
    }

    protected void analyzeRootQuery(JsonNode command) throws InvalidParseOperationException, InvalidCreateOperationException {
        PathQuery query;
        if (command == null) {
            throw new InvalidParseOperationException("Not correctly parsed");
        }
        this.hasFullTextCurrentQuery = false;
        this.hasFullTextQuery = false;
        if (command.size() == 0) {
            ((RequestSingle)this.request).setQuery((Query)QueryParserHelper.nop());
            return;
        }
        Map.Entry queryItem = JsonHandler.checkUnicity((String)"RootRequest", (JsonNode)command);
        if (((String)queryItem.getKey()).equalsIgnoreCase(BuilderToken.QUERY.PATH.exactToken())) {
            ArrayNode array = (ArrayNode)queryItem.getValue();
            query = QueryParserHelper.path((JsonNode)array, this.adapter);
        } else {
            query = this.analyzeOneCommand((String)queryItem.getKey(), (JsonNode)queryItem.getValue());
            if (query == null) {
                ((RequestSingle)this.request).setQuery((Query)QueryParserHelper.nop());
                return;
            }
        }
        this.hasFullTextQuery = this.hasFullTextCurrentQuery;
        ((RequestSingle)this.request).setQuery(query.setFullText(this.hasFullTextQuery));
    }

    public void addCondition(Query condition) throws InvalidCreateOperationException, InvalidParseOperationException {
        RequestParserSingle newOne = RequestParserHelperSingle.getParser(this.rootNode.deepCopy(), this.adapter);
        Query query = ((RequestSingle)this.request).getQuery();
        Query newQuery = null;
        if (query == null) {
            newQuery = condition;
            ((RequestSingle)this.getRequest()).setQuery(newQuery);
        } else {
            newQuery = QueryHelper.and().add(new Query[]{query, condition});
            ((RequestSingle)this.getRequest()).setQuery(newQuery);
        }
        if (newOne instanceof SelectParserSingle) {
            this.parse((JsonNode)((Select)this.getRequest()).getFinalSelect().deepCopy());
        } else if (newOne instanceof InsertParserSingle) {
            this.parse((JsonNode)((Insert)this.getRequest()).getFinalInsert().deepCopy());
        } else if (newOne instanceof UpdateParserSingle) {
            this.parse((JsonNode)((Update)this.getRequest()).getFinalUpdate().deepCopy());
        } else {
            this.parse((JsonNode)((Delete)this.getRequest()).getFinalDelete().deepCopy());
        }
        newOne.request = null;
        newOne.rootNode = null;
        newOne.sourceRequest = null;
    }

    public String toString() {
        return ((RequestSingle)this.request).toString();
    }

    @Override
    public boolean hintNoTimeout() {
        JsonNode jsonNode = ((RequestSingle)this.request).getFilter().get(BuilderToken.SELECTFILTER.HINT.exactToken());
        if (jsonNode != null) {
            ArrayNode array = (ArrayNode)jsonNode;
            for (JsonNode node : array) {
                if (!BuilderToken.FILTERARGS.NOTIMEOUT.exactToken().equals(node.asText())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getLastDepth() {
        return 0;
    }

    @Override
    public BuilderToken.FILTERARGS model() {
        return BuilderToken.FILTERARGS.OTHERS;
    }

    @Override
    public boolean hintCache() {
        return false;
    }
}

