/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.facet.FacetParserHelper;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;

public class SelectParserMultiple
extends RequestParserMultiple {
    public SelectParserMultiple() {
    }

    public SelectParserMultiple(VarNameAdapter adapter) {
        super(adapter);
    }

    @Override
    protected RequestMultiple getNewRequest() {
        return new SelectMultiQuery();
    }

    @Override
    public void parse(JsonNode request) throws InvalidParseOperationException {
        this.parseJson(request);
        this.internalParseSelect();
    }

    private void internalParseSelect() throws InvalidParseOperationException {
        this.projectionParse(this.rootNode.get(BuilderToken.GLOBAL.PROJECTION.exactToken()));
        this.facetsParse(this.rootNode.get(BuilderToken.GLOBAL.FACETS.exactToken()));
        this.thresholdParse(this.rootNode.get(BuilderToken.GLOBAL.THRESOLD.exactToken()));
        this.parseTrackTotalHits(this.rootNode);
    }

    @Override
    public void parseQueryOnly(String query) throws InvalidParseOperationException {
        super.parseQueryOnly(query);
        this.projectionParse((JsonNode)JsonHandler.createObjectNode());
    }

    protected void facetsParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        if (!rootNode.isArray()) {
            throw new InvalidParseOperationException("Parse in error for Field: should be an array");
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)1000);
        try {
            ((SelectMultiQuery)this.request).resetFacets();
            for (JsonNode facet : rootNode) {
                if (!facet.has(BuilderToken.FACETARGS.NAME.exactToken())) {
                    throw new InvalidParseOperationException("Invalid parse: name is mandatory");
                }
                BuilderToken.FACET facetCommand = SelectParserMultiple.getFacetCommand(facet);
                ((SelectMultiQuery)this.request).addFacets(new Facet[]{this.analyzeOneFacet(facet, facetCommand)});
            }
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Field: " + rootNode, (Throwable)e);
        }
    }

    public static final BuilderToken.FACET getFacetCommand(JsonNode facet) throws InvalidParseOperationException {
        for (BuilderToken.FACET facetCommand : BuilderToken.FACET.values()) {
            if (!facet.has(facetCommand.exactToken())) continue;
            return facetCommand;
        }
        throw new InvalidParseOperationException("Invalid parse : facet command not found");
    }

    protected Facet analyzeOneFacet(JsonNode facet, BuilderToken.FACET facetCommand) throws InvalidCreateOperationException, InvalidParseOperationException {
        switch (facetCommand) {
            case TERMS: {
                return FacetParserHelper.terms(facet, this.adapter);
            }
            case DATE_RANGE: {
                return FacetParserHelper.dateRange(facet, this.adapter);
            }
            case FILTERS: {
                return FacetParserHelper.filters(facet, this.adapter);
            }
        }
        throw new InvalidParseOperationException("Invalid parse: command not a facet " + facetCommand.exactToken());
    }

    protected void projectionParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)1000);
        try {
            ((SelectMultiQuery)this.request).resetUsageProjection().resetUsedProjection();
            ObjectNode node = JsonHandler.createObjectNode();
            if (rootNode.has(BuilderToken.PROJECTION.FIELDS.exactToken())) {
                this.adapter.setVarsValue(node, rootNode.path(BuilderToken.PROJECTION.FIELDS.exactToken()));
                ((ObjectNode)rootNode).set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)node);
            }
            ((SelectMultiQuery)this.request).setProjection(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Projection: " + rootNode, (Throwable)e);
        }
    }

    protected void thresholdParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        try {
            ((SelectMultiQuery)this.request).setThreshold(Long.valueOf(rootNode.asLong()));
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Action: " + rootNode, (Throwable)e);
        }
    }

    protected void parseTrackTotalHits(JsonNode rootNode) throws InvalidParseOperationException {
        if (!rootNode.has(BuilderToken.GLOBAL.FILTER.exactToken())) {
            return;
        }
        JsonNode filterNode = rootNode.get(BuilderToken.GLOBAL.FILTER.exactToken());
        if (!filterNode.has(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken())) {
            return;
        }
        JsonNode trackTotalHits = filterNode.get(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken());
        if (!trackTotalHits.isBoolean()) {
            throw new InvalidParseOperationException("Invalid trackTotalHits node format");
        }
        ((SelectMultiQuery)this.request).trackTotalHits(trackTotalHits.asBoolean());
    }

    @Override
    public SelectMultiQuery getRequest() {
        return (SelectMultiQuery)this.request;
    }
}

