/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.collections;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.collections.VitamDescriptionType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VitamDescriptionLoader {
    private static final TypeReference<List<VitamDescriptionType>> LIST_TYPE_REFERENCE = new TypeReference<List<VitamDescriptionType>>(){};
    private final VitamDescriptionResolver vitamDescriptionResolver;

    @VisibleForTesting
    public VitamDescriptionLoader(List<VitamDescriptionType> descriptionTypeByName) {
        this.vitamDescriptionResolver = new VitamDescriptionResolver(descriptionTypeByName);
    }

    public VitamDescriptionLoader(String collectionName) {
        this(VitamDescriptionLoader.loadDescriptions(collectionName + "-vitam-description.json"));
    }

    private static List<VitamDescriptionType> loadDescriptions(String fileName) {
        try {
            return new ArrayList<VitamDescriptionType>(Collections.unmodifiableList((List)JsonHandler.getFromInputStreamAsTypeReference((InputStream)PropertiesUtils.getResourceAsStream((String)fileName), LIST_TYPE_REFERENCE)));
        }
        catch (InvalidFormatException | InvalidParseOperationException | FileNotFoundException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public VitamDescriptionResolver getVitamDescriptionResolver() {
        return this.vitamDescriptionResolver;
    }
}

