/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.collections;

import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.collections.VitamDescriptionType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamicParserTokens {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DynamicParserTokens.class);
    private final VitamDescriptionResolver vitamDescriptionResolver;
    private final Map<String, OntologyModel> ontologyModelsByName;

    public DynamicParserTokens(VitamDescriptionResolver vitamDescriptionResolver, List<OntologyModel> ontologyModels) {
        this.vitamDescriptionResolver = vitamDescriptionResolver;
        this.ontologyModelsByName = ontologyModels.stream().collect(Collectors.toMap(OntologyModel::getIdentifier, o -> o));
    }

    public boolean isNotAnalyzed(String name) {
        VitamDescriptionType description = this.vitamDescriptionResolver.resolve(name);
        if (description != null) {
            return !description.getType().equals((Object)VitamDescriptionType.VitamType.text);
        }
        OntologyModel ontologyModel = this.ontologyModelsByName.get(name);
        if (ontologyModel != null) {
            return !ontologyModel.getType().isAnalyzed();
        }
        LOGGER.info(String.format("By default unknown fields are analyzed so here '%s' is ANALYZED.", name));
        return false;
    }

    public boolean isAnArray(String name) {
        VitamDescriptionType description = this.vitamDescriptionResolver.resolve(name);
        if (description == null) {
            LOGGER.info(String.format("By default unknown fields are array so here '%s' is an ARRAY.", name));
            return true;
        }
        return description.getCardinality().equals((Object)VitamDescriptionType.VitamCardinality.many);
    }
}

