/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Date;
import java.util.List;

public class Action {
    private static final String ACTION2 = "Action ";
    private static final String CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME = " cannot be created with empty variable name";
    protected ObjectNode currentAction = JsonHandler.createObjectNode();
    protected JsonNode currentObject = this.currentAction;
    protected BuilderToken.UPDATEACTION currentUPDATEACTION = null;
    protected boolean ready = false;

    protected Action() {
    }

    protected final void createActionValueArrayVariable(BuilderToken.UPDATEACTION action, String variableName) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken()).putArray(variableName.trim());
    }

    protected final void createActionVariables(BuilderToken.UPDATEACTION action, String ... variableNames) throws InvalidCreateOperationException {
        ArrayNode node = ((ObjectNode)this.currentObject).putArray(action.exactToken());
        for (String var : variableNames) {
            if (var == null || var.trim().isEmpty()) continue;
            try {
                GlobalDatas.sanityParameterCheck(var);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            node.add(var.trim());
        }
        this.currentObject = node;
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, long value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, double value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, String value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, List<?> value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ArrayNode array = JsonHandler.createArrayNode();
        GlobalDatas.setArrayValueFromList(array, value);
        ((ObjectNode)this.currentObject).set(variableName.trim(), (JsonNode)array);
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, boolean value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createActionVariableValue(BuilderToken.UPDATEACTION action, String variableName, Date value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION2 + action + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(action.exactToken());
        ((ObjectNode)this.currentObject).set(variableName.trim(), (JsonNode)GlobalDatas.getDate(value));
    }

    public void clean() {
        this.currentAction.removeAll();
        this.currentObject = this.currentAction;
        this.currentUPDATEACTION = null;
        this.ready = false;
    }

    public ObjectNode getCurrentAction() {
        return this.currentAction;
    }

    public JsonNode getCurrentObject() {
        return this.currentObject;
    }

    public BuilderToken.UPDATEACTION getUPDATEACTION() {
        return this.currentUPDATEACTION;
    }

    public boolean isReady() {
        return this.ready;
    }

    protected void setReady(boolean ready) {
        this.ready = ready;
    }

    public String toString() {
        return JsonHandler.unprettyPrint((Object)this.currentAction);
    }
}

