/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.Date;
import java.util.Map;

public class TermQuery
extends Query {
    private static final String CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME = " cannot be updated with empty variable name";
    private static final String QUERY2 = "Query ";
    private static final String CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY = "Cannot add a term element since this is not a Term Query: ";

    protected TermQuery() {
    }

    public TermQuery(String variableName, String value) throws InvalidCreateOperationException {
        this.createQueryVariableValue(BuilderToken.QUERY.TERM, variableName, value);
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public TermQuery(String variableName, long value) throws InvalidCreateOperationException {
        this.createQueryVariableValue(BuilderToken.QUERY.TERM, variableName, value);
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public TermQuery(String variableName, double value) throws InvalidCreateOperationException {
        this.createQueryVariableValue(BuilderToken.QUERY.TERM, variableName, value);
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public TermQuery(String variableName, boolean value) throws InvalidCreateOperationException {
        this.createQueryVariableValue(BuilderToken.QUERY.TERM, variableName, value);
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public TermQuery(String variableName, Date value) throws InvalidCreateOperationException {
        this.createQueryVariableValue(BuilderToken.QUERY.TERM, variableName, value);
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public TermQuery(Map<String, Object> variableNameValue) throws InvalidCreateOperationException {
        this.currentObject = ((ObjectNode)this.currentObject).putObject(BuilderToken.QUERY.TERM.exactToken());
        ObjectNode node = (ObjectNode)this.currentObject;
        for (Map.Entry<String, Object> entry : variableNameValue.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.trim().isEmpty()) continue;
            try {
                GlobalDatas.sanityParameterCheck(name);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            Object val = entry.getValue();
            node.set(name.trim(), GlobalDatas.getValueJsonNode(val));
        }
        this.currentTokenQUERY = BuilderToken.QUERY.TERM;
        this.setReady(true);
    }

    public final TermQuery add(String variableName, String value) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.TERM) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY + this.currentTokenQUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final TermQuery add(String variableName, long value) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.TERM) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY + this.currentTokenQUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final TermQuery add(String variableName, double value) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.TERM) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY + this.currentTokenQUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final TermQuery add(String variableName, boolean value) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.TERM) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY + this.currentTokenQUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final TermQuery add(String variableName, Date value) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.TERM) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_TERM_ELEMENT_SINCE_THIS_IS_NOT_A_TERM_QUERY + this.currentTokenQUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).set(variableName.trim(), (JsonNode)GlobalDatas.getDate(value));
        return this;
    }
}

