/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Date;

public class Query {
    private static final String CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME = " cannot be created with empty variable name";
    private static final String QUERY2 = "Query ";
    public static final String DATE = "$date";
    protected ObjectNode currentQuery = JsonHandler.createObjectNode();
    protected JsonNode currentObject = this.currentQuery;
    protected BuilderToken.QUERY currentTokenQUERY = null;
    protected boolean isFullText = false;
    protected boolean ready = false;
    protected int relativedepth = 1;
    protected int exactdepth = 0;
    protected int extraInfo;

    protected Query() {
    }

    protected final void createQueryArray(BuilderToken.QUERY query) {
        this.currentObject = ((ObjectNode)this.currentObject).putArray(query.exactToken());
    }

    protected final void createQueryVariable(BuilderToken.QUERY query, String variableName) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(query.exactToken(), variableName.trim());
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, long value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, double value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, String value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, Date value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).set(variableName.trim(), (JsonNode)GlobalDatas.getDate(value));
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, boolean value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    protected final void createQueryVariableValue(BuilderToken.QUERY query, String variableName, JsonNode value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + query + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(query.exactToken());
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
    }

    public void clean() {
        this.currentQuery.removeAll();
        this.currentObject = this.currentQuery;
        this.currentTokenQUERY = null;
        this.ready = false;
    }

    protected void cleanDepth() {
        this.currentQuery.remove(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken());
        this.currentQuery.remove(BuilderToken.QUERYARGS.DEPTH.exactToken());
        this.relativedepth = 1;
        this.exactdepth = 0;
    }

    public final Query setExactDepthLimit(int exactdepth) {
        this.cleanDepth();
        if (exactdepth != 0) {
            this.exactdepth = exactdepth;
            this.currentQuery.put(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken(), exactdepth);
        }
        return this;
    }

    public final Query setRelativeDepthLimit(int relativedepth) {
        this.cleanDepth();
        this.relativedepth = relativedepth;
        this.currentQuery.put(BuilderToken.QUERYARGS.DEPTH.exactToken(), relativedepth);
        return this;
    }

    public final Query setDepthLimit(int relativedepth) {
        return this.setRelativeDepthLimit(relativedepth);
    }

    public ObjectNode getCurrentQuery() {
        return this.currentQuery;
    }

    public JsonNode getNode(String key) {
        return this.currentQuery.get(key);
    }

    public JsonNode getCurrentObject() {
        return this.currentObject;
    }

    public BuilderToken.QUERY getQUERY() {
        return this.currentTokenQUERY;
    }

    public boolean isReady() {
        return this.ready;
    }

    protected Query setReady(boolean ready) {
        this.ready = ready;
        return this;
    }

    public Query setExtraInfo(int val) {
        this.extraInfo = val;
        return this;
    }

    public int getExtraInfo() {
        return this.extraInfo;
    }

    public final boolean isFullText() {
        return this.isFullText;
    }

    public final Query setFullText(boolean isFullText) {
        this.isFullText = isFullText;
        return this;
    }

    public final int getParserExactdepth() {
        return this.exactdepth;
    }

    public final Query setParserExactdepth(int exactdepth) {
        this.exactdepth = exactdepth;
        return this;
    }

    public final int getParserRelativeDepth() {
        return this.relativedepth;
    }

    public final Query setParserRelativeDepth(int relativedepth) {
        this.relativedepth = relativedepth;
        return this;
    }

    public String toString() {
        return JsonHandler.unprettyPrint((Object)this.currentQuery);
    }
}

