/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;

public class PathQuery
extends Query {
    protected PathQuery() {
    }

    public PathQuery(String ... pathes) throws InvalidCreateOperationException {
        this.createQueryArray(BuilderToken.QUERY.PATH);
        ArrayNode array = (ArrayNode)this.currentObject;
        for (String elt : pathes) {
            if (elt == null || elt.trim().isEmpty()) continue;
            try {
                GlobalDatas.sanityParameterCheck(elt);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            array.add(elt.trim());
        }
        if (array.size() == 0) {
            throw new InvalidCreateOperationException("No path to add");
        }
        this.currentTokenQUERY = BuilderToken.QUERY.PATH;
        this.setReady(true);
    }

    public final PathQuery add(String ... pathes) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.PATH) {
            throw new InvalidCreateOperationException("Path cannot be added since this is not a path request: " + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        for (String elt : pathes) {
            if (elt == null || elt.trim().isEmpty()) continue;
            try {
                GlobalDatas.sanityParameterCheck(elt);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            array.add(elt.trim());
        }
        return this;
    }
}

