/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class InQuery
extends Query {
    private static final String IS_NOT_AN_IN_QUERY = " is not an In Query";
    private static final String QUERY2 = "Query ";
    private static final String CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME = " cannot be created with empty variable name";
    private static final String CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY = "Cannot add an InValue since this is not an In Query: ";
    protected Set<Boolean> booleanVals;
    protected Set<Long> longVals;
    protected Set<Double> doubleVals;
    protected Set<String> stringVals;

    protected InQuery() {
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, long value) throws InvalidCreateOperationException {
        switch (inQuery) {
            case IN: 
            case NIN: {
                if (variableName == null || variableName.trim().isEmpty()) {
                    throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
                }
                try {
                    GlobalDatas.sanityParameterCheck(variableName);
                }
                catch (InvalidParseOperationException e) {
                    throw new InvalidCreateOperationException(e);
                }
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                array.add(value);
                this.longVals = new HashSet<Long>();
                this.longVals.add(value);
                this.currentObject = array;
                this.currentTokenQUERY = inQuery;
                this.setReady(true);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
            }
        }
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, double value) throws InvalidCreateOperationException {
        switch (inQuery) {
            case IN: 
            case NIN: {
                if (variableName == null || variableName.trim().isEmpty()) {
                    throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
                }
                try {
                    GlobalDatas.sanityParameterCheck(variableName);
                }
                catch (InvalidParseOperationException e) {
                    throw new InvalidCreateOperationException(e);
                }
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                array.add(value);
                this.doubleVals = new HashSet<Double>();
                this.doubleVals.add(value);
                this.currentObject = array;
                this.currentTokenQUERY = inQuery;
                this.setReady(true);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
            }
        }
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, String value) throws InvalidCreateOperationException {
        switch (inQuery) {
            case IN: 
            case NIN: {
                if (variableName == null || variableName.trim().isEmpty()) {
                    throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
                }
                try {
                    GlobalDatas.sanityParameterCheck(variableName);
                    GlobalDatas.sanityValueCheck(value);
                }
                catch (InvalidParseOperationException e) {
                    throw new InvalidCreateOperationException(e);
                }
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                array.add(value);
                this.stringVals = new HashSet<String>();
                this.stringVals.add(value);
                this.currentObject = array;
                this.currentTokenQUERY = inQuery;
                this.setReady(true);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + " is not an In or Search Query");
            }
        }
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, Date value) throws InvalidCreateOperationException {
        switch (inQuery) {
            case IN: 
            case NIN: {
                if (variableName == null || variableName.trim().isEmpty()) {
                    throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
                }
                try {
                    GlobalDatas.sanityParameterCheck(variableName);
                }
                catch (InvalidParseOperationException e) {
                    throw new InvalidCreateOperationException(e);
                }
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                String sdate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)value));
                array.add((JsonNode)GlobalDatas.getDate(value));
                this.stringVals = new HashSet<String>();
                this.stringVals.add(sdate);
                this.currentObject = array;
                this.currentTokenQUERY = inQuery;
                this.setReady(true);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + " is not an In or Search Query");
            }
        }
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, boolean value) throws InvalidCreateOperationException {
        switch (inQuery) {
            case IN: 
            case NIN: {
                if (variableName == null || variableName.trim().isEmpty()) {
                    throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
                }
                try {
                    GlobalDatas.sanityParameterCheck(variableName);
                }
                catch (InvalidParseOperationException e) {
                    throw new InvalidCreateOperationException(e);
                }
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                array.add(value);
                this.booleanVals = new HashSet<Boolean>();
                this.booleanVals.add(value);
                this.currentObject = array;
                this.currentTokenQUERY = inQuery;
                this.setReady(true);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
            }
        }
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, String ... values) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (inQuery) {
            case IN: 
            case NIN: {
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                this.stringVals = new HashSet<String>();
                for (String value : values) {
                    try {
                        GlobalDatas.sanityValueCheck(value);
                    }
                    catch (InvalidParseOperationException e) {
                        throw new InvalidCreateOperationException(e);
                    }
                    if (this.stringVals.contains(value)) continue;
                    array.add(value);
                    this.stringVals.add(value);
                }
                this.currentObject = array;
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
            }
        }
        this.currentTokenQUERY = inQuery;
        this.setReady(true);
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, Date ... values) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + inQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (inQuery) {
            case IN: 
            case NIN: {
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
                ArrayNode array = sub.putArray(variableName.trim());
                this.stringVals = new HashSet<String>();
                for (Date value : values) {
                    String sdate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)value));
                    if (this.stringVals.contains(sdate)) continue;
                    array.add((JsonNode)GlobalDatas.getDate(value));
                    this.stringVals.add(sdate);
                }
                this.currentObject = array;
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
            }
        }
        this.currentTokenQUERY = inQuery;
        this.setReady(true);
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, long ... values) throws InvalidCreateOperationException {
        if (inQuery != BuilderToken.QUERY.IN && inQuery != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
        ArrayNode array = sub.putArray(variableName.trim());
        this.longVals = new HashSet<Long>();
        for (long value : values) {
            if (this.longVals.contains(value)) continue;
            array.add(value);
            this.longVals.add(value);
        }
        this.currentObject = array;
        this.currentTokenQUERY = inQuery;
        this.setReady(true);
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, double ... values) throws InvalidCreateOperationException {
        if (inQuery != BuilderToken.QUERY.IN && inQuery != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
        ArrayNode array = sub.putArray(variableName.trim());
        this.doubleVals = new HashSet<Double>();
        for (double value : values) {
            if (this.doubleVals.contains(value)) continue;
            array.add(value);
            this.doubleVals.add(value);
        }
        this.currentObject = array;
        this.currentTokenQUERY = inQuery;
        this.setReady(true);
    }

    public InQuery(BuilderToken.QUERY inQuery, String variableName, boolean ... values) throws InvalidCreateOperationException {
        if (inQuery != BuilderToken.QUERY.IN && inQuery != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(QUERY2 + inQuery + IS_NOT_AN_IN_QUERY);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(inQuery.exactToken());
        ArrayNode array = sub.putArray(variableName.trim());
        this.booleanVals = new HashSet<Boolean>();
        for (boolean value : values) {
            if (this.booleanVals.contains(value)) continue;
            array.add(value);
            this.booleanVals.add(value);
        }
        this.currentObject = array;
        this.currentTokenQUERY = inQuery;
        this.setReady(true);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.booleanVals != null) {
            this.booleanVals.clear();
        }
        this.booleanVals = null;
        if (this.longVals != null) {
            this.longVals.clear();
        }
        this.longVals = null;
        if (this.doubleVals != null) {
            this.doubleVals.clear();
        }
        this.doubleVals = null;
        if (this.stringVals != null) {
            this.stringVals.clear();
        }
        this.stringVals = null;
    }

    public final InQuery add(String ... inValue) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.IN && this.currentTokenQUERY != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.stringVals == null) {
            this.stringVals = new HashSet<String>();
        }
        for (String val : inValue) {
            try {
                GlobalDatas.sanityValueCheck(val);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            if (this.stringVals.contains(val)) continue;
            array.add(val);
            this.stringVals.add(val);
        }
        return this;
    }

    public final InQuery add(Date ... inValue) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.IN && this.currentTokenQUERY != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.stringVals == null) {
            this.stringVals = new HashSet<String>();
        }
        for (Date val : inValue) {
            String sdate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)val));
            if (this.stringVals.contains(sdate)) continue;
            array.add((JsonNode)GlobalDatas.getDate(val));
            this.stringVals.add(sdate);
        }
        return this;
    }

    public final InQuery add(long ... inValue) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.IN && this.currentTokenQUERY != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.longVals == null) {
            this.longVals = new HashSet<Long>();
        }
        for (long l : inValue) {
            if (this.longVals.contains(l)) continue;
            array.add(l);
            this.longVals.add(l);
        }
        return this;
    }

    public final InQuery add(double ... inValue) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.IN && this.currentTokenQUERY != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.doubleVals == null) {
            this.doubleVals = new HashSet<Double>();
        }
        for (double d : inValue) {
            if (this.doubleVals.contains(d)) continue;
            array.add(d);
            this.doubleVals.add(d);
        }
        return this;
    }

    public final InQuery add(boolean ... inValue) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.IN && this.currentTokenQUERY != BuilderToken.QUERY.NIN) {
            throw new InvalidCreateOperationException(CANNOT_ADD_AN_IN_VALUE_SINCE_THIS_IS_NOT_AN_IN_QUERY + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.booleanVals == null) {
            this.booleanVals = new HashSet<Boolean>();
        }
        for (boolean b : inValue) {
            if (this.booleanVals.contains(b)) continue;
            array.add(b);
            this.booleanVals.add(b);
        }
        return this;
    }
}

