/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.applicativetest;

import fr.gouv.vitam.functionaltest.cucumber.report.VitamReporter;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.runtime.Runtime;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CucumberLauncher {
    private Path tnrReportDirectory;

    public CucumberLauncher(Path tnrReportDirectory) {
        this.tnrReportDirectory = tnrReportDirectory;
    }

    Byte launchCucumberTest(List<String> arguments) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(propertiesFileOptions);
        RuntimeOptions systemOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        CommandlineOptionsParser commandlineOptionsParser = new CommandlineOptionsParser((OutputStream)System.out);
        RuntimeOptions runtimeOptions = commandlineOptionsParser.parse((String[])arguments.toArray(String[]::new)).addDefaultGlueIfAbsent().addDefaultFeaturePathIfAbsent().addDefaultSummaryPrinterIfNotDisabled().enablePublishPlugin().build(systemOptions);
        Optional exitStatus = commandlineOptionsParser.exitStatus();
        if (exitStatus.isPresent()) {
            Byte result = (Byte)exitStatus.get();
            return result;
        }
        Runtime runtime = Runtime.builder().withRuntimeOptions(runtimeOptions).withClassLoader(() -> classLoader).build();
        runtime.run();
        return runtime.exitStatus();
    }

    public List<String> buildCucumberArgument(String glueCode, Path featurePath, String reportName) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-s");
        arguments.add("-g");
        arguments.add(glueCode);
        arguments.add("-p");
        Path reportPath = this.tnrReportDirectory.resolve(reportName);
        arguments.add(VitamReporter.class.getCanonicalName() + ":" + reportPath);
        arguments.add(featurePath.toAbsolutePath().toString());
        return arguments;
    }
}

