/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.common.client.FunctionAdministrationOntologyLoader;
import fr.gouv.vitam.ihmdemo.common.pagination.PaginationHelper;
import fr.gouv.vitam.ihmdemo.core.DslQueryHelper;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import fr.gouv.vitam.ihmrecette.appserver.StorageService;
import fr.gouv.vitam.ihmrecette.appserver.WebApplicationConfig;
import fr.gouv.vitam.ihmrecette.appserver.WebApplicationResource;
import fr.gouv.vitam.ihmrecette.appserver.WebApplicationResourceDelete;
import fr.gouv.vitam.ihmrecette.appserver.applicativetest.ApplicativeTestResource;
import fr.gouv.vitam.ihmrecette.appserver.applicativetest.ApplicativeTestService;
import fr.gouv.vitam.ihmrecette.appserver.performance.PerformanceResource;
import fr.gouv.vitam.ihmrecette.appserver.performance.PerformanceService;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private static final String STORAGE_CONF_FILE = "storage.conf";
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            StorageService storageService;
            WebApplicationConfig configuration = (WebApplicationConfig)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, WebApplicationConfig.class));
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            Path sipDirectory = Paths.get(configuration.getSipDirectory(), new String[0]);
            Path reportDirectory = Paths.get(configuration.getPerformanceReportDirectory(), new String[0]);
            if (!sipDirectory.toFile().exists()) {
                throw new FileNotFoundException(String.format("directory %s does not exist", sipDirectory));
            }
            if (!reportDirectory.toFile().exists()) {
                throw new FileNotFoundException(String.format("directory %s does not exist", reportDirectory));
            }
            PerformanceService performanceService = new PerformanceService(sipDirectory, reportDirectory);
            this.singletons.add(new PerformanceResource(performanceService));
            String testSystemSipDirectory = configuration.getTestSystemSipDirectory();
            String testSystemReportDirectory = configuration.getTestSystemReportDirectory();
            ApplicativeTestService applicativeTestService = new ApplicativeTestService(Paths.get(testSystemReportDirectory, new String[0]));
            this.singletons.add(new ApplicativeTestResource(applicativeTestService, testSystemSipDirectory));
            try (InputStream storageYamlIS = PropertiesUtils.getConfigAsStream((String)STORAGE_CONF_FILE);){
                StorageConfiguration storageConfiguration = (StorageConfiguration)PropertiesUtils.readYaml((InputStream)storageYamlIS, StorageConfiguration.class);
                storageService = new StorageService(storageConfiguration);
            }
            CachedOntologyLoader ontologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new FunctionAdministrationOntologyLoader());
            WebApplicationResourceDelete deleteResource = new WebApplicationResourceDelete(configuration, (OntologyLoader)ontologyLoader, configuration.getFunctionalAdminIndexationConfiguration(), configuration.getMetadataIndexationConfiguration(), configuration.getLogbookIndexationConfiguration());
            WebApplicationResource resource = new WebApplicationResource(configuration, UserInterfaceTransactionManager.getInstance(), PaginationHelper.getInstance(), DslQueryHelper.getInstance(), storageService);
            this.singletons.add(deleteResource);
            this.singletons.add((Object)resource);
        }
        catch (IOException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

