/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.lifecycles.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.server.LogbookDbAccess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycle;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroupInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnitInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.request.LogbookVarNameAdapter;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.lifecycles.api.LogbookLifeCycles;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class LogbookLifeCyclesImpl
implements LogbookLifeCycles {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookLifeCyclesImpl.class);
    private final LogbookDbAccess mongoDbAccess;

    public LogbookLifeCyclesImpl(LogbookDbAccess mongoDbAccess) {
        this.mongoDbAccess = mongoDbAccess;
    }

    @Override
    public void createUnit(String idOperation, String idLc, LogbookLifeCycleUnitParameters parameters) throws LogbookAlreadyExistsException, LogbookDatabaseException, IllegalArgumentException {
        this.checkLifeCyclesUnitArgument(idOperation, idLc, parameters);
        this.mongoDbAccess.createLogbookLifeCycleUnit(idOperation, new LogbookLifeCycleUnitParameters[]{parameters});
    }

    @Override
    public void createObjectGroup(String idOperation, String idLc, LogbookLifeCycleObjectGroupParameters parameters) throws LogbookAlreadyExistsException, LogbookDatabaseException, IllegalArgumentException {
        this.checkLifeCyclesObjectGroupArgument(idOperation, idLc, parameters);
        this.mongoDbAccess.createLogbookLifeCycleObjectGroup(idOperation, new LogbookLifeCycleObjectGroupParameters[]{parameters});
    }

    @Override
    public void updateUnit(String idOperation, String idLc, LogbookLifeCycleUnitParameters parameters) throws LogbookDatabaseException, IllegalArgumentException, LogbookNotFoundException, LogbookAlreadyExistsException {
        this.checkLifeCyclesUnitArgument(idOperation, idLc, parameters);
        this.updateUnit(idOperation, idLc, parameters, false);
    }

    @Override
    public void updateUnit(String idOperation, String idLc, LogbookLifeCycleUnitParameters parameters, boolean commit) throws LogbookNotFoundException, LogbookDatabaseException, LogbookAlreadyExistsException {
        this.checkLifeCyclesUnitArgument(idOperation, idLc, parameters);
        this.mongoDbAccess.updateLogbookLifeCycleUnit(idOperation, idLc, parameters, commit);
    }

    @Override
    public void updateObjectGroup(String idOperation, String idLc, LogbookLifeCycleObjectGroupParameters parameters) throws LogbookNotFoundException, LogbookDatabaseException, IllegalArgumentException, LogbookAlreadyExistsException {
        this.checkLifeCyclesObjectGroupArgument(idOperation, idLc, parameters);
        this.mongoDbAccess.updateLogbookLifeCycleObjectGroup(idOperation, idLc, parameters);
    }

    @Override
    public void updateObjectGroup(String idOperation, String idLc, LogbookLifeCycleObjectGroupParameters parameters, boolean commit) throws LogbookNotFoundException, LogbookDatabaseException, IllegalArgumentException, LogbookAlreadyExistsException {
        this.checkLifeCyclesObjectGroupArgument(idOperation, idLc, parameters);
        this.mongoDbAccess.updateLogbookLifeCycleObjectGroup(idOperation, idLc, parameters, commit);
    }

    @Override
    public LogbookLifeCycle<?> selectLifeCycleById(String lifecycleId, JsonNode queryDsl, boolean sliced, LogbookCollections collection) throws LogbookDatabaseException, LogbookNotFoundException, InvalidParseOperationException, VitamDBException, InvalidCreateOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new LogbookVarNameAdapter());
        if (queryDsl != null) {
            parser.parse(queryDsl);
        }
        Select select = parser.getRequest();
        select.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.id(), (String)lifecycleId));
        return this.mongoDbAccess.getOneLogbookLifeCycle((JsonNode)select.getFinalSelect(), sliced, collection);
    }

    @Override
    public List<LogbookLifeCycle<?>> selectLifeCycles(JsonNode select, boolean sliced, LogbookCollections collection) throws LogbookDatabaseException, LogbookNotFoundException, VitamDBException {
        ArrayList result = new ArrayList();
        try (MongoCursor logbook = this.mongoDbAccess.getLogbookLifeCycles(select, sliced, collection);){
            if (!logbook.hasNext()) {
                throw new LogbookNotFoundException("Logbook entry not found");
            }
            while (logbook.hasNext()) {
                result.add((LogbookLifeCycle)logbook.next());
            }
        }
        return result;
    }

    @Override
    public void rollbackUnit(String idOperation, String idLc) throws LogbookNotFoundException, LogbookDatabaseException, IllegalArgumentException {
        if (VitamConfiguration.isPurgeTemporaryLFC()) {
            this.mongoDbAccess.rollbackLogbookLifeCycleUnit(idOperation, idLc);
        }
    }

    @Override
    public void rollbackObjectGroup(String idOperation, String idLc) throws LogbookNotFoundException, LogbookDatabaseException, IllegalArgumentException {
        if (VitamConfiguration.isPurgeTemporaryLFC()) {
            this.mongoDbAccess.rollbackLogbookLifeCycleObjectGroup(idOperation, idLc);
        }
    }

    private void checkLifeCyclesUnitArgument(String idOperation, String idLcUnit, LogbookLifeCycleUnitParameters parameters) throws IllegalArgumentException {
        ParametersChecker.checkParameter((String)"idOperation or idLifeCycle should not be null or empty", (String[])new String[]{idOperation, idLcUnit});
        if (!parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(idOperation)) {
            LOGGER.error("incoherence entry for idOperation");
            throw new IllegalArgumentException("incoherence entry for idOperation");
        }
        if (!parameters.getParameterValue(LogbookParameterName.objectIdentifier).equals(idLcUnit)) {
            LOGGER.error("incoherence entry for idLifeCycles");
            throw new IllegalArgumentException("incoherence entry for idLifeCycles");
        }
    }

    private void checkLifeCyclesObjectGroupArgument(String idOperation, String idLcObjectGroup, LogbookLifeCycleObjectGroupParameters parameters) throws IllegalArgumentException {
        ParametersChecker.checkParameter((String)"idOperation or idLifeCycleObjectGroup should not be null or empty", (String[])new String[]{idOperation, idLcObjectGroup});
        if (!parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(idOperation)) {
            LOGGER.error("incoherence entry for idOperation");
            throw new IllegalArgumentException("incoherence entry for idOperation");
        }
        if (!idLcObjectGroup.equals(parameters.getParameterValue(LogbookParameterName.objectIdentifier)) && !idLcObjectGroup.equals(parameters.getParameterValue(LogbookParameterName.lifeCycleIdentifier))) {
            LOGGER.error("incoherence entry for idLifeCyclesObjectGroup");
            throw new IllegalArgumentException("incoherence entry for idLifeCyclesObjectGroup");
        }
    }

    @Override
    public void createBulkLogbookLifecycle(String operationId, LogbookLifeCycleParameters[] lifecycleArray) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        ParametersChecker.checkParameter((String)"operationId should not be null or empty", (String[])new String[]{operationId});
        if (lifecycleArray == null || lifecycleArray.length == 0) {
            throw new IllegalArgumentException("No LifeCycle Logbook");
        }
        for (LogbookLifeCycleParameters logbookLifeCycleParameters : lifecycleArray) {
            if (logbookLifeCycleParameters.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(operationId)) continue;
            LOGGER.error("incoherence entry for operationId");
            throw new IllegalArgumentException("incoherence entry for operationId");
        }
        String objectIdentifier = lifecycleArray[0].getParameterValue(LogbookParameterName.objectIdentifier);
        for (LogbookLifeCycleParameters logbookLifeCycleParameters : lifecycleArray) {
            if (logbookLifeCycleParameters.getParameterValue(LogbookParameterName.objectIdentifier).equals(objectIdentifier)) continue;
            LOGGER.error("incoherence entry for objectIdentifier");
            throw new IllegalArgumentException("incoherence entry for objectIdentifier");
        }
        if (lifecycleArray instanceof LogbookLifeCycleUnitParameters[]) {
            this.mongoDbAccess.createLogbookLifeCycleUnit(operationId, (LogbookLifeCycleUnitParameters[])lifecycleArray);
        } else {
            this.mongoDbAccess.createLogbookLifeCycleObjectGroup(operationId, (LogbookLifeCycleObjectGroupParameters[])lifecycleArray);
        }
    }

    @Override
    public void updateBulkLogbookLifecycle(String operationId, LogbookLifeCycleParameters[] lifecycleArray) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        ParametersChecker.checkParameter((String)"idOperation should not be null or empty", (String[])new String[]{operationId});
        if (lifecycleArray == null || lifecycleArray.length == 0) {
            throw new IllegalArgumentException("No LifeCycle Logbook");
        }
        for (LogbookLifeCycleParameters logbookLifeCycleParameters : lifecycleArray) {
            if (logbookLifeCycleParameters.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(operationId)) continue;
            LOGGER.error("incoherence entry for operationId");
            throw new IllegalArgumentException("incoherence entry for operationId");
        }
        if (lifecycleArray instanceof LogbookLifeCycleUnitParameters[]) {
            this.mongoDbAccess.updateLogbookLifeCycleUnit((LogbookLifeCycleUnitParameters[])lifecycleArray);
        } else {
            this.mongoDbAccess.updateLogbookLifeCycleObjectGroup((LogbookLifeCycleObjectGroupParameters[])lifecycleArray);
        }
    }

    @Override
    public void commitUnit(String idOperation, String idLc) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        LogbookLifeCycleUnitInProcess logbookLifeCycleUnitInProcess = this.mongoDbAccess.getLogbookLifeCycleUnitInProcess(idLc);
        if (logbookLifeCycleUnitInProcess == null) {
            LOGGER.error("The temporary lifeCycle wasn't found");
            throw new LogbookNotFoundException("The temporary lifeCycle wasn't found");
        }
        boolean isLifeCycleExist = this.mongoDbAccess.existsLogbookLifeCycleUnit(idLc);
        if (!isLifeCycleExist) {
            this.mongoDbAccess.createLogbookLifeCycleUnit(logbookLifeCycleUnitInProcess);
        } else {
            this.mongoDbAccess.updateLogbookLifeCycleUnit(logbookLifeCycleUnitInProcess);
        }
    }

    @Override
    public void commitObjectGroup(String idOperation, String idLc) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        LogbookLifeCycleObjectGroupInProcess logbookLifeCycleObjectGroupInProcess = this.mongoDbAccess.getLogbookLifeCycleObjectGroupInProcess(idLc);
        if (logbookLifeCycleObjectGroupInProcess == null) {
            LOGGER.error("The temporary lifeCycle wasn't found");
            throw new LogbookNotFoundException("The temporary lifeCycle wasn't found");
        }
        boolean isLifeCycleExist = this.mongoDbAccess.existsLogbookLifeCycleObjectGroup(idLc);
        if (!isLifeCycleExist) {
            this.mongoDbAccess.createLogbookLifeCycleObjectGroup(logbookLifeCycleObjectGroupInProcess);
        } else {
            this.mongoDbAccess.updateLogbookLifeCycleObjectGroup(logbookLifeCycleObjectGroupInProcess);
        }
    }

    @Override
    public void rollBackUnitsByOperation(String idOperation) throws LogbookNotFoundException, LogbookDatabaseException {
        if (VitamConfiguration.isPurgeTemporaryLFC()) {
            this.mongoDbAccess.rollBackUnitLifeCyclesByOperation(idOperation);
        }
    }

    @Override
    public void rollBackObjectGroupsByOperation(String idOperation) throws LogbookNotFoundException, LogbookDatabaseException {
        if (VitamConfiguration.isPurgeTemporaryLFC()) {
            this.mongoDbAccess.rollBackObjectGroupLifeCyclesByOperation(idOperation);
        }
    }

    @Override
    public LifeCycleStatusCode getUnitLifeCycleStatus(String unitId) throws LogbookDatabaseException, LogbookNotFoundException {
        boolean isInProcessLfc = this.mongoDbAccess.existsLogbookLifeCycleUnitInProcess(unitId);
        if (isInProcessLfc) {
            return LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS;
        }
        boolean isCommittedLfc = this.mongoDbAccess.existsLogbookLifeCycleUnit(unitId);
        if (isCommittedLfc) {
            return LifeCycleStatusCode.LIFE_CYCLE_COMMITTED;
        }
        return null;
    }

    @Override
    public LifeCycleStatusCode getObjectGroupLifeCycleStatus(String objectGroupId) throws LogbookDatabaseException, LogbookNotFoundException {
        boolean isInProcessLfc = this.mongoDbAccess.existsLogbookLifeCycleObjectGroupInProcess(objectGroupId);
        if (isInProcessLfc) {
            return LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS;
        }
        boolean isCommittedLfc = this.mongoDbAccess.existsLogbookLifeCycleObjectGroup(objectGroupId);
        if (isCommittedLfc) {
            return LifeCycleStatusCode.LIFE_CYCLE_COMMITTED;
        }
        return null;
    }

    @Override
    public void bulk(LogbookCollections collections, String idOp, List<? extends LogbookLifeCycleModel> logbookLifeCycleModels) throws DatabaseException {
        this.mongoDbAccess.bulkInsert(idOp, collections, logbookLifeCycleModels);
    }

    @Override
    public CloseableIterator<JsonNode> getRawUnitLifecyclesByLastPersistedDate(String startDate, String endDate, int limit) {
        return this.getRawLifecyclesByLastPersistedDate(LogbookCollections.LIFECYCLE_UNIT, startDate, endDate, limit);
    }

    @Override
    public CloseableIterator<JsonNode> getRawObjectGroupLifecyclesByLastPersistedDate(String startDate, String endDate, int limit) {
        return this.getRawLifecyclesByLastPersistedDate(LogbookCollections.LIFECYCLE_OBJECTGROUP, startDate, endDate, limit);
    }

    private CloseableIterator<JsonNode> getRawLifecyclesByLastPersistedDate(LogbookCollections collection, String startDate, String endDate, int limit) {
        VitamMongoRepository vitamMongoRepository = new VitamMongoRepository(collection.getCollection());
        final MongoCursor lifecycleIterator = vitamMongoRepository.findDocuments(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId()), Filters.gte((String)"_lastPersistedDate", (Object)startDate), Filters.lte((String)"_lastPersistedDate", (Object)endDate)}), VitamConfiguration.getBatchSize()).sort(Sorts.ascending((String[])new String[]{"_lastPersistedDate"})).limit(limit).iterator();
        return new CloseableIterator<JsonNode>(){

            public boolean hasNext() {
                return lifecycleIterator.hasNext();
            }

            public JsonNode next() {
                try {
                    return BsonHelper.fromDocumentToJsonNode((Document)((Document)lifecycleIterator.next()));
                }
                catch (InvalidParseOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            public void close() {
                lifecycleIterator.close();
            }
        };
    }

    @Override
    public boolean checkUnitLifecycleEntriesExistenceByLastPersistedDate(String startDate, String endDate) {
        return this.checkNewLifecycleEntriesByLastPersistedDate(LogbookCollections.LIFECYCLE_UNIT, startDate, endDate);
    }

    @Override
    public boolean checkObjectGroupLifecycleEntriesExistenceByLastPersistedDate(String startDate, String endDate) {
        return this.checkNewLifecycleEntriesByLastPersistedDate(LogbookCollections.LIFECYCLE_OBJECTGROUP, startDate, endDate);
    }

    private boolean checkNewLifecycleEntriesByLastPersistedDate(LogbookCollections collection, String startDate, String endDate) {
        VitamMongoRepository vitamMongoRepository = new VitamMongoRepository(collection.getCollection());
        Document firstLifecycle = (Document)vitamMongoRepository.findDocuments(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId()), Filters.gt((String)"_lastPersistedDate", (Object)startDate), Filters.lte((String)"_lastPersistedDate", (Object)endDate)}), VitamConfiguration.getBatchSize()).projection(Projections.include((String[])new String[]{"_id"})).limit(1).first();
        return firstLifecycle != null;
    }

    @Override
    public JsonNode getRawUnitLifeCycleById(String id) throws LogbookNotFoundException, InvalidParseOperationException {
        return this.getRawLifecycleById(id, LogbookCollections.LIFECYCLE_UNIT);
    }

    @Override
    public List<JsonNode> getRawUnitLifeCycleByIds(List<String> ids) throws LogbookNotFoundException, InvalidParseOperationException {
        return this.getRawLifecycleByIds(ids, LogbookCollections.LIFECYCLE_UNIT);
    }

    @Override
    public JsonNode getRawObjectGroupLifeCycleById(String id) throws LogbookNotFoundException, InvalidParseOperationException {
        return this.getRawLifecycleById(id, LogbookCollections.LIFECYCLE_OBJECTGROUP);
    }

    @Override
    public List<JsonNode> getRawObjectGroupLifeCycleByIds(List<String> ids) throws LogbookNotFoundException, InvalidParseOperationException {
        return this.getRawLifecycleByIds(ids, LogbookCollections.LIFECYCLE_OBJECTGROUP);
    }

    @Override
    public void updateLogbookLifeCycleBulk(LogbookCollections logbookCollections, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        this.mongoDbAccess.updateLogbookLifeCycleBulk(logbookCollections, logbookLifeCycleParametersBulk);
    }

    @Override
    public void deleteLifeCycleObjectGroups(List<String> objectGroupIds) throws DatabaseException {
        VitamMongoRepository repo = VitamRepositoryFactory.get().getVitamMongoRepository(LogbookCollections.LIFECYCLE_OBJECTGROUP.getVitamCollection());
        repo.remove(Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", objectGroupIds), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())}));
    }

    @Override
    public void deleteLifeCycleUnits(List<String> unitsIdentifier) throws DatabaseException {
        VitamMongoRepository repo = VitamRepositoryFactory.get().getVitamMongoRepository(LogbookCollections.LIFECYCLE_UNIT.getVitamCollection());
        repo.remove(Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", unitsIdentifier), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())}));
    }

    private JsonNode getRawLifecycleById(String id, LogbookCollections collection) throws InvalidParseOperationException, LogbookNotFoundException {
        VitamMongoRepository vitamMongoRepository = new VitamMongoRepository(collection.getCollection());
        Document document = (Document)vitamMongoRepository.findDocuments(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)id), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())}), 1).first();
        if (document == null) {
            throw new LogbookNotFoundException("Could not find raw lifecycle by id " + id);
        }
        return BsonHelper.fromDocumentToJsonNode((Document)document);
    }

    private List<JsonNode> getRawLifecycleByIds(List<String> ids, LogbookCollections collection) throws InvalidParseOperationException, LogbookNotFoundException {
        VitamMongoRepository vitamMongoRepository = new VitamMongoRepository(collection.getCollection());
        try (MongoCursor documents = vitamMongoRepository.findDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", ids), Filters.eq((String)"_tenant", (Object)VitamThreadUtils.getVitamSession().getTenantId())}), ids.size()).iterator();){
            ArrayList<JsonNode> results = new ArrayList<JsonNode>();
            while (documents.hasNext()) {
                results.add(BsonHelper.fromDocumentToJsonNode((Document)((Document)documents.next())));
            }
            if (results.size() < ids.size()) {
                throw new LogbookNotFoundException("Could not find raw lifecycle by ids " + ids);
            }
            ArrayList<JsonNode> arrayList = results;
            return arrayList;
        }
    }
}

