/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.lifecycles.api;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycle;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import java.util.List;

public interface LogbookLifeCycles {
    public void createUnit(String var1, String var2, LogbookLifeCycleUnitParameters var3) throws LogbookAlreadyExistsException, LogbookDatabaseException;

    public void createObjectGroup(String var1, String var2, LogbookLifeCycleObjectGroupParameters var3) throws LogbookAlreadyExistsException, LogbookDatabaseException;

    public void updateUnit(String var1, String var2, LogbookLifeCycleUnitParameters var3) throws LogbookNotFoundException, LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateUnit(String var1, String var2, LogbookLifeCycleUnitParameters var3, boolean var4) throws LogbookNotFoundException, LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateObjectGroup(String var1, String var2, LogbookLifeCycleObjectGroupParameters var3) throws LogbookNotFoundException, LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateObjectGroup(String var1, String var2, LogbookLifeCycleObjectGroupParameters var3, boolean var4) throws LogbookNotFoundException, LogbookDatabaseException, LogbookAlreadyExistsException;

    public List<LogbookLifeCycle<?>> selectLifeCycles(JsonNode var1, boolean var2, LogbookCollections var3) throws LogbookDatabaseException, LogbookNotFoundException, InvalidParseOperationException, VitamDBException;

    public LogbookLifeCycle<?> selectLifeCycleById(String var1, JsonNode var2, boolean var3, LogbookCollections var4) throws LogbookDatabaseException, LogbookNotFoundException, InvalidParseOperationException, VitamDBException, InvalidCreateOperationException;

    public void rollbackUnit(String var1, String var2) throws LogbookNotFoundException, LogbookDatabaseException;

    public void rollbackObjectGroup(String var1, String var2) throws LogbookNotFoundException, LogbookDatabaseException;

    public void createBulkLogbookLifecycle(String var1, LogbookLifeCycleParameters[] var2) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateBulkLogbookLifecycle(String var1, LogbookLifeCycleParameters[] var2) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void commitUnit(String var1, String var2) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void commitObjectGroup(String var1, String var2) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void rollBackUnitsByOperation(String var1) throws LogbookNotFoundException, LogbookDatabaseException;

    public void rollBackObjectGroupsByOperation(String var1) throws LogbookNotFoundException, LogbookDatabaseException;

    public LifeCycleStatusCode getUnitLifeCycleStatus(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public LifeCycleStatusCode getObjectGroupLifeCycleStatus(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public void bulk(LogbookCollections var1, String var2, List<? extends LogbookLifeCycleModel> var3) throws DatabaseException;

    public CloseableIterator<JsonNode> getRawUnitLifecyclesByLastPersistedDate(String var1, String var2, int var3);

    public CloseableIterator<JsonNode> getRawObjectGroupLifecyclesByLastPersistedDate(String var1, String var2, int var3);

    public boolean checkUnitLifecycleEntriesExistenceByLastPersistedDate(String var1, String var2);

    public boolean checkObjectGroupLifecycleEntriesExistenceByLastPersistedDate(String var1, String var2);

    public JsonNode getRawUnitLifeCycleById(String var1) throws LogbookNotFoundException, InvalidParseOperationException;

    public List<JsonNode> getRawUnitLifeCycleByIds(List<String> var1) throws LogbookNotFoundException, InvalidParseOperationException;

    public JsonNode getRawObjectGroupLifeCycleById(String var1) throws LogbookNotFoundException, InvalidParseOperationException;

    public List<JsonNode> getRawObjectGroupLifeCycleByIds(List<String> var1) throws LogbookNotFoundException, InvalidParseOperationException;

    public void updateLogbookLifeCycleBulk(LogbookCollections var1, List<LogbookLifeCycleParametersBulk> var2);

    public void deleteLifeCycleObjectGroups(List<String> var1) throws DatabaseException;

    public void deleteLifeCycleUnits(List<String> var1) throws DatabaseException;
}

