/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.worker.tasks;

import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.retryable.DelegateRetryVoid;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalogLabel;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryOnTapeArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeState;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteErrorCode;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteException;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.metrics.ReadWriteOrderMetrics;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryService;
import fr.gouv.vitam.storage.offers.tape.worker.tasks.ReadWriteResult;
import io.prometheus.client.Histogram;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.bson.conversions.Bson;

public class WriteTask
implements Future<ReadWriteResult> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WriteTask.class);
    public static final String TAPE_MSG = " [Tape] : ";
    public static final String TAPE_LABEL = "tape-Label-";
    public static final int SLEEP_TIME = 20;
    public static final int CARTRIDGE_RETRY = 1;
    private static final int NB_RETRY = 3;
    private static final int RANDOM_RANGE_SLEEP = 5;
    public final String MSG_PREFIX;
    private final String inputTarPath;
    protected boolean cancelled = false;
    protected boolean done = false;
    private TapeCatalog workerCurrentTape;
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final TapeLibraryService tapeLibraryService;
    private final TapeCatalogService tapeCatalogService;
    private final ArchiveCacheStorage archiveCacheStorage;
    private final WriteOrder writeOrder;
    private int cartridgeRetry = 1;
    private final boolean forceOverrideNonEmptyCartridges;

    public WriteTask(WriteOrder writeOrder, TapeCatalog workerCurrentTape, TapeLibraryService tapeLibraryService, TapeCatalogService tapeCatalogService, ArchiveReferentialRepository archiveReferentialRepository, ArchiveCacheStorage archiveCacheStorage, String inputTarPath, boolean forceOverrideNonEmptyCartridges) {
        ParametersChecker.checkParameter((String)"WriteOrder param is required.", (Object[])new Object[]{writeOrder});
        ParametersChecker.checkParameter((String)"TapeLibraryService param is required.", (Object[])new Object[]{tapeLibraryService});
        ParametersChecker.checkParameter((String)"TapeCatalogService param is required.", (Object[])new Object[]{tapeCatalogService});
        ParametersChecker.checkParameter((String)"ArchiveReferentialRepository param is required.", (Object[])new Object[]{archiveReferentialRepository});
        ParametersChecker.checkParameter((String)"ArchiveCacheStorage param is required.", (Object[])new Object[]{archiveCacheStorage});
        ParametersChecker.checkParameter((String)"InputTarPath param is required.", (String[])new String[]{inputTarPath});
        this.writeOrder = writeOrder;
        this.workerCurrentTape = workerCurrentTape;
        this.tapeLibraryService = tapeLibraryService;
        this.tapeCatalogService = tapeCatalogService;
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.archiveCacheStorage = archiveCacheStorage;
        this.inputTarPath = inputTarPath;
        this.MSG_PREFIX = String.format("[Library] : %s, [Drive] : %s, ", tapeLibraryService.getLibraryIdentifier(), tapeLibraryService.getDriveIndex());
        this.forceOverrideNonEmptyCartridges = forceOverrideNonEmptyCartridges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ReadWriteResult get() {
        this.reportWaitTime();
        executionTimer = ((Histogram.Child)ReadWriteOrderMetrics.WRITE_ORDER_EXECUTION_DURATION.labels(new String[]{this.writeOrder.getBucket()})).startTimer();
        readWriteResult = new ReadWriteResult();
        try {
            file = this.getWriteOrderFile();
            if (null != this.workerCurrentTape) {
                if (this.canWriteOnTape()) {
                    this.doWrite(file);
                } else {
                    this.unloadThenLoadTapeAndWrite(file);
                }
            } else {
                this.loadTapeAndWrite(file);
            }
            this.retryable().execute((DelegateRetryVoid)LambdaMetafactory.metafactory(null, null, null, ()V, updateTarReferential(), ()V)((WriteTask)this));
            if (this.writeOrder.getMessageType() == QueueMessageType.WriteBackupOrder) {
                WriteTask.LOGGER.warn("Backup archive '" + this.writeOrder.getArchiveId() + " archived to a backup tape with code '" + this.workerCurrentTape.getCode() + "'");
                if (!file.delete()) {
                    throw new ReadWriteException("Could not delete backup archive " + this.writeOrder.getArchiveId() + " (" + file + ")", ReadWriteErrorCode.KO_ON_DELETE_ARCHIVED_BACKUP);
                }
            } else {
                this.moveArchiveToCache(file);
            }
            readWriteResult.setStatus(StatusCode.OK);
            readWriteResult.setOrderState(QueueState.COMPLETED);
        }
        catch (ReadWriteException e) {
            WriteTask.LOGGER.error("Write task failed", (Throwable)e);
            readWriteResult.setCode(e.getReadWriteErrorCode());
            switch (1.$SwitchMap$fr$gouv$vitam$storage$offers$tape$exception$ReadWriteErrorCode[e.getReadWriteErrorCode().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    this.workerCurrentTape.setTapeState(TapeState.CONFLICT);
                    WriteTask.LOGGER.warn(this.MSG_PREFIX + " [Tape] : " + this.workerCurrentTape.getCode() + " is marked as conflict (incident close tape)");
                    try {
                        this.retryable().execute((DelegateRetryVoid)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$get$0(), ()V)((WriteTask)this));
                    }
                    catch (ReadWriteException ex) {
                        WriteTask.LOGGER.error((Throwable)ex);
                    }
                    readWriteResult.setStatus(StatusCode.FATAL);
                    readWriteResult.setOrderState(QueueState.READY);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 4: {
                    if (--this.cartridgeRetry >= 0) {
                        this.workerCurrentTape.setTapeState(TapeState.CONFLICT);
                        WriteTask.LOGGER.warn(this.MSG_PREFIX + " [Tape] : " + this.workerCurrentTape.getCode() + " is marked as conflict (incident close tape)");
                        var4_6 = this.get();
                        return var4_6;
                    }
                    readWriteResult.setStatus(StatusCode.FATAL);
                    readWriteResult.setOrderState(QueueState.READY);
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.workerCurrentTape.setTapeState(TapeState.FULL);
                    var4_7 = this.get();
                    return var4_7;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    readWriteResult.setStatus(StatusCode.FATAL);
                    readWriteResult.setOrderState(QueueState.READY);
                    ** break;
lbl60:
                    // 1 sources

                    break;
                }
                default: {
                    readWriteResult.setStatus(StatusCode.FATAL);
                    readWriteResult.setOrderState(QueueState.ERROR);
                    break;
                }
            }
        }
        finally {
            executionTimer.observeDuration();
        }
        readWriteResult.setCurrentTape(this.workerCurrentTape);
        return readWriteResult;
    }

    private void moveArchiveToCache(File archiveFile) throws ReadWriteException {
        try {
            this.archiveCacheStorage.reserveArchiveStorageSpace(this.writeOrder.getFileBucketId(), this.writeOrder.getArchiveId(), this.writeOrder.getSize());
            try {
                this.archiveCacheStorage.moveArchiveToCache(archiveFile.toPath(), this.writeOrder.getFileBucketId(), this.writeOrder.getArchiveId());
            }
            catch (Exception e) {
                this.archiveCacheStorage.cancelReservedArchive(this.writeOrder.getFileBucketId(), this.writeOrder.getArchiveId());
                throw e;
            }
        }
        catch (IllegalPathException | IOException | IllegalStateException e) {
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + ", Error: while moving archive file '" + archiveFile + "' to archive cache", e, ReadWriteErrorCode.KO_ON_MOVE_TO_CACHE);
        }
    }

    private void updateTarReferential() throws ReadWriteException {
        try {
            TapeLibraryOnTapeArchiveStorageLocation onTapeTarStorageLocation = new TapeLibraryOnTapeArchiveStorageLocation(this.workerCurrentTape.getCode(), Integer.valueOf(this.workerCurrentTape.getFileCount() - 1));
            this.archiveReferentialRepository.updateLocationToOnTape(this.writeOrder.getArchiveId(), onTapeTarStorageLocation);
        }
        catch (ArchiveReferentialException e) {
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + ", Error: while update archive referential", e, ReadWriteErrorCode.KO_DB_PERSIST);
        }
    }

    private void unloadThenLoadTapeAndWrite(File file) throws ReadWriteException {
        this.tapeLibraryService.unloadTape(this.workerCurrentTape);
        this.retryable().execute(this::tapeBackToCatalog);
        this.loadTapeAndWrite(file);
    }

    private void loadTapeAndWrite(File file) throws ReadWriteException {
        this.tryFindTapeCatalogAndLoadIntoDrive();
        this.doWrite(file);
    }

    private File getWriteOrderFile() throws ReadWriteException {
        File file = new File(this.inputTarPath, this.writeOrder.getFilePath());
        if (!file.exists() || !file.isFile()) {
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + (this.workerCurrentTape == null ? "null" : this.workerCurrentTape.getCode()) + " Action : Write, Order: " + JsonHandler.unprettyPrint((Object)this.writeOrder) + ", Error: File not found", ReadWriteErrorCode.FILE_NOT_FOUND);
        }
        return file;
    }

    private void tryFindTapeCatalogAndLoadIntoDrive() throws ReadWriteException {
        this.workerCurrentTape = this.loadTapeFromCatalog();
        LOGGER.debug(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + ", Action: load tape");
        this.tapeLibraryService.loadTape(this.workerCurrentTape);
        this.retryable().execute(() -> this.doUpdateTapeCatalog(this.workerCurrentTape));
        this.doCheckTapeLabel();
    }

    private TapeCatalog loadTapeFromCatalog() throws ReadWriteException {
        String bucket = this.writeOrder.getBucket();
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"library", (Object)this.tapeLibraryService.getLibraryIdentifier()), Filters.eq((String)"tape_state", (Object)TapeState.OPEN.name()), Filters.eq((String)"bucket", (Object)bucket)});
        try {
            Optional<TapeCatalog> found = this.tapeCatalogService.receive(query);
            if (found.isPresent()) {
                return found.get();
            }
            query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"library", (Object)this.tapeLibraryService.getLibraryIdentifier()), Filters.eq((String)"tape_state", (Object)TapeState.EMPTY.name()), Filters.or((Bson[])new Bson[]{Filters.eq((String)"bucket", (Object)bucket), Filters.exists((String)"bucket", (boolean)false)})});
            found = this.tapeCatalogService.receive(query);
            if (found.isPresent()) {
                return found.get();
            }
            throw new ReadWriteException(this.MSG_PREFIX + " Action : Load Tape From Catalog, Order: " + JsonHandler.unprettyPrint((Object)this.writeOrder) + ", Error: no markReady tape found in the catalog with expected bucket and/or remainingSize", ReadWriteErrorCode.TAPE_NOT_FOUND_IN_CATALOG);
        }
        catch (QueueException e) {
            throw new ReadWriteException(this.MSG_PREFIX, e);
        }
    }

    private void doCheckTapeLabel() throws ReadWriteException {
        if (null == this.workerCurrentTape.getLabel()) {
            this.tapeLibraryService.ensureTapeIsEmpty(this.workerCurrentTape, this.forceOverrideNonEmptyCartridges);
            this.workerCurrentTape.setBucket(this.writeOrder.getBucket());
            this.retryable().execute(() -> this.doUpdateTapeCatalog(this.workerCurrentTape));
        } else {
            this.tapeLibraryService.checkNonEmptyTapeLabel(this.workerCurrentTape);
        }
    }

    private boolean canWriteOnTape() {
        if (null == this.workerCurrentTape) {
            return false;
        }
        return TapeState.EMPTY.equals((Object)this.workerCurrentTape.getTapeState()) || Objects.equals(this.workerCurrentTape.getBucket(), this.writeOrder.getBucket()) && TapeState.OPEN.equals((Object)this.workerCurrentTape.getTapeState());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryWriteLabelToTape() throws ReadWriteException {
        this.workerCurrentTape.setBucket(this.writeOrder.getBucket());
        TapeCatalogLabel objLabel = new TapeCatalogLabel();
        objLabel.setId(this.workerCurrentTape.getId());
        objLabel.setCode(this.workerCurrentTape.getCode());
        objLabel.setAlternativeCode(this.workerCurrentTape.getAlternativeCode());
        objLabel.setBucket(this.workerCurrentTape.getBucket());
        objLabel.setType(this.workerCurrentTape.getType());
        File labelFile = null;
        try {
            Path tmpPath = Paths.get(this.inputTarPath, "tmp");
            Files.createDirectories(tmpPath, new FileAttribute[0]);
            String fileName = TAPE_LABEL + GUIDFactory.newGUID().getId();
            labelFile = tmpPath.resolve(fileName).toFile();
            JsonHandler.writeAsFile((Object)objLabel, (File)labelFile);
            this.doWriteFileToTape("tmp/" + fileName, labelFile.length());
            this.workerCurrentTape.setLabel(objLabel);
            this.retryable().execute(() -> this.doUpdateTapeCatalog(this.workerCurrentTape));
        }
        catch (ReadWriteException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode(), e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(labelFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)labelFile);
    }

    private void doWriteFileToTape(String filePath, long writtenBytes) throws ReadWriteException {
        try {
            this.tapeLibraryService.write(filePath, writtenBytes, this.workerCurrentTape);
        }
        catch (ReadWriteException e) {
            if (e.getReadWriteErrorCode() == ReadWriteErrorCode.KO_ON_WRITE_TO_TAPE) {
                this.retryable().execute(this::tapeBackToCatalog);
            }
            throw e;
        }
    }

    private void doUpdateTapeCatalog(TapeCatalog tapeCatalog) throws ReadWriteException {
        try {
            this.tapeCatalogService.replace(tapeCatalog);
        }
        catch (TapeCatalogException e) {
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + ", Error: while update tape catalog", e, ReadWriteErrorCode.KO_DB_PERSIST);
        }
    }

    private void tapeBackToCatalog() throws ReadWriteException {
        ParametersChecker.checkParameter((String)(this.MSG_PREFIX + ", Error: tape to update in the catalog is null."), (Object[])new Object[]{this.workerCurrentTape});
        try {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("current_location", this.workerCurrentTape.getPreviousLocation());
            updates.put("tape_state", this.workerCurrentTape.getTapeState().name());
            updates.put("queue_state", QueueState.READY.name());
            this.tapeCatalogService.update(this.workerCurrentTape.getId(), updates);
        }
        catch (TapeCatalogException e) {
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + ", Error: while update tape catalog", e, ReadWriteErrorCode.KO_DB_PERSIST);
        }
    }

    private RetryableOnException<Void, ReadWriteException> retryable() {
        RetryableParameters parameters = new RetryableParameters(3, 20, 20, 5, TimeUnit.MILLISECONDS);
        return new RetryableOnException(parameters);
    }

    private void doWrite(File file) throws ReadWriteException {
        if (null == this.workerCurrentTape.getLabel()) {
            this.tryWriteLabelToTape();
        }
        this.doWriteFileToTape(this.writeOrder.getFilePath(), file.length());
        this.retryable().execute(() -> this.doUpdateTapeCatalog(this.workerCurrentTape));
    }

    @Override
    public ReadWriteResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return CompletableFuture.supplyAsync(this::get, (Executor)VitamThreadPoolExecutor.getDefaultExecutor()).get(timeout, unit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    private void reportWaitTime() {
        long waitTimeInSeconds = Duration.between(LocalDateUtil.now(), LocalDateUtil.parseMongoFormattedDate((String)this.writeOrder.getCreated())).get(ChronoUnit.SECONDS);
        ((Histogram.Child)ReadWriteOrderMetrics.WRITE_ORDER_WAIT_TIME_BEFORE_EXECUTION.labels(new String[]{this.writeOrder.getBucket()})).observe((double)waitTimeInSeconds);
    }

    private /* synthetic */ void lambda$get$0() throws ReadWriteException {
        this.doUpdateTapeCatalog(this.workerCurrentTape);
    }
}

