/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.worker;

import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.tapelibrary.ReadWritePriority;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.ReadOrder;
import fr.gouv.vitam.storage.engine.common.model.ReadWriteOrder;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestManager;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.spec.QueueRepository;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryPool;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveOrderConsumer;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveOrderProducer;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TapeDriveWorkerManager
implements TapeDriveOrderConsumer,
TapeDriveOrderProducer {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeDriveWorkerManager.class);
    private static final String TAPE_DRIVE_WORKER = "TapeDriveWorker_";
    private final QueueRepository readWriteQueue;
    private final List<TapeDriveWorker> workers;
    private final Map<Integer, OptimisticDriveResourceStatus> optimisticDriveResourceStatusMap = new ConcurrentHashMap<Integer, OptimisticDriveResourceStatus>();

    public TapeDriveWorkerManager(QueueRepository readWriteQueue, ArchiveReferentialRepository archiveReferentialRepository, AccessRequestManager accessRequestManager, TapeLibraryPool tapeLibraryPool, Map<Integer, TapeCatalog> driveTape, String inputTarPath, boolean forceOverrideNonEmptyCartridges, ArchiveCacheStorage archiveCacheStorage, TapeCatalogService tapeCatalogService, Integer fullCartridgeDetectionThresholdInMB) {
        ParametersChecker.checkParameter((String)"All params is required required", (Object[])new Object[]{tapeLibraryPool, readWriteQueue, archiveReferentialRepository, accessRequestManager, driveTape, archiveCacheStorage, tapeCatalogService});
        if (fullCartridgeDetectionThresholdInMB == null || fullCartridgeDetectionThresholdInMB <= 0 || fullCartridgeDetectionThresholdInMB > 1000000000) {
            throw new IllegalArgumentException("Invalid fullCartridgeDetectionThresholdInMB param");
        }
        this.readWriteQueue = readWriteQueue;
        this.workers = new ArrayList<TapeDriveWorker>();
        for (Map.Entry<Integer, TapeDriveService> driveEntry : tapeLibraryPool.drives()) {
            TapeDriveWorker tapeDriveWorker = new TapeDriveWorker(tapeLibraryPool, driveEntry.getValue(), tapeCatalogService, this, archiveReferentialRepository, accessRequestManager, driveTape.get(driveEntry.getKey()), inputTarPath, forceOverrideNonEmptyCartridges, archiveCacheStorage, fullCartridgeDetectionThresholdInMB);
            this.workers.add(tapeDriveWorker);
        }
    }

    public void startWorkers() {
        for (TapeDriveWorker tapeDriveWorker : this.workers) {
            Thread thread = VitamThreadFactory.getInstance().newThread((Runnable)tapeDriveWorker);
            thread.setName(TAPE_DRIVE_WORKER + tapeDriveWorker.getIndex());
            thread.start();
            LOGGER.debug("Start worker :" + thread.getName());
        }
    }

    public void shutdown() {
        ArrayList completableFutures = new ArrayList();
        this.workers.forEach(w -> completableFutures.add(CompletableFuture.runAsync(() -> {
            try {
                w.stop();
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during worker shutdown", (Throwable)e);
            }
        }, (Executor)VitamThreadPoolExecutor.getDefaultExecutor())));
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[this.workers.size()])).join();
    }

    public void shutdown(long timeout, TimeUnit timeUnit) {
        ArrayList completableFutures = new ArrayList();
        this.workers.forEach(w -> completableFutures.add(CompletableFuture.runAsync(() -> {
            try {
                w.stop(timeout, timeUnit);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during worker shutdown", (Throwable)e);
            }
        }, (Executor)VitamThreadPoolExecutor.getDefaultExecutor())));
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[this.workers.size()])).join();
    }

    @Override
    public QueueRepository getQueue() {
        return this.readWriteQueue;
    }

    @Override
    public Optional<? extends ReadWriteOrder> consume(TapeDriveWorker driveWorker) throws QueueException {
        return this.produce(driveWorker);
    }

    @Override
    public synchronized Optional<? extends ReadWriteOrder> produce(TapeDriveWorker driveWorker) throws QueueException {
        Optional<? extends ReadWriteOrder> readWriteOrder;
        OptimisticDriveResourceStatus optimisticDriveResourceStatus = this.optimisticDriveResourceStatusMap.computeIfAbsent(driveWorker.getIndex(), i -> new OptimisticDriveResourceStatus());
        optimisticDriveResourceStatus.lastBucket = driveWorker.getCurrentTape() != null ? driveWorker.getCurrentTape().getBucket() : null;
        optimisticDriveResourceStatus.lastTapeCode = driveWorker.getCurrentTape() != null ? driveWorker.getCurrentTape().getCode() : null;
        optimisticDriveResourceStatus.targetBucket = null;
        optimisticDriveResourceStatus.targetTapeCode = null;
        ReadWritePriority readWritePriority = driveWorker.getPriority();
        switch (readWritePriority) {
            case BACKUP: {
                readWriteOrder = this.selectReadWriteOrderWithBackupPriority(driveWorker);
                break;
            }
            case WRITE: {
                readWriteOrder = this.selectReadWriteOrderWithWritePriority(driveWorker);
                break;
            }
            case READ: {
                readWriteOrder = this.selectReadWriteOrderByReadPriority(driveWorker);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported priority " + readWritePriority);
            }
        }
        if (readWriteOrder.isPresent()) {
            if (readWriteOrder.get().isWriteOrder()) {
                WriteOrder writeOrder = (WriteOrder)readWriteOrder.get();
                optimisticDriveResourceStatus.targetBucket = writeOrder.getBucket();
                optimisticDriveResourceStatus.targetTapeCode = null;
            } else {
                ReadOrder readOrder = (ReadOrder)readWriteOrder.get();
                optimisticDriveResourceStatus.targetBucket = readOrder.getBucket();
                optimisticDriveResourceStatus.targetTapeCode = readOrder.getTapeCode();
            }
        }
        return readWriteOrder;
    }

    private Optional<? extends ReadWriteOrder> selectReadWriteOrderWithWritePriority(TapeDriveWorker driveWorker) throws QueueException {
        Optional<Object> order = Optional.empty();
        if (driveWorker.getCurrentTape() != null && (order = this.selectWriteOrderByBucket(driveWorker.getCurrentTape().getBucket())).isEmpty()) {
            order = this.selectReadOrderByTapeCode(driveWorker.getCurrentTape().getCode());
        }
        if (order.isEmpty()) {
            order = this.selectWriteOrderExcludingActiveBuckets();
        }
        if (order.isEmpty()) {
            order = this.selectOrder(QueueMessageType.WriteOrder);
        }
        if (order.isEmpty()) {
            order = this.selectReadOrderExcludingTapeCodes();
        }
        return order;
    }

    private Optional<? extends ReadWriteOrder> selectReadWriteOrderWithBackupPriority(TapeDriveWorker driveWorker) throws QueueException {
        Optional<? extends ReadWriteOrder> order = this.selectOrder(QueueMessageType.WriteBackupOrder);
        if (order.isEmpty()) {
            return this.selectReadWriteOrderWithWritePriority(driveWorker);
        }
        return order;
    }

    private Optional<? extends ReadWriteOrder> selectReadWriteOrderByReadPriority(TapeDriveWorker driveWorker) throws QueueException {
        Optional<Object> order = Optional.empty();
        if (driveWorker.getCurrentTape() != null && (order = this.selectReadOrderByTapeCode(driveWorker.getCurrentTape().getCode())).isEmpty()) {
            order = this.selectWriteOrderByBucket(driveWorker.getCurrentTape().getBucket());
        }
        if (order.isEmpty()) {
            order = this.selectReadOrderExcludingTapeCodes();
        }
        if (order.isEmpty()) {
            order = this.selectWriteOrderExcludingActiveBuckets();
        }
        if (order.isEmpty()) {
            order = this.selectOrder(QueueMessageType.WriteOrder);
        }
        return order;
    }

    private Optional<? extends ReadWriteOrder> selectWriteOrderByBucket(String bucket) throws QueueException {
        return this.readWriteQueue.receive(Filters.eq((String)"bucket", (Object)bucket), QueueMessageType.WriteOrder);
    }

    private Optional<? extends ReadWriteOrder> selectOrder(QueueMessageType queueMessageType) throws QueueException {
        return this.readWriteQueue.receive(queueMessageType);
    }

    private Optional<? extends ReadWriteOrder> selectReadOrderByTapeCode(String tapeCode) throws QueueException {
        return this.readWriteQueue.receive(Filters.eq((String)"tapeCode", (Object)tapeCode), QueueMessageType.ReadOrder);
    }

    private Optional<? extends ReadWriteOrder> selectWriteOrderExcludingActiveBuckets() throws QueueException {
        Set activeBuckets = Stream.concat(this.optimisticDriveResourceStatusMap.values().stream().map(optimisticDriveResourceStatus -> optimisticDriveResourceStatus.targetBucket), this.optimisticDriveResourceStatusMap.values().stream().map(optimisticDriveResourceStatus -> optimisticDriveResourceStatus.lastBucket)).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.readWriteQueue.receive(Filters.nin((String)"bucket", activeBuckets), QueueMessageType.WriteOrder);
    }

    private Optional<? extends ReadWriteOrder> selectReadOrderExcludingTapeCodes() throws QueueException {
        Set activeTapeCodes = Stream.concat(this.optimisticDriveResourceStatusMap.values().stream().map(optimisticDriveResourceStatus -> optimisticDriveResourceStatus.targetTapeCode), this.optimisticDriveResourceStatusMap.values().stream().map(optimisticDriveResourceStatus -> optimisticDriveResourceStatus.lastTapeCode)).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.readWriteQueue.receive(Filters.nin((String)"tapeCode", activeTapeCodes), QueueMessageType.ReadOrder);
    }

    public void initializeOnBootstrap() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.workers.size(), (ThreadFactory)VitamThreadFactory.getInstance());
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        for (TapeDriveWorker worker : this.workers) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    Thread.currentThread().setName("BootstrapThreadDrive" + worker.getIndex());
                    LOGGER.info("Initializing drive " + worker.getIndex());
                    worker.initializeOnBootstrap();
                }
                catch (Exception e) {
                    LOGGER.error("Could not initialize worker " + worker.getIndex(), (Throwable)e);
                    throw new RuntimeException("Could not initialize worker " + worker.getIndex(), e);
                }
            }, executorService);
            completableFutures.add(completableFuture);
        }
        CompletableFuture.allOf((CompletableFuture[])completableFutures.toArray(CompletableFuture[]::new)).join();
        executorService.shutdown();
    }

    public int getTotalWorkerCount() {
        return this.workers.size();
    }

    public int getInterruptedWorkerCount() {
        return (int)this.workers.stream().filter(Predicate.not(TapeDriveWorker::isRunning)).count();
    }

    private static class OptimisticDriveResourceStatus {
        private String lastTapeCode;
        private String lastBucket;
        private String targetTapeCode;
        private String targetBucket;

        private OptimisticDriveResourceStatus() {
        }
    }
}

