/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.worker;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.storage.tapelibrary.ReadWritePriority;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.engine.common.model.ReadWriteOrder;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestManager;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveSpec;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteErrorCode;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteException;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.impl.readwrite.TapeLibraryServiceImpl;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeRobotPool;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveOrderConsumer;
import fr.gouv.vitam.storage.offers.tape.worker.tasks.ReadWriteResult;
import fr.gouv.vitam.storage.offers.tape.worker.tasks.ReadWriteTask;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.time.StopWatch;

public class TapeDriveWorker
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeDriveWorker.class);
    private static final int MAX_ATTEMPTS = 3;
    private static final int RETRY_WAIT_SECONDS = 10;
    private static final int RANDOM_RANGE_SLEEP = 5;
    private static long sleepTime = 10000L;
    private static final long intervalDelayLogInProgressWorker = VitamConfiguration.getIntervalDelayLogInProgressWorker();
    private final String msgPrefix;
    private final TapeDriveOrderConsumer receiver;
    private final TapeRobotPool tapeRobotPool;
    private final TapeDriveService tapeDriveService;
    private final TapeLibraryService tapeLibraryService;
    private final TapeCatalogService tapeCatalogService;
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final AccessRequestManager accessRequestManager;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final boolean forceOverrideNonEmptyCartridges;
    private ReadWriteResult readWriteResult;
    private final CountDownLatch shutdownSignal;
    private final String inputTarPath;
    private final ArchiveCacheStorage archiveCacheStorage;

    @VisibleForTesting
    public TapeDriveWorker(TapeRobotPool tapeRobotPool, TapeDriveService tapeDriveService, TapeCatalogService tapeCatalogService, TapeDriveOrderConsumer receiver, ArchiveReferentialRepository archiveReferentialRepository, AccessRequestManager accessRequestManager, TapeCatalog currentTape, String inputTarPath, long sleepTime, boolean forceOverrideNonEmptyCartridges, ArchiveCacheStorage archiveCacheStorage, int fullCartridgeDetectionThresholdInMB) {
        ParametersChecker.checkParameter((String)"All params is required required", (Object[])new Object[]{tapeRobotPool, tapeDriveService, archiveReferentialRepository, accessRequestManager, tapeCatalogService, receiver, archiveCacheStorage});
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.accessRequestManager = accessRequestManager;
        this.tapeCatalogService = tapeCatalogService;
        this.inputTarPath = inputTarPath;
        this.tapeRobotPool = tapeRobotPool;
        this.tapeDriveService = tapeDriveService;
        this.receiver = receiver;
        this.tapeLibraryService = new TapeLibraryServiceImpl(tapeDriveService, tapeRobotPool, fullCartridgeDetectionThresholdInMB);
        this.forceOverrideNonEmptyCartridges = forceOverrideNonEmptyCartridges;
        this.archiveCacheStorage = archiveCacheStorage;
        this.shutdownSignal = new CountDownLatch(1);
        TapeDriveWorker.sleepTime = sleepTime;
        if (null != currentTape) {
            this.readWriteResult = new ReadWriteResult();
            this.readWriteResult.setCurrentTape(currentTape);
        }
        this.msgPrefix = String.format("[Library] : %s, [Drive] : %s, ", tapeRobotPool.getLibraryIdentifier(), tapeDriveService.getTapeDriveConf().getIndex());
    }

    public TapeDriveWorker(TapeRobotPool tapeRobotPool, TapeDriveService tapeDriveService, TapeCatalogService tapeCatalogService, TapeDriveOrderConsumer receiver, ArchiveReferentialRepository archiveReferentialRepository, AccessRequestManager accessRequestManager, TapeCatalog currentTape, String inputTarPath, boolean forceOverrideNonEmptyCartridges, ArchiveCacheStorage archiveCacheStorage, int fullCartridgeDetectionThresholdInMB) {
        this(tapeRobotPool, tapeDriveService, tapeCatalogService, receiver, archiveReferentialRepository, accessRequestManager, currentTape, inputTarPath, sleepTime, forceOverrideNonEmptyCartridges, archiveCacheStorage, fullCartridgeDetectionThresholdInMB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            StopWatch exceptionStopWatch = null;
            StopWatch loopStopWatch = StopWatch.createStarted();
            StopWatch inProgressWorkerStopWatch = StopWatch.createStarted();
            while (!this.stopRequested.get()) {
                ReadWriteOrder readWriteOrder;
                block20: {
                    LOGGER.debug(this.msgPrefix + "Start take readWriteOrder from queue ");
                    readWriteOrder = null;
                    loopStopWatch.reset();
                    loopStopWatch.start();
                    try {
                        Optional<? extends ReadWriteOrder> order = this.receiver.consume(this);
                        if (order.isPresent()) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(this.msgPrefix + "Process write order :" + JsonHandler.unprettyPrint((Object)order.get()));
                            }
                            readWriteOrder = order.get();
                        }
                    }
                    catch (QueueException e) {
                        if (null == exceptionStopWatch) {
                            LOGGER.error((Throwable)e);
                            exceptionStopWatch = StopWatch.createStarted();
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(this.msgPrefix + "Sleep " + sleepTime + " ms because of exception : ", (Throwable)e);
                        }
                        TimeUnit.MILLISECONDS.sleep(sleepTime);
                        if (exceptionStopWatch.getTime(TimeUnit.MINUTES) < 1L) break block20;
                        LOGGER.error((Throwable)e);
                        exceptionStopWatch.reset();
                        exceptionStopWatch.start();
                    }
                }
                if (readWriteOrder != null) {
                    exceptionStopWatch = null;
                    TapeCatalog currentTape = this.readWriteResult != null ? this.readWriteResult.getCurrentTape() : null;
                    ReadWriteTask readWriteTask = new ReadWriteTask(readWriteOrder, currentTape, this.tapeLibraryService, this.tapeCatalogService, this.archiveReferentialRepository, this.accessRequestManager, this.inputTarPath, this.forceOverrideNonEmptyCartridges, this.archiveCacheStorage);
                    this.readWriteResult = readWriteTask.get();
                    currentTape = this.readWriteResult.getCurrentTape();
                    QueueState orderState = this.readWriteResult.getOrderState();
                    String orderId = readWriteOrder.getId();
                    switch (orderState) {
                        case ERROR: {
                            this.retryable().exec(() -> this.receiver.getQueue().markError(orderId));
                            break;
                        }
                        case READY: {
                            this.retryable().exec(() -> this.receiver.getQueue().markReady(orderId));
                            break;
                        }
                        case COMPLETED: {
                            this.retryable().exec(() -> this.receiver.getQueue().remove(orderId));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(this.msgPrefix + "Order should have state Completed, Ready or Error");
                        }
                    }
                    PerformanceLogger.getInstance().log("STP_Offer_Tape", ((QueueMessageEntity)readWriteOrder).getId(), readWriteOrder.isWriteOrder() ? "WRITE_TO_TAPE" : "READ_FROM_TAPE", loopStopWatch.getTime(TimeUnit.MILLISECONDS));
                    if (!StatusCode.FATAL.equals((Object)this.readWriteResult.getStatus())) continue;
                    throw new VitamRuntimeException(String.format("[Library] : %s, [Drive] : %s, [Tape]: %s, is stopped because of FATAL status when executing order: %s", this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex(), currentTape == null ? "No active tape" : currentTape.getCode(), JsonHandler.unprettyPrint((Object)readWriteOrder)));
                }
                String msg = this.msgPrefix + "No read/write to tape order found. waiting (" + sleepTime + ") ms ...";
                if (inProgressWorkerStopWatch.getTime(TimeUnit.MILLISECONDS) >= intervalDelayLogInProgressWorker) {
                    inProgressWorkerStopWatch.reset();
                    inProgressWorkerStopWatch.start();
                    LOGGER.warn(msg);
                } else {
                    LOGGER.debug(msg);
                }
                TimeUnit.MILLISECONDS.sleep(sleepTime);
            }
        }
        catch (Throwable e) {
            LOGGER.error(this.msgPrefix + " Worker FAILED with error", e);
        }
        finally {
            this.isStopped.set(true);
            this.shutdownSignal.countDown();
        }
    }

    private RetryableOnException<Long, QueueException> retryable() {
        return new RetryableOnException(new RetryableParameters(3, 10, 10, 5, TimeUnit.SECONDS));
    }

    public void stop() {
        LOGGER.warn(String.format("[Library] : %s, [Drive] : %s, stopping ....", this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex()));
        this.stopRequested.compareAndSet(false, true);
        try {
            this.shutdownSignal.await();
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
            Thread.currentThread().interrupt();
        }
        LOGGER.warn(String.format("[Library] : %s, [Drive] : %s, stopped ....", this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex()));
    }

    public void stop(long timeout, TimeUnit timeUnit) throws TimeoutException {
        LOGGER.warn(String.format("[Library] : %s, [Drive] : %s, stopping ....", this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex()));
        this.stopRequested.compareAndSet(false, true);
        try {
            if (!this.shutdownSignal.await(timeout, timeUnit)) {
                throw new TimeoutException(String.format("[Library] : %s, [Drive] : %s, Stopping drive worker took too long (timeout %d %s)....", new Object[]{this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex(), timeout, timeUnit}));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
            Thread.currentThread().interrupt();
        }
        LOGGER.warn(String.format("[Library] : %s, [Drive] : %s, stopped ....", this.tapeRobotPool.getLibraryIdentifier(), this.tapeDriveService.getTapeDriveConf().getIndex()));
    }

    public boolean isRunning() {
        return !this.isStopped.get();
    }

    public int getIndex() {
        return this.tapeDriveService.getTapeDriveConf().getIndex();
    }

    ReadWritePriority getPriority() {
        return this.tapeDriveService.getTapeDriveConf().getReadWritePriority();
    }

    ReadWriteResult getReadWriteResult() {
        return this.readWriteResult;
    }

    TapeCatalog getCurrentTape() {
        return this.readWriteResult == null ? null : this.readWriteResult.getCurrentTape();
    }

    public void initializeOnBootstrap() throws ReadWriteException, TapeCatalogException {
        TapeCatalog currentTape = this.getCurrentTape();
        LOGGER.info(this.msgPrefix + "Checking drive " + this.tapeLibraryService.getDriveIndex() + " on bootstrap");
        TapeDriveSpec driveStatus = this.tapeLibraryService.getDriveStatus(ReadWriteErrorCode.KO_ON_STATUS);
        if (currentTape != null && !driveStatus.driveHasTape()) {
            throw new IllegalStateException(this.msgPrefix + "Drive " + this.getIndex() + " should contain a tape " + currentTape.getCode() + " but no tape found in drive. Possible drive ejected but not unloaded?");
        }
        if (currentTape == null) {
            LOGGER.info(this.msgPrefix + "Drive " + this.tapeLibraryService.getDriveIndex() + " is empty on bootstrap");
            return;
        }
        LOGGER.warn(this.msgPrefix + "Found a tape " + currentTape.getCode() + " with " + currentTape.getTapeState() + " state on drive " + this.tapeLibraryService.getDriveIndex() + " on bootstrap");
        this.tapeLibraryService.rewindTape(currentTape);
        switch (currentTape.getTapeState()) {
            case EMPTY: {
                LOGGER.info(this.msgPrefix + "Ensuring tape is empty...");
                this.tapeLibraryService.ensureTapeIsEmpty(currentTape, this.forceOverrideNonEmptyCartridges);
                break;
            }
            case OPEN: 
            case FULL: {
                LOGGER.info(this.msgPrefix + "Read and validate tape label...");
                this.tapeLibraryService.checkNonEmptyTapeLabel(currentTape);
                break;
            }
            case CONFLICT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + currentTape.getTapeState());
            }
        }
        this.tapeCatalogService.replace(currentTape);
    }

    @VisibleForTesting
    public static void updateInactivitySleepDelayForTesting() {
        sleepTime = 100L;
    }
}

