/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.utils;

import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;

public final class QueryCriteriaUtils {
    private QueryCriteriaUtils() {
    }

    public static List<Bson> criteriaToMongoFilters(List<QueryCriteria> criteria) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        for (QueryCriteria criterion : criteria) {
            switch (criterion.getOperator()) {
                case EQ: {
                    filters.add(Filters.eq((String)criterion.getField(), (Object)criterion.getValue()));
                    break;
                }
                case GT: {
                    filters.add(Filters.gt((String)criterion.getField(), (Object)criterion.getValue()));
                    break;
                }
                case GTE: {
                    filters.add(Filters.gte((String)criterion.getField(), (Object)criterion.getValue()));
                    break;
                }
                case LT: {
                    filters.add(Filters.lt((String)criterion.getField(), (Object)criterion.getValue()));
                    break;
                }
                case LTE: {
                    filters.add(Filters.lte((String)criterion.getField(), (Object)criterion.getValue()));
                }
            }
        }
        return filters;
    }
}

