/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.offers.tape.TapeLibraryFactory;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/offer/v1")
@ApplicationPath(value="webresources")
@Tag(name="Tape")
public class TapeCatalogResource
extends ApplicationStatusResource {
    private static final String MISSING_THE_TAPE_ID = "Missing the tape ID or wrong ID";
    private static final String MISSING_THE_SEARCH_CRITERIA = "Missing or wrong search criteria";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeCatalogResource.class);
    private final TapeCatalogService tapeCatalogService;

    @VisibleForTesting
    public TapeCatalogResource(TapeCatalogService tapeCatalogService) {
        LOGGER.debug("TapeCatalogService initialized");
        this.tapeCatalogService = tapeCatalogService;
    }

    public TapeCatalogResource() {
        LOGGER.debug("TapeCatalogService initialized");
        this.tapeCatalogService = TapeLibraryFactory.getInstance().getTapeCatalogService();
    }

    @GET
    @Path(value="/tapecatalog/{tapeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="return tape model from catalog", description="Permet de r\u00e9cup\u00e9rer la cassette de stockage \u00e0 partir du catalogue")
    public Response getTape(@PathParam(value="tapeId") String tapeId) {
        try {
            if (Strings.isNullOrEmpty((String)tapeId)) {
                LOGGER.error(MISSING_THE_TAPE_ID);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            RequestResponseOK responseOK = new RequestResponseOK();
            TapeCatalog tapeCatalog = this.tapeCatalogService.findById(tapeId);
            if (tapeCatalog == null) {
                LOGGER.error(String.format("Tape with id %s not found", tapeId));
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            responseOK.addAllResults(Arrays.asList(JsonHandler.toJsonNode((Object)tapeCatalog)));
            LOGGER.debug("Result {}", (Object)responseOK);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseOK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/tapecatalog/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="return tapes list from catalog", description="Permet de r\u00e9cup\u00e9rer la liste des cassettes de stockage \u00e0 partir du catalogue")
    public Response getTapes(List<QueryCriteria> criteria) {
        try {
            if (criteria == null || criteria.isEmpty()) {
                LOGGER.error(MISSING_THE_SEARCH_CRITERIA);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            RequestResponseOK responseOK = new RequestResponseOK();
            responseOK.addAllResults(Arrays.asList(JsonHandler.toJsonNode(this.tapeCatalogService.find(criteria))));
            LOGGER.debug("Result {}", (Object)responseOK);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseOK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @PUT
    @Path(value="/tapecatalog/tapeId")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="replace tape model by id", description="Permet de remplacer enti\u00e8rement une cassette de stockage \u00e0 partir d'un id")
    public Response replaceTape(@PathParam(value="tapeId") String tapeId, TapeCatalog tapeCatalog) {
        try {
            if (Strings.isNullOrEmpty((String)tapeId)) {
                LOGGER.error(MISSING_THE_TAPE_ID);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            boolean replaced = this.tapeCatalogService.replace(tapeCatalog);
            if (!replaced) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @PUT
    @Path(value="/tapecatalog/tapeId")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="update tape model by id", description="Permet de modifier une cassette de stockage \u00e0 partir d'un id")
    public Response updateTape(@PathParam(value="tapeId") String tapeId, Map<String, Object> fields) {
        try {
            if (Strings.isNullOrEmpty((String)tapeId)) {
                LOGGER.error(MISSING_THE_TAPE_ID);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (fields == null || fields.isEmpty()) {
                LOGGER.error(MISSING_THE_SEARCH_CRITERIA);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            boolean updated = this.tapeCatalogService.update(tapeId, fields);
            if (!updated) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/tapecatalog/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="create a tape model", description="Permet de cr\u00e9er une cassette de stockage")
    public Response createTape(TapeCatalog tapeCatalog) {
        try {
            RequestResponseOK responseOK = new RequestResponseOK();
            this.tapeCatalogService.create(tapeCatalog);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseOK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

