/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.process;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.offers.tape.process.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.internal.Strings;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class ProcessExecutor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessExecutor.class);
    private static final ProcessExecutor instance = new ProcessExecutor();

    public static ProcessExecutor getInstance() {
        return instance;
    }

    public Output execute(String commandPath, long timeoutInMilliseconds, List<String> args) {
        return this.execute(commandPath, false, timeoutInMilliseconds, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output execute(String commandPath, boolean redirectStreamToFile, long timeoutInMilliseconds, List<String> args) {
        Output result;
        ArrayList command = Lists.newArrayList((Object[])new String[]{commandPath});
        if (!CollectionUtils.isEmpty(args)) {
            command.addAll(args);
        }
        String operationId = GUIDFactory.newGUID().toString();
        LOGGER.info("[" + operationId + "] < Running '" + Strings.join((Iterable)command, (String)"' '") + "' with timeout " + timeoutInMilliseconds);
        Stopwatch started = Stopwatch.createStarted();
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = null;
        File cmd_stdout = null;
        File cmd_stderr = null;
        try {
            boolean processExit;
            if (redirectStreamToFile) {
                cmd_stderr = File.createTempFile("cmd_stderr_", GUIDFactory.newGUID().getId(), new File(VitamConfiguration.getVitamTmpFolder()));
                cmd_stdout = File.createTempFile("cmd_stdout_", GUIDFactory.newGUID().getId(), new File(VitamConfiguration.getVitamTmpFolder()));
                processBuilder.redirectError(cmd_stderr);
                processBuilder.redirectOutput(cmd_stdout);
            }
            result = (processExit = (process = processBuilder.start()).waitFor(timeoutInMilliseconds, TimeUnit.MILLISECONDS)) ? new Output(process, process.exitValue(), processBuilder, cmd_stdout, cmd_stderr) : new Output(process, -1, processBuilder, cmd_stdout, cmd_stderr);
        }
        catch (Exception e) {
            try {
                result = new Output(e, process, processBuilder, cmd_stdout, cmd_stderr);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(cmd_stdout);
                FileUtils.deleteQuietly(cmd_stderr);
                throw throwable;
            }
            FileUtils.deleteQuietly(cmd_stdout);
            FileUtils.deleteQuietly((File)cmd_stderr);
        }
        FileUtils.deleteQuietly((File)cmd_stdout);
        FileUtils.deleteQuietly((File)cmd_stderr);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + operationId + "] Response details : " + JsonHandler.unprettyPrint((Object)result));
        }
        if (0 == result.getExitCode()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[" + operationId + "] > Success (" + started.elapsed(TimeUnit.MILLISECONDS) + " ms): " + JsonHandler.unprettyPrint((Object)result));
            } else {
                LOGGER.info("[" + operationId + "] > Success (" + started.elapsed(TimeUnit.MILLISECONDS) + " ms)");
            }
        } else {
            LOGGER.error("[" + operationId + "] > KO " + JsonHandler.unprettyPrint((Object)result) + " (" + started.elapsed(TimeUnit.MILLISECONDS) + " ms)");
        }
        return result;
    }
}

