/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.parser;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.storage.offers.tape.dto.TapeCartridge;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDrive;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibraryState;
import fr.gouv.vitam.storage.offers.tape.dto.TapeSlot;
import fr.gouv.vitam.storage.offers.tape.dto.TapeSlotType;
import org.apache.commons.lang3.StringUtils;

public class TapeLibraryStatusParser {
    private static final String DRIVE_VOLUME_TAG = ":VolumeTag = ";
    private static final String SLOT_VOLUME_TAG = ":VolumeTag=";
    private static final String DRIVE_ALTERNATE_VOLUME_TAG = ":AlternateVolumeTag = ";
    private static final String SLOT_ALTERNATE_VOLUME_TAG = ":AlternateVolumeTag=";
    private static final String STORAGE_CHANGER = "Storage Changer";
    private static final String SEPARATOR = ":";
    private static final String DRIVES = "Drives,";
    private static final String SLOTS = "Slots ( ";
    private static final String IMPORT_EXPORT = "Import/Export";
    private static final String IMPORT_EXPORT_TAG = " IMPORT/EXPORT";
    private static final String FULL_UNKNOWN_STORAGE_ELEMENT_LOADED = "Full (Unknown Storage Element Loaded)";
    private static final String STORAGE_ELEMENT = "Storage Element";
    private static final String LOADED = "Loaded";
    private static final String EMPTY = ":Empty";
    private static final String DATA_TRANSFER_ELEMENT = "Data Transfer Element";

    public TapeLibraryState parse(String output) {
        ParametersChecker.checkParameter((String)"Output param is required", (String[])new String[]{output});
        TapeLibraryState tapeLibraryState = new TapeLibraryState();
        for (String s : output.split("\n")) {
            TapeCartridge cartridge;
            if (s.trim().startsWith(STORAGE_ELEMENT)) {
                TapeSlot tapeSlot = new TapeSlot();
                tapeLibraryState.addToSlots(tapeSlot);
                this.extractSlotIndexAndType(s, tapeSlot);
                if (s.contains(EMPTY)) continue;
                cartridge = new TapeCartridge();
                tapeSlot.setTape(cartridge);
                this.extractSlotVolumeTag(s, cartridge);
                continue;
            }
            if (s.trim().startsWith(DATA_TRANSFER_ELEMENT)) {
                TapeDrive tapeDrive = new TapeDrive();
                tapeLibraryState.addToDrives(tapeDrive);
                this.extractDriveIndex(s, tapeDrive);
                if (s.contains(EMPTY)) continue;
                cartridge = new TapeCartridge();
                tapeDrive.setTape(cartridge);
                this.extractCartridgeSlotIndex(s, cartridge);
                this.extractDriveVolumeTag(s, cartridge);
                continue;
            }
            if (!s.trim().startsWith(STORAGE_CHANGER)) continue;
            this.extractHeader(tapeLibraryState, s);
        }
        return tapeLibraryState;
    }

    private void extractCartridgeSlotIndex(String s, TapeCartridge cartridge) {
        if (!s.contains(FULL_UNKNOWN_STORAGE_ELEMENT_LOADED)) {
            String slotIndex = StringUtils.substringBetween((String)s, (String)STORAGE_ELEMENT, (String)LOADED);
            cartridge.setSlotIndex(Integer.valueOf(slotIndex.trim()));
        }
    }

    private void extractSlotIndexAndType(String s, TapeSlot tapeSlot) {
        String slotIndex;
        if (s.contains(IMPORT_EXPORT_TAG)) {
            slotIndex = StringUtils.substringBetween((String)s, (String)STORAGE_ELEMENT, (String)IMPORT_EXPORT_TAG);
            tapeSlot.setStorageElementType(TapeSlotType.IMPORTEXPORT);
        } else {
            slotIndex = StringUtils.substringBetween((String)s, (String)STORAGE_ELEMENT, (String)SEPARATOR);
            tapeSlot.setStorageElementType(TapeSlotType.SLOT);
        }
        tapeSlot.setIndex(Integer.valueOf(slotIndex.trim()));
    }

    private void extractDriveIndex(String s, TapeDrive tapeDrive) {
        String driveIndex = StringUtils.substringBetween((String)s, (String)DATA_TRANSFER_ELEMENT, (String)SEPARATOR);
        tapeDrive.setIndex(Integer.valueOf(driveIndex.trim()));
    }

    private void extractHeader(TapeLibraryState tapeLibraryState, String s) {
        String device = StringUtils.substringBetween((String)s, (String)STORAGE_CHANGER, (String)SEPARATOR);
        String driveCount = StringUtils.substringBetween((String)s, (String)SEPARATOR, (String)DRIVES);
        String slotsCount = StringUtils.substringBetween((String)s, (String)DRIVES, (String)SLOTS);
        String mailBoxCount = StringUtils.substringBetween((String)s, (String)SLOTS, (String)IMPORT_EXPORT);
        tapeLibraryState.setDevice(device.trim());
        tapeLibraryState.setDriveCount(Integer.parseInt(driveCount.trim()));
        tapeLibraryState.setSlotsCount(Integer.parseInt(slotsCount.trim()));
        tapeLibraryState.setMailBoxCount(Integer.parseInt(mailBoxCount.trim()));
    }

    private void extractDriveVolumeTag(String s, TapeCartridge cartridge) {
        if (s.contains(DRIVE_VOLUME_TAG) && s.contains(DRIVE_ALTERNATE_VOLUME_TAG)) {
            cartridge.setVolumeTag(StringUtils.substringBetween((String)s, (String)DRIVE_VOLUME_TAG, (String)DRIVE_ALTERNATE_VOLUME_TAG).trim());
            cartridge.setAlternateVolumeTag(StringUtils.substringAfterLast((String)s, (String)DRIVE_ALTERNATE_VOLUME_TAG).trim());
        } else if (s.contains(DRIVE_VOLUME_TAG)) {
            cartridge.setVolumeTag(StringUtils.substringAfterLast((String)s, (String)DRIVE_VOLUME_TAG).trim());
        }
    }

    private void extractSlotVolumeTag(String s, TapeCartridge cartridge) {
        if (s.contains(SLOT_VOLUME_TAG) && s.contains(SLOT_ALTERNATE_VOLUME_TAG)) {
            cartridge.setVolumeTag(StringUtils.substringBetween((String)s, (String)SLOT_VOLUME_TAG, (String)SLOT_ALTERNATE_VOLUME_TAG).trim());
            cartridge.setAlternateVolumeTag(StringUtils.substringAfterLast((String)s, (String)SLOT_ALTERNATE_VOLUME_TAG).trim());
        } else if (s.contains(SLOT_VOLUME_TAG)) {
            cartridge.setVolumeTag(StringUtils.substringAfterLast((String)s, (String)SLOT_VOLUME_TAG).trim());
        }
    }
}

