/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.metrics;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.TapeState;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.impl.catalog.TapeCatalogRepository;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TapeCatalogMetrics {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeCatalogMetrics.class);

    private TapeCatalogMetrics() {
    }

    public static void initializeMetrics(final TapeCatalogRepository tapeCatalogRepository) {
        Collector collector = new Collector(){

            public List<Collector.MetricFamilySamples> collect() {
                try {
                    Map<TapeState, Integer> stats = tapeCatalogRepository.countByState();
                    ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
                    mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("vitam_offer_tape_state_empty", "Total number of tapes with EMPTY state", (double)stats.getOrDefault(TapeState.EMPTY, 0).intValue()));
                    mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("vitam_offer_tape_state_open", "Total number of tapes with OPEN state", (double)stats.getOrDefault(TapeState.OPEN, 0).intValue()));
                    mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("vitam_offer_tape_state_full", "Total number of tapes with FULL state", (double)stats.getOrDefault(TapeState.FULL, 0).intValue()));
                    mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("vitam_offer_tape_state_conflict", "Total number of tapes with CONFLICT state", (double)stats.getOrDefault(TapeState.CONFLICT, 0).intValue()));
                    return mfs;
                }
                catch (TapeCatalogException e) {
                    LOGGER.error("Could not get tape catalog stats", (Throwable)e);
                    return Collections.emptyList();
                }
            }
        };
        collector.register();
    }
}

