/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.metrics;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.impl.queue.QueueRepositoryImpl;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OrderQueueMetrics {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OrderQueueMetrics.class);

    private OrderQueueMetrics() {
    }

    public static void initializeMetrics(final QueueRepositoryImpl queueRepository) {
        Collector collector = new Collector(){

            public List<Collector.MetricFamilySamples> collect() {
                try {
                    Map<Pair<QueueState, QueueMessageType>, Integer> stats = queueRepository.countByStateAndType();
                    ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_read_orders_ready_count", "Number of read orders with READY state", QueueState.READY, List.of(QueueMessageType.ReadOrder));
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_read_orders_running_count", "Number of read orders with RUNNING state", QueueState.RUNNING, List.of(QueueMessageType.ReadOrder));
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_read_orders_error_count", "Number of read orders with ERROR state", QueueState.ERROR, List.of(QueueMessageType.ReadOrder));
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_write_orders_ready_count", "Number of write orders with READY state", QueueState.READY, List.of(QueueMessageType.WriteOrder, QueueMessageType.WriteBackupOrder));
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_write_orders_running_count", "Number of write orders with RUNNING state", QueueState.RUNNING, List.of(QueueMessageType.WriteOrder, QueueMessageType.WriteBackupOrder));
                    OrderQueueMetrics.addMetrics(mfs, stats, "vitam_offer_tape_write_orders_error_count", "Number of write orders with ERROR state", QueueState.ERROR, List.of(QueueMessageType.WriteOrder, QueueMessageType.WriteBackupOrder));
                    return mfs;
                }
                catch (QueueException e) {
                    LOGGER.error("Could not get order queue stats", (Throwable)e);
                    return Collections.emptyList();
                }
            }
        };
        collector.register();
    }

    private static void addMetrics(List<Collector.MetricFamilySamples> mfs, Map<Pair<QueueState, QueueMessageType>, Integer> stats, String metricName, String help, QueueState queueState, List<QueueMessageType> queueMessageTypes) {
        GaugeMetricFamily gaugeMetricFamily = new GaugeMetricFamily(metricName, help, Collections.emptyList());
        int total = 0;
        for (QueueMessageType queueMessageType : queueMessageTypes) {
            total += stats.getOrDefault(new ImmutablePair((Object)queueState, (Object)queueMessageType), 0).intValue();
        }
        gaugeMetricFamily.addMetric(Collections.emptyList(), (double)total);
        mfs.add((Collector.MetricFamilySamples)gaugeMetricFamily);
    }
}

