/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.metrics;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.GaugeUtils;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.AccessRequestReferentialException;

public class AccessRequestMetrics {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessRequestMetrics.class);

    private AccessRequestMetrics() {
    }

    public static void initializeMetrics(AccessRequestReferentialRepository accessRequestRepository) {
        GaugeUtils.createCustomGauge((String)"vitam_offer_tape_access_requests_ready_count", (String)"Number of READY access requests", () -> {
            try {
                return accessRequestRepository.countReadyAccessRequests();
            }
            catch (AccessRequestReferentialException e) {
                LOGGER.error("Could not get READY access request count", (Throwable)e);
                return null;
            }
        }).register();
        GaugeUtils.createCustomGauge((String)"vitam_offer_tape_access_requests_non_ready_count", (String)"Number of NON READY access requests", () -> {
            try {
                return accessRequestRepository.countNonReadyAccessRequests();
            }
            catch (AccessRequestReferentialException e) {
                LOGGER.error("Could not get NON READY access request count", (Throwable)e);
                return null;
            }
        }).register();
        GaugeUtils.createCustomGauge((String)"vitam_offer_tape_access_requests_expired_count", (String)"Number of EXPIRED access requests", () -> {
            try {
                return accessRequestRepository.countExpiredAccessRequests();
            }
            catch (AccessRequestReferentialException e) {
                LOGGER.error("Could not get EXPIRED access request count", (Throwable)e);
                return null;
            }
        }).register();
    }
}

