/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.drive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.tapelibrary.TapeDriveConf;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveSpec;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCommandException;
import fr.gouv.vitam.storage.offers.tape.parser.TapeDriveStatusParser;
import fr.gouv.vitam.storage.offers.tape.process.Output;
import fr.gouv.vitam.storage.offers.tape.process.ProcessExecutor;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveCommandService;
import java.util.ArrayList;
import java.util.List;

public class MtTapeLibraryService
implements TapeDriveCommandService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MtTapeLibraryService.class);
    public static final String F = "-f";
    public static final String STATUS = "status";
    public static final String FSF = "fsf";
    public static final String BSFM = "bsfm";
    public static final String REWIND = "rewind";
    public static final String EOD = "eod";
    public static final String OFFLINE = "offline";
    private final TapeDriveConf tapeDriveConf;
    private final ProcessExecutor processExecutor;

    public MtTapeLibraryService(TapeDriveConf tapeDriveConf) {
        this(tapeDriveConf, ProcessExecutor.getInstance());
    }

    @VisibleForTesting
    public MtTapeLibraryService(TapeDriveConf tapeDriveConf, ProcessExecutor processExecutor) {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{tapeDriveConf, processExecutor});
        this.tapeDriveConf = tapeDriveConf;
        this.processExecutor = processExecutor;
    }

    @Override
    public TapeDriveSpec status() throws TapeCommandException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeDriveConf.getDevice(), STATUS});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        Output output = this.processExecutor.execute(this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args);
        return this.parseTapeDriveState(output);
    }

    @Override
    public void move(int position, boolean isBackward) throws TapeCommandException {
        ParametersChecker.checkParameter((String)"Arguments position is required", (Object[])new Object[]{position});
        if (position < 1) {
            throw new TapeCommandException("position should be a positive integer");
        }
        List<String> args = isBackward ? this.buildMoveBackwardArgs(position) : this.buildMoveForwardArgs(position);
        Output output = this.processExecutor.execute(this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not move tape " + position + " entries " + (isBackward ? "backward" : "forward") + " in device " + this.tapeDriveConf.getDevice(), output);
        }
    }

    private List<String> buildMoveForwardArgs(int position) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeDriveConf.getDevice(), FSF, String.valueOf(position)});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        return args;
    }

    private List<String> buildMoveBackwardArgs(int position) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeDriveConf.getDevice(), BSFM, String.valueOf(position + 1)});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        return args;
    }

    @Override
    public void rewind() throws TapeCommandException {
        this.execute(REWIND);
    }

    @Override
    public void goToEnd() throws TapeCommandException {
        this.execute(EOD);
    }

    @Override
    public void eject() throws TapeCommandException {
        this.execute(OFFLINE);
    }

    private void execute(String option) throws TapeCommandException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeDriveConf.getDevice(), option});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        Output output = this.processExecutor.execute(this.tapeDriveConf.getMtPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not execute command " + option + " on device " + this.tapeDriveConf.getDevice(), output);
        }
    }

    private TapeDriveSpec parseTapeDriveState(Output output) throws TapeCommandException {
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not retrieve status for drive " + this.tapeDriveConf.getDevice(), output);
        }
        TapeDriveStatusParser tapeDriveStatusParser = new TapeDriveStatusParser();
        return tapeDriveStatusParser.parse(output.getStdout());
    }
}

