/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.catalog;

import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.database.server.query.QueryCriteriaOperator;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.engine.common.model.TapeLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLocationType;
import fr.gouv.vitam.storage.engine.common.model.TapeState;
import fr.gouv.vitam.storage.offers.tape.dto.TapeDrive;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibrarySpec;
import fr.gouv.vitam.storage.offers.tape.dto.TapeSlot;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.impl.catalog.TapeCatalogRepository;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;

public class TapeCatalogServiceImpl
implements TapeCatalogService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeCatalogServiceImpl.class);
    private final TapeCatalogRepository tapeCatalogRepository;

    public TapeCatalogServiceImpl(TapeCatalogRepository tapeCatalogRepository) {
        this.tapeCatalogRepository = tapeCatalogRepository;
    }

    @Override
    public void create(TapeCatalog tapeCatalog) throws TapeCatalogException {
        tapeCatalog.setId(GUIDFactory.newGUID().toString());
        this.tapeCatalogRepository.createTape(tapeCatalog);
    }

    @Override
    public boolean replace(TapeCatalog tapeCatalog) throws TapeCatalogException {
        return this.tapeCatalogRepository.replaceTape(tapeCatalog);
    }

    @Override
    public boolean update(String tapeId, Map<String, Object> criteria) throws TapeCatalogException {
        return this.tapeCatalogRepository.updateTape(tapeId, criteria);
    }

    @Override
    public Map<Integer, TapeCatalog> init(String tapeLibraryIdentifier, TapeLibrarySpec libraryState) throws TapeCatalogException {
        TapeCatalog existingTape;
        TapeCatalog tape2;
        QueryCriteria criteria = new QueryCriteria("library", (Object)tapeLibraryIdentifier, QueryCriteriaOperator.EQ);
        Map<String, TapeCatalog> existingTapes = this.tapeCatalogRepository.findTapes(List.of(criteria)).stream().collect(Collectors.toMap(TapeCatalog::getCode, tape -> tape));
        HashMap<Integer, TapeCatalog> driveTape = new HashMap<Integer, TapeCatalog>();
        for (TapeDrive drive : libraryState.getDrives()) {
            if (drive.getTape() == null) continue;
            tape2 = new TapeCatalog();
            tape2.setCode(drive.getTape().getVolumeTag());
            tape2.setAlternativeCode(drive.getTape().getAlternateVolumeTag());
            tape2.setLibrary(tapeLibraryIdentifier);
            existingTape = existingTapes.remove(tape2.getCode());
            TapeLocationType slotLocation = drive.getTape().getSlotIndex() <= libraryState.getSlotsCount() ? TapeLocationType.SLOT : TapeLocationType.IMPORTEXPORT;
            this.createOrUpdateTape(tape2, existingTape, new TapeLocation(drive.getTape().getSlotIndex(), slotLocation), new TapeLocation(drive.getIndex(), TapeLocationType.DRIVE));
            String tapeGuid = tape2.getId();
            if (null != existingTape) {
                tapeGuid = existingTape.getId();
            }
            driveTape.put(drive.getIndex(), this.findById(tapeGuid));
        }
        for (TapeSlot slot : libraryState.getSlots()) {
            if (slot.getTape() == null) continue;
            tape2 = new TapeCatalog();
            tape2.setCode(slot.getTape().getVolumeTag());
            tape2.setAlternativeCode(slot.getTape().getAlternateVolumeTag());
            tape2.setLibrary(tapeLibraryIdentifier);
            existingTape = existingTapes.remove(tape2.getCode());
            TapeLocation tapeLocationInit = new TapeLocation(slot.getIndex(), slot.getStorageElementType().getTapeLocationType());
            if (null == existingTape) {
                LOGGER.info("A new tape (" + slot.getTape().getVolumeTag() + ") found in " + slot.getStorageElementType().getTapeLocationType() + " slot " + slot.getIndex() + ". It will be added to catalog");
            } else if (tapeLocationInit.equals(existingTape.getCurrentLocation())) {
                LOGGER.info("Tape (" + slot.getTape().getVolumeTag() + ") has found in " + slot.getStorageElementType().getTapeLocationType() + " slot " + slot.getIndex() + ". Tape location matches last known location.");
            } else {
                LOGGER.warn("Tape (" + existingTape.getCode() + ") location changed. Catalog location : " + JsonHandler.unprettyPrint((Object)existingTape.getCurrentLocation()) + " Robot status command location: " + JsonHandler.unprettyPrint((Object)tapeLocationInit) + ". This tape may have conflict!");
            }
            this.createOrUpdateTape(tape2, existingTape, tapeLocationInit, tapeLocationInit);
        }
        existingTapes.values().forEach(tape -> {
            LOGGER.warn("Tape (" + tape.getCode() + ") with  NOT FOUND in tape library ! Last catalog location : " + JsonHandler.unprettyPrint((Object)tape.getCurrentLocation()) + ", last tape state : " + tape.getTapeState());
            tape.setCurrentLocation(new TapeLocation(Integer.valueOf(-1), TapeLocationType.OUTSIDE));
            tape.setTapeState(TapeState.CONFLICT);
            try {
                this.tapeCatalogRepository.replaceTape((TapeCatalog)tape);
            }
            catch (TapeCatalogException e) {
                String errorMsg = String.format("Error while updating tape %s", tape.getCode());
                throw new RuntimeException(errorMsg, e);
            }
        });
        return driveTape;
    }

    private void createOrUpdateTape(TapeCatalog tape, TapeCatalog existingTape, TapeLocation previousLocation, TapeLocation currentLocation) throws TapeCatalogException {
        if (existingTape != null) {
            boolean isUpdated;
            Map<String, Object> updates = this.merge(tape, existingTape, previousLocation, currentLocation);
            if (!updates.isEmpty() && !(isUpdated = this.tapeCatalogRepository.updateTape(existingTape.getId(), updates))) {
                String errorMsg = String.format("Error when updating tape %s", tape.getCode());
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        } else {
            tape.setCurrentLocation(currentLocation);
            tape.setPreviousLocation(previousLocation);
            if (Objects.equals(currentLocation.getLocationType(), TapeLocationType.DRIVE)) {
                tape.setState(QueueState.RUNNING);
            }
            this.tapeCatalogRepository.createTape(tape);
        }
    }

    private Map<String, Object> merge(TapeCatalog tape, TapeCatalog existingTape, TapeLocation previousLocation, TapeLocation currentLocation) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        tape.setId(existingTape.getId());
        if (!Objects.equals(existingTape.getAlternativeCode(), tape.getAlternativeCode())) {
            updates.put("alternative_code", tape.getAlternativeCode());
        }
        if (!Objects.equals(existingTape.getLibrary(), tape.getLibrary())) {
            updates.put("library", tape.getLibrary());
        }
        if (!Objects.equals(existingTape.getPreviousLocation(), previousLocation)) {
            updates.put("previous_location", previousLocation);
        }
        if (!Objects.equals(existingTape.getCurrentLocation(), currentLocation)) {
            TapeLocationType locationTypeInDB = existingTape.getCurrentLocation().getLocationType();
            TapeLocationType locationTypeInit = currentLocation.getLocationType();
            switch (locationTypeInit) {
                case DRIVE: {
                    if (Objects.equals(locationTypeInDB, TapeLocationType.SLOT)) {
                        updates.put("queue_state", QueueState.RUNNING.getState());
                    }
                    updates.put("current_location", currentLocation);
                    break;
                }
                case SLOT: 
                case IMPORTEXPORT: {
                    if (Objects.equals(locationTypeInDB, TapeLocationType.DRIVE) && Objects.equals(existingTape.getState(), QueueState.RUNNING)) {
                        updates.put("queue_state", QueueState.READY.getState());
                    }
                    updates.put("current_location", currentLocation);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown or robot status command should not return, such tapeLocationType :" + locationTypeInit);
                }
            }
            updates.put("current_location", currentLocation);
        }
        return updates;
    }

    @Override
    public TapeCatalog findById(String tapeId) throws TapeCatalogException {
        return this.tapeCatalogRepository.findTapeById(tapeId);
    }

    @Override
    public List<TapeCatalog> find(List<QueryCriteria> criteria) throws TapeCatalogException {
        return this.tapeCatalogRepository.findTapes(criteria);
    }

    @Override
    public void markReady(String queueId) throws QueueException {
        this.tapeCatalogRepository.markReady(queueId);
    }

    @Override
    public Optional<TapeCatalog> receive(Bson inQuery) throws QueueException {
        return this.tapeCatalogRepository.receive(inQuery, QueueMessageType.TapeCatalog);
    }
}

