/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.dto;

import fr.gouv.vitam.storage.offers.tape.dto.TapeDriveStatus;
import java.util.List;

public interface TapeDriveSpec {
    public String getDescription();

    public Integer getFileNumber();

    public String getCartridge();

    public Integer getErrorCountSinceLastStatus();

    public List<TapeDriveStatus> getDriveStatuses();

    default public boolean isBeginOfTape() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.BOT);
    }

    default public boolean needCleanDrive() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.CLN);
    }

    default public boolean isEndOfData() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.EOD);
    }

    default public boolean isEndOfFile() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.EOF);
    }

    default public boolean isSetMark() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.SM);
    }

    default public boolean hasDensity() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.D_800) || this.getDriveStatuses().contains((Object)TapeDriveStatus.D_6250) || this.getDriveStatuses().contains((Object)TapeDriveStatus.D_1600);
    }

    default public boolean isWormTape() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.WR_PROT);
    }

    default public boolean isEmptyDrive() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.DR_OPEN);
    }

    default public boolean driveHasTape() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.ONLINE);
    }

    default public boolean isCacheEnabled() {
        return this.getDriveStatuses().contains((Object)TapeDriveStatus.IM_REP_EN);
    }
}

