/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.stream.ExtendedFileOutputStream;
import fr.gouv.vitam.common.stream.SizedInputStream;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.TapeArchiveReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryBuildingOnDiskArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryOnTapeArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryReadyOnDiskArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.TarFileRapairer;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreator;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class WriteOrderCreatorBootstrapRecovery {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WriteOrderCreatorBootstrapRecovery.class);
    private final String inputTarStorageFolder;
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final BucketTopologyHelper bucketTopologyHelper;
    private final WriteOrderCreator writeOrderCreator;
    private final TarFileRapairer tarFileRapairer;
    private final ArchiveCacheStorage archiveCacheStorage;

    public WriteOrderCreatorBootstrapRecovery(String inputTarStorageFolder, ArchiveReferentialRepository archiveReferentialRepository, BucketTopologyHelper bucketTopologyHelper, WriteOrderCreator writeOrderCreator, TarFileRapairer tarFileRapairer, ArchiveCacheStorage archiveCacheStorage) {
        this.inputTarStorageFolder = inputTarStorageFolder;
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.bucketTopologyHelper = bucketTopologyHelper;
        this.writeOrderCreator = writeOrderCreator;
        this.tarFileRapairer = tarFileRapairer;
        this.archiveCacheStorage = archiveCacheStorage;
    }

    public void initializeOnBootstrap() {
        try {
            Path fileBucketTarStoragePath = Paths.get(this.inputTarStorageFolder, new String[0]).resolve("backup-db");
            if (fileBucketTarStoragePath.toFile().exists()) {
                this.recoverFileBucket("backup-db", fileBucketTarStoragePath);
            }
            for (String fileBucket : this.bucketTopologyHelper.listFileBuckets()) {
                fileBucketTarStoragePath = Paths.get(this.inputTarStorageFolder, new String[0]).resolve(fileBucket);
                if (!fileBucketTarStoragePath.toFile().exists()) continue;
                this.recoverFileBucket(fileBucket, fileBucketTarStoragePath);
            }
        }
        catch (Exception e) {
            throw new VitamRuntimeException("Could not reschedule tar files to copy on tape", (Throwable)e);
        }
    }

    private void recoverFileBucket(String fileBucket, Path fileBucketArchiveStoragePath) throws IOException, ArchiveReferentialException, ObjectReferentialException, QueueException, IllegalPathException {
        Map<String, FileGroup> archiveFileGroups = this.getFileListGroupedByArchiveId(fileBucketArchiveStoragePath);
        List<String> archiveFileNames = this.cleanupIncompleteFiles(fileBucketArchiveStoragePath, archiveFileGroups);
        this.sortFilesByCreationDate(archiveFileNames);
        for (String archiveFileName : archiveFileNames) {
            if (archiveFileName.endsWith(".tar") || archiveFileName.endsWith(".zip")) {
                this.processReadyArchive(fileBucket, fileBucketArchiveStoragePath, archiveFileName);
                continue;
            }
            if (archiveFileName.endsWith(".tmp")) {
                this.repairArchive(fileBucketArchiveStoragePath, archiveFileName, fileBucket);
                continue;
            }
            throw new IllegalStateException("Invalid file extension " + archiveFileName);
        }
    }

    private Map<String, FileGroup> getFileListGroupedByArchiveId(Path fileBucketArchiveStoragePath) throws IOException {
        HashMap<String, FileGroup> archiveFileNames = new HashMap<String, FileGroup>();
        try (Stream<Path> archiveFileStream = Files.list(fileBucketArchiveStoragePath);){
            archiveFileStream.map(filePath -> filePath.getFileName().toString()).forEach(archiveFileName -> {
                String archiveId = LocalFileUtils.archiveFileNamePathToArchiveId(archiveFileName);
                FileGroup fileGroup = archiveFileNames.computeIfAbsent(archiveId, f -> new FileGroup());
                if (archiveFileName.endsWith(".tmp")) {
                    fileGroup.tmpFileName = archiveFileName;
                } else {
                    fileGroup.readyFileName = archiveFileName;
                }
            });
        }
        return archiveFileNames;
    }

    private List<String> cleanupIncompleteFiles(Path fileBucketTarStoragePath, Map<String, FileGroup> archiveFileGroups) throws IOException {
        ArrayList<String> tarFileNames = new ArrayList<String>();
        for (FileGroup fileGroup : archiveFileGroups.values()) {
            if (fileGroup.tmpFileName != null) {
                boolean backupFiles = fileGroup.tmpFileName.endsWith(".zip");
                if (fileGroup.readyFileName == null && backupFiles) {
                    LOGGER.warn("Deleting potential incomplete file " + fileGroup.tmpFileName);
                    Files.delete(fileBucketTarStoragePath.resolve(fileGroup.tmpFileName));
                    fileGroup.tmpFileName = null;
                    continue;
                }
                if (fileGroup.readyFileName != null) {
                    LOGGER.warn("Deleting incomplete file " + fileGroup.readyFileName);
                    Files.delete(fileBucketTarStoragePath.resolve(fileGroup.readyFileName));
                    fileGroup.readyFileName = null;
                }
                tarFileNames.add(fileGroup.tmpFileName);
                continue;
            }
            LOGGER.info("Found ready file " + fileGroup.readyFileName);
            tarFileNames.add(fileGroup.readyFileName);
        }
        return tarFileNames;
    }

    private void sortFilesByCreationDate(List<String> archiveFileNames) {
        archiveFileNames.sort((filename1, filename2) -> {
            String creationDate2;
            String archiveId1 = LocalFileUtils.archiveFileNamePathToArchiveId(filename1);
            String archiveId2 = LocalFileUtils.archiveFileNamePathToArchiveId(filename1);
            String creationDate1 = LocalFileUtils.getCreationDateFromArchiveId(archiveId1);
            int compare = creationDate1.compareTo(creationDate2 = LocalFileUtils.getCreationDateFromArchiveId(archiveId2));
            if (compare != 0) {
                return compare;
            }
            return filename1.compareTo((String)filename2);
        });
    }

    private void processReadyArchive(String fileBucket, Path fileBucketArchiveStoragePath, String archiveId) throws ArchiveReferentialException, IOException, ObjectReferentialException, QueueException, IllegalPathException {
        Path archiveFile = fileBucketArchiveStoragePath.resolve(archiveId);
        Optional<TapeArchiveReferentialEntity> tarReferentialEntity = this.archiveReferentialRepository.find(archiveId);
        if (tarReferentialEntity.isEmpty()) {
            throw new IllegalStateException("Unknown archive file in Archive referential '" + archiveFile + "'");
        }
        if (tarReferentialEntity.get().getLocation() instanceof TapeLibraryOnTapeArchiveStorageLocation) {
            if (this.archiveCacheStorage.containsArchive(fileBucket, archiveId)) {
                LOGGER.warn("Archive file {}/{} already written on tape, and in cache. Deleting it", (Object)fileBucket, (Object)archiveFile);
                Files.delete(archiveFile);
            } else {
                LOGGER.warn("Archive file {}/{} already written on tape, moving it to cache", (Object)fileBucket, (Object)archiveFile);
                this.archiveCacheStorage.reserveArchiveStorageSpace(fileBucket, archiveId, tarReferentialEntity.get().getSize());
                try {
                    this.archiveCacheStorage.moveArchiveToCache(archiveFile, fileBucket, archiveId);
                }
                catch (Exception e) {
                    this.archiveCacheStorage.cancelReservedArchive(fileBucket, archiveId);
                    throw e;
                }
            }
        } else if (tarReferentialEntity.get().getLocation() instanceof TapeLibraryReadyOnDiskArchiveStorageLocation) {
            LOGGER.warn("Rescheduling archive file {} for copy on tape.", (Object)archiveFile);
            this.enqueue(this.bucketTopologyHelper.getBucketFromFileBucket(fileBucket), fileBucket, archiveId, tarReferentialEntity.get().getSize(), tarReferentialEntity.get().getDigestValue());
        } else if (tarReferentialEntity.get().getLocation() instanceof TapeLibraryBuildingOnDiskArchiveStorageLocation) {
            LOGGER.warn("Check archive file & compute size & digest.", (Object)archiveFile);
            if (!"backup-db".equals(fileBucket)) {
                TarFileRapairer.DigestWithSize digestWithSize = this.verifyTarArchive(archiveFile);
                this.enqueue(this.bucketTopologyHelper.getBucketFromFileBucket(fileBucket), fileBucket, archiveId, digestWithSize.getSize(), digestWithSize.getDigestValue());
            } else {
                this.reScheduleArchive(fileBucketArchiveStoragePath, "backup", "backup-db", archiveId, 0L, null);
            }
        } else {
            throw new IllegalStateException("Invalid tar location " + tarReferentialEntity.get().getLocation().getClass() + " (" + JsonHandler.unprettyPrint(tarReferentialEntity) + ")");
        }
    }

    private TarFileRapairer.DigestWithSize verifyTarArchive(Path archiveFile) throws IOException, ObjectReferentialException {
        try (InputStream inputStream = Files.newInputStream(archiveFile, StandardOpenOption.READ);){
            TarFileRapairer.DigestWithSize digestWithSize = this.tarFileRapairer.verifyTarArchive(inputStream);
            return digestWithSize;
        }
    }

    private void repairArchive(Path fileBucketArchiveStoragePath, String tmpFileName, String fileBucket) throws IOException, ObjectReferentialException, QueueException, ArchiveReferentialException {
        long size;
        String digestValue;
        String bucket;
        Path finalFilePath;
        Path tmpFilePath;
        String archiveId;
        block12: {
            archiveId = LocalFileUtils.archiveFileNamePathToArchiveId(tmpFileName);
            tmpFilePath = fileBucketArchiveStoragePath.resolve(tmpFileName);
            finalFilePath = fileBucketArchiveStoragePath.resolve(archiveId);
            LOGGER.info("Repairing & verifying file " + tmpFilePath);
            bucket = "backup";
            digestValue = null;
            size = 0L;
            if (!"backup-db".equals(fileBucket)) {
                bucket = this.bucketTopologyHelper.getBucketFromFileBucket(fileBucket);
                try (InputStream inputStream = Files.newInputStream(tmpFilePath, StandardOpenOption.READ);
                     ExtendedFileOutputStream outputStream = new ExtendedFileOutputStream(finalFilePath, true);){
                    TarFileRapairer.DigestWithSize digestWithSize = this.tarFileRapairer.repairAndVerifyTarArchive(inputStream, (OutputStream)outputStream, archiveId);
                    digestValue = digestWithSize.getDigestValue();
                    size = digestWithSize.getSize();
                    break block12;
                }
            }
            Files.move(tmpFilePath, finalFilePath, StandardCopyOption.ATOMIC_MOVE);
        }
        Files.delete(tmpFilePath);
        LOGGER.info("Successfully repaired & verified file " + tmpFilePath + " to " + finalFilePath);
        this.reScheduleArchive(fileBucketArchiveStoragePath, bucket, fileBucket, archiveId, size, digestValue);
    }

    private void enqueue(String bucket, String fileBucket, String archiveId, long size, String digest) throws ArchiveReferentialException, QueueException {
        WriteOrder message = new WriteOrder(bucket, fileBucket, LocalFileUtils.archiveFileNameRelativeToInputArchiveStorageFolder(fileBucket, archiveId), size, digest, archiveId, QueueMessageType.WriteOrder);
        if ("backup".equals(bucket)) {
            message.setMessageType(QueueMessageType.WriteBackupOrder);
        }
        this.writeOrderCreator.sendMessageToQueue(message);
    }

    private void reScheduleArchive(Path fileBucketArchiveStoragePath, String bucket, String fileBucket, String archiveId, long size, String digestValue) throws IOException, ArchiveReferentialException, QueueException {
        Path finalFilePath = fileBucketArchiveStoragePath.resolve(archiveId);
        if (StringUtils.isEmpty((String)digestValue)) {
            Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
            try (SizedInputStream is = new SizedInputStream(Files.newInputStream(finalFilePath, StandardOpenOption.READ));){
                digest.update((InputStream)is);
                digestValue = digest.digestHex();
                size = is.getSize();
            }
        }
        this.enqueue(bucket, fileBucket, archiveId, size, digestValue);
    }

    private static class FileGroup {
        private String readyFileName;
        private String tmpFileName;

        private FileGroup() {
        }
    }
}

