/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.database.server.query.QueryCriteriaOperator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.inmemoryqueue.QueueProcessingException;
import fr.gouv.vitam.storage.offers.tape.inmemoryqueue.QueueProcessor;
import fr.gouv.vitam.storage.offers.tape.spec.QueueRepository;
import java.util.Arrays;

public class WriteOrderCreator
extends QueueProcessor<WriteOrder> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WriteOrderCreator.class);
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final QueueRepository readWriteQueue;

    public WriteOrderCreator(ArchiveReferentialRepository archiveReferentialRepository, QueueRepository readWriteQueue) {
        super("WriteOrderCreator");
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.readWriteQueue = readWriteQueue;
    }

    @Override
    protected void processMessage(WriteOrder message) throws QueueProcessingException {
        try {
            this.sendMessageToQueue(message);
        }
        catch (Exception ex) {
            throw new QueueProcessingException(QueueProcessingException.RetryPolicy.RETRY, "Could not process message " + JsonHandler.unprettyPrint((Object)message), ex);
        }
    }

    public void sendMessageToQueue(WriteOrder message) throws ArchiveReferentialException, QueueException {
        LOGGER.info("Write order generated for tar Id {} [bucket={}]", (Object)message.getArchiveId(), (Object)message.getBucket());
        this.archiveReferentialRepository.updateLocationToReadyOnDisk(message.getArchiveId(), message.getSize(), message.getDigest());
        this.readWriteQueue.addIfAbsent(Arrays.asList(new QueryCriteria("filePath", (Object)message.getFilePath(), QueryCriteriaOperator.EQ), new QueryCriteria("queue_message_type", (Object)QueueMessageType.WriteOrder.name(), QueryCriteriaOperator.EQ)), (QueueMessageEntity)message);
    }
}

