/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.stream.ExactDigestValidatorInputStream;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.storage.engine.common.model.TarEntryDescription;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;

public final class TarHelper {
    public static InputStream readEntryAtPos(FileInputStream fileInputStream, TarEntryDescription entryDescription) throws IOException {
        fileInputStream.getChannel().position(entryDescription.getStartPos());
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)fileInputStream));
        ArchiveEntry tarEntry = tarArchiveInputStream.getNextEntry();
        if (!tarEntry.getName().equals(entryDescription.getEntryName())) {
            throw new IOException("Tar entry name conflict. Expected '" + entryDescription.getEntryName() + "', found '" + tarEntry.getName() + "'");
        }
        if (tarEntry.getSize() != entryDescription.getSize()) {
            throw new IOException("Tar entry size conflict. Expected '" + entryDescription.getSize() + "', found '" + tarEntry.getSize() + "'");
        }
        return new ExactDigestValidatorInputStream((InputStream)new ExactSizeInputStream((InputStream)tarArchiveInputStream, entryDescription.getSize()), VitamConfiguration.getDefaultDigestType(), entryDescription.getDigestValue());
    }
}

