/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryObjectReferentialId;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryTarObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeObjectReferentialEntity;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ObjectReferentialRepository {
    private final MongoCollection<Document> collection;
    private final int bulkSize;

    public ObjectReferentialRepository(MongoCollection<Document> collection) {
        this(collection, VitamConfiguration.getBatchSize());
    }

    @VisibleForTesting
    ObjectReferentialRepository(MongoCollection<Document> collection, int bulkSize) {
        this.collection = collection;
        this.bulkSize = bulkSize;
    }

    public void insertOrUpdate(TapeObjectReferentialEntity tapeObjectReferentialEntity) throws ObjectReferentialException {
        try {
            this.collection.findOneAndReplace(Filters.eq((String)"_id", (Object)this.toBson(tapeObjectReferentialEntity.getId())), (Object)this.toBson(tapeObjectReferentialEntity), new FindOneAndReplaceOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new ObjectReferentialException("Could not insert or update tar referential for id " + tapeObjectReferentialEntity.getId().getContainerName() + "/" + tapeObjectReferentialEntity.getId().getObjectName(), ex);
        }
    }

    public Optional<TapeObjectReferentialEntity> find(String containerName, String objectName) throws ObjectReferentialException {
        Document document;
        try {
            document = (Document)this.collection.find(Filters.eq((String)"_id", (Object)this.toBson(new TapeLibraryObjectReferentialId(containerName, objectName)))).first();
        }
        catch (MongoException ex) {
            throw new ObjectReferentialException("Could not find storage location by id " + containerName + "/" + objectName, ex);
        }
        if (document == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.fromBson(document));
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("Could not parse document from DB " + BsonHelper.stringify((Document)document), e);
        }
    }

    public List<TapeObjectReferentialEntity> bulkFind(String containerName, Set<String> objectNames) throws ObjectReferentialException {
        if (objectNames.isEmpty()) {
            return Collections.emptyList();
        }
        UnmodifiableIterator objectNameBulks = Iterators.partition(objectNames.iterator(), (int)this.bulkSize);
        ArrayList<TapeObjectReferentialEntity> result = new ArrayList<TapeObjectReferentialEntity>();
        while (objectNameBulks.hasNext()) {
            List objectReferentialIds = ((List)objectNameBulks.next()).stream().map(objectName -> this.toBson(new TapeLibraryObjectReferentialId(containerName, objectName))).collect(Collectors.toList());
            try {
                MongoCursor iterator = this.collection.find(Filters.in((String)"_id", objectReferentialIds)).iterator();
                try {
                    while (iterator.hasNext()) {
                        Document document = (Document)iterator.next();
                        try {
                            result.add(this.fromBson(document));
                        }
                        catch (InvalidParseOperationException e) {
                            throw new IllegalStateException("Could not parse documents from DB " + BsonHelper.stringify((Document)document), e);
                        }
                    }
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
            catch (MongoException ex) {
                throw new ObjectReferentialException("Could not find storage location by ids " + objectNames + " in container " + containerName, ex);
            }
        }
        return result;
    }

    public void updateStorageLocation(String containerName, String objectName, String storageId, TapeLibraryTarObjectStorageLocation tapeLibraryTarStorageLocation) throws ObjectReferentialException {
        try {
            this.collection.updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.toBson(new TapeLibraryObjectReferentialId(containerName, objectName))), Filters.eq((String)"storageId", (Object)storageId)}), Updates.combine((Bson[])new Bson[]{Updates.set((String)"location", (Object)this.toBson(tapeLibraryTarStorageLocation)), Updates.set((String)"lastUpdateDate", (Object)LocalDateUtil.nowFormatted())}), new UpdateOptions().upsert(false));
        }
        catch (MongoException ex) {
            throw new ObjectReferentialException("Could not update storage location for " + containerName + "/" + objectName, ex);
        }
    }

    public boolean delete(TapeLibraryObjectReferentialId tapeLibraryObjectReferentialId) throws ObjectReferentialException {
        try {
            DeleteResult deleteResult = this.collection.deleteOne(Filters.eq((String)"_id", (Object)this.toBson(tapeLibraryObjectReferentialId)));
            return deleteResult.getDeletedCount() > 0L;
        }
        catch (MongoException ex) {
            throw new ObjectReferentialException("Could not delete tar referential for id " + tapeLibraryObjectReferentialId.getContainerName() + "/" + tapeLibraryObjectReferentialId.getObjectName(), ex);
        }
    }

    public Set<String> selectArchiveIdsByObjectIds(Iterator<TapeLibraryObjectReferentialId> objectIdIterator) throws ObjectReferentialException {
        UnmodifiableIterator objectIdBulkIterator = Iterators.partition(objectIdIterator, (int)this.bulkSize);
        HashSet<String> archiveIds = new HashSet<String>();
        while (objectIdBulkIterator.hasNext()) {
            List objectReferentialIds = ((List)objectIdBulkIterator.next()).stream().map(this::toBson).collect(Collectors.toList());
            List<Bson> pipeline = List.of(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", objectReferentialIds), Filters.eq((String)"location.type", (Object)"tar")})), Aggregates.project((Bson)new Document().append("_id", (Object)0).append("location.tarEntries.tarFileId", (Object)1)), Aggregates.unwind((String)"$location.tarEntries"), Aggregates.unwind((String)"$location.tarEntries.tarFileId"), Aggregates.group((Object)"$location.tarEntries.tarFileId", (BsonField[])new BsonField[0]));
            try {
                MongoCursor iterator = this.collection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).iterator();
                try {
                    while (iterator.hasNext()) {
                        Document document = (Document)iterator.next();
                        archiveIds.add(document.getString((Object)"_id"));
                    }
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
            catch (MongoException ex) {
                throw new ObjectReferentialException("Could not find archiveIds by objectIds", ex);
            }
        }
        return archiveIds;
    }

    private Document toBson(Object object) {
        return Document.parse((String)JsonHandler.unprettyPrint((Object)object));
    }

    private TapeObjectReferentialEntity fromBson(Document document) throws InvalidParseOperationException {
        return (TapeObjectReferentialEntity)BsonHelper.fromDocumentToObject((Document)document, TapeObjectReferentialEntity.class);
    }

    public CloseableIterator<ObjectEntry> listContainerObjectEntries(String containerName) throws ObjectReferentialException {
        try {
            final MongoCursor mongoCursor = this.collection.find(Filters.eq((String)"_id.containerName", (Object)containerName)).projection(Projections.include((String[])new String[]{"_id.objectName", "size"})).batchSize(VitamConfiguration.getBatchSize()).iterator();
            return new CloseableIterator<ObjectEntry>(){

                public void close() {
                    mongoCursor.close();
                }

                public boolean hasNext() {
                    return mongoCursor.hasNext();
                }

                public ObjectEntry next() {
                    Document document = (Document)mongoCursor.next();
                    Document documentId = (Document)document.get((Object)"_id");
                    return new ObjectEntry(documentId.getString((Object)"objectName"), ((Number)document.get((Object)"size", Number.class)).longValue());
                }
            };
        }
        catch (MongoException ex) {
            throw new ObjectReferentialException("Could not list objects of container " + containerName, ex);
        }
    }
}

