/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.storage.offers.tape.cas.LockHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LockManager<T> {
    private final Map<T, Integer> entryLocks = new HashMap<T, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(T entry) {
        Map<T, Integer> map = this.entryLocks;
        synchronized (map) {
            return this.entryLocks.containsKey(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHandle createLock(Set<T> entries) {
        Map<T, Integer> map = this.entryLocks;
        synchronized (map) {
            for (T entry : entries) {
                int nbLocks = this.entryLocks.getOrDefault(entry, 0);
                this.entryLocks.put(entry, nbLocks + 1);
            }
        }
        return this.createEvictionLockHandle(entries);
    }

    private LockHandle createEvictionLockHandle(final Set<T> lockedEntries) {
        return new LockHandle(){
            boolean alreadyUnlocked = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void release() {
                Map map = LockManager.this.entryLocks;
                synchronized (map) {
                    if (this.alreadyUnlocked) {
                        return;
                    }
                    for (Object entry : lockedEntries) {
                        Integer nbLocks = LockManager.this.entryLocks.get(entry);
                        if (nbLocks == null) {
                            throw new IllegalStateException("No existing lock for entry " + entry);
                        }
                        if (nbLocks == 1) {
                            LockManager.this.entryLocks.remove(entry);
                            continue;
                        }
                        LockManager.this.entryLocks.put(entry, nbLocks - 1);
                    }
                    this.alreadyUnlocked = true;
                }
            }
        };
    }
}

